/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.fs.s3.token;

import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.GetSessionTokenResult;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.fluss.fs.token.Credentials;
import org.apache.fluss.fs.token.CredentialsJsonSerde;
import org.apache.fluss.fs.token.ObtainedSecurityToken;
import org.apache.fluss.utils.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3DelegationTokenProvider {
    private static final Logger LOG = LoggerFactory.getLogger(S3DelegationTokenProvider.class);
    private static final String ACCESS_KEY_ID = "fs.s3a.access.key";
    private static final String ACCESS_KEY_SECRET = "fs.s3a.secret.key";
    private static final String REGION_KEY = "fs.s3a.region";
    private static final String ENDPOINT_KEY = "fs.s3a.endpoint";
    private final String scheme;
    private final String region;
    private final String accessKey;
    private final String secretKey;
    private final Map<String, String> additionInfos;

    public S3DelegationTokenProvider(String scheme, Configuration conf) {
        this.scheme = scheme;
        this.region = conf.get(REGION_KEY);
        Preconditions.checkNotNull((Object)this.region, (String)"Region is not set.");
        this.accessKey = conf.get(ACCESS_KEY_ID);
        this.secretKey = conf.get(ACCESS_KEY_SECRET);
        this.additionInfos = new HashMap<String, String>();
        for (String key : Arrays.asList(REGION_KEY, ENDPOINT_KEY)) {
            if (conf.get(key) == null) continue;
            this.additionInfos.put(key, conf.get(key));
        }
    }

    public ObtainedSecurityToken obtainSecurityToken() {
        LOG.info("Obtaining session credentials token with access key: {}", (Object)this.accessKey);
        AWSSecurityTokenService stsClient = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(this.region)).withCredentials(new AWSStaticCredentialsProvider(new BasicAWSCredentials(this.accessKey, this.secretKey)))).build();
        GetSessionTokenResult sessionTokenResult = stsClient.getSessionToken();
        com.amazonaws.services.securitytoken.model.Credentials credentials = sessionTokenResult.getCredentials();
        LOG.info("Session credentials obtained successfully with access key: {} expiration: {}", (Object)credentials.getAccessKeyId(), (Object)credentials.getExpiration());
        return new ObtainedSecurityToken(this.scheme, this.toJson(credentials), Long.valueOf(credentials.getExpiration().getTime()), this.additionInfos);
    }

    private byte[] toJson(com.amazonaws.services.securitytoken.model.Credentials credentials) {
        Credentials flussCredentials = new Credentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
        return CredentialsJsonSerde.toJson((Credentials)flussCredentials);
    }
}

