/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet;

import java.io.IOException;
import org.apache.paimon.format.parquet.ParquetInputStream;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.shade.org.apache.parquet.io.InputFile;
import org.apache.paimon.shade.org.apache.parquet.io.SeekableInputStream;

public class ParquetInputFile
implements InputFile {
    private final FileIO fileIO;
    private final FileStatus stat;

    public static ParquetInputFile fromPath(FileIO fileIO, Path path) throws IOException {
        return new ParquetInputFile(fileIO, fileIO.getFileStatus(path));
    }

    private ParquetInputFile(FileIO fileIO, FileStatus stat) {
        this.fileIO = fileIO;
        this.stat = stat;
    }

    public Path getPath() {
        return this.stat.getPath();
    }

    @Override
    public long getLength() {
        return this.stat.getLen();
    }

    @Override
    public SeekableInputStream newStream() throws IOException {
        return new ParquetInputStream(this.fileIO.newInputStream(this.stat.getPath()));
    }

    public String toString() {
        return this.stat.getPath().toString();
    }
}

