/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.paimon;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Config;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;
import org.apache.paimon.options.CatalogOptions;

public class PaimonConfig
extends Config {
    public static final ConfigEntry<String> CATALOG_BACKEND = new ConfigBuilder("metastore").doc(CatalogOptions.METASTORE.description().toString()).version("0.6.0").stringConf().createWithDefault((Object)((String)CatalogOptions.METASTORE.defaultValue()));
    public static final ConfigEntry<String> CATALOG_WAREHOUSE = new ConfigBuilder("warehouse").doc(CatalogOptions.WAREHOUSE.description().toString()).version("0.6.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> CATALOG_URI = new ConfigBuilder("uri").doc(CatalogOptions.URI.description().toString()).version("0.6.0").stringConf().create();
    public static final ConfigEntry<String> CATALOG_JDBC_USER = new ConfigBuilder("jdbc-user").doc("Paimon catalog jdbc user").version("0.7.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> CATALOG_JDBC_PASSWORD = new ConfigBuilder("jdbc-password").doc("Paimon catalog jdbc password").version("0.7.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> CATALOG_JDBC_DRIVER = new ConfigBuilder("jdbc-driver").doc("The driver of the Jdbc connection").version("0.7.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();

    public PaimonConfig() {
        super(false);
    }

    public PaimonConfig(Map<String, String> properties) {
        super(false);
        this.loadFromMap(properties, k -> true);
    }

    public String getJdbcDriver() {
        return (String)this.get(CATALOG_JDBC_DRIVER);
    }
}

