/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.BoundAggregate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Types;

public class AggregateEvaluator {
    private final List<BoundAggregate.Aggregator<?>> aggregators;
    private final Types.StructType resultType;
    private final List<BoundAggregate<?, ?>> aggregates;

    public static AggregateEvaluator create(Schema schema, List<Expression> aggregates) {
        return AggregateEvaluator.create(schema.asStruct(), aggregates);
    }

    public static AggregateEvaluator create(List<BoundAggregate<?, ?>> aggregates) {
        return new AggregateEvaluator(aggregates);
    }

    private static AggregateEvaluator create(Types.StructType struct, List<Expression> aggregates) {
        List<BoundAggregate<?, ?>> boundAggregates = aggregates.stream().map(expr -> Binder.bind(struct, expr)).map(bound -> (BoundAggregate)bound).collect(Collectors.toList());
        return new AggregateEvaluator(boundAggregates);
    }

    private AggregateEvaluator(List<BoundAggregate<?, ?>> aggregates) {
        ImmutableList.Builder aggregatorsBuilder = ImmutableList.builder();
        ArrayList resultFields = Lists.newArrayList();
        for (int pos = 0; pos < aggregates.size(); ++pos) {
            BoundAggregate<?, ?> aggregate = aggregates.get(pos);
            aggregatorsBuilder.add(aggregate.newAggregator());
            resultFields.add(Types.NestedField.optional(pos, aggregate.describe(), aggregate.type()));
        }
        this.aggregators = aggregatorsBuilder.build();
        this.resultType = Types.StructType.of(resultFields);
        this.aggregates = aggregates;
    }

    public void update(StructLike struct) {
        for (BoundAggregate.Aggregator<?> aggregator : this.aggregators) {
            aggregator.update(struct);
        }
    }

    public void update(DataFile file) {
        for (BoundAggregate.Aggregator<?> aggregator : this.aggregators) {
            aggregator.update(file);
        }
    }

    public Types.StructType resultType() {
        return this.resultType;
    }

    public boolean allAggregatorsValid() {
        return this.aggregators.stream().allMatch(BoundAggregate.Aggregator::isValid);
    }

    public StructLike result() {
        Object[] results = this.aggregators.stream().map(BoundAggregate.Aggregator::result).toArray(Object[]::new);
        return new ArrayStructLike(results);
    }

    public List<BoundAggregate<?, ?>> aggregates() {
        return this.aggregates;
    }

    private static class ArrayStructLike
    implements StructLike {
        private final Object[] values;

        private ArrayStructLike(Object[] values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.values[pos]);
        }

        @Override
        public <T> void set(int pos, T value) {
            this.values[pos] = value;
        }
    }
}

