/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.stats;

import java.util.Objects;
import org.apache.paimon.data.BinaryArray;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.utils.SerializationUtils;

public class BinaryTableStats {
    private final BinaryRow minValues;
    private final BinaryRow maxValues;
    private final BinaryArray nullCounts;

    public BinaryTableStats(BinaryRow minValues, BinaryRow maxValues, BinaryArray nullCounts) {
        this.minValues = minValues;
        this.maxValues = maxValues;
        this.nullCounts = nullCounts;
    }

    public BinaryRow minValues() {
        return this.minValues;
    }

    public BinaryRow maxValues() {
        return this.maxValues;
    }

    public BinaryArray nullCounts() {
        return this.nullCounts;
    }

    public InternalRow toRow() {
        return GenericRow.of((Object[])new Object[]{SerializationUtils.serializeBinaryRow(this.minValues), SerializationUtils.serializeBinaryRow(this.maxValues), this.nullCounts});
    }

    public static BinaryTableStats fromRow(InternalRow row) {
        return new BinaryTableStats(SerializationUtils.deserializeBinaryRow(row.getBinary(0)), SerializationUtils.deserializeBinaryRow(row.getBinary(1)), BinaryArray.fromLongArray((InternalArray)row.getArray(2)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryTableStats that = (BinaryTableStats)o;
        return Objects.equals(this.minValues, that.minValues) && Objects.equals(this.maxValues, that.maxValues) && Objects.equals(this.nullCounts, that.nullCounts);
    }

    public int hashCode() {
        return Objects.hash(this.minValues, this.maxValues, this.nullCounts);
    }
}

