/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.CredentialOperationDispatcher;
import org.apache.gravitino.dto.credential.CredentialDTO;
import org.apache.gravitino.dto.responses.CredentialResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/metalakes/{metalake}/objects/{type}/{fullName}/credentials")
public class MetadataObjectCredentialOperations {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataObjectCredentialOperations.class);
    private static final Set<MetadataObject.Type> supportsCredentialMetadataTypes = ImmutableSet.of((Object)MetadataObject.Type.CATALOG, (Object)MetadataObject.Type.FILESET);
    private CredentialOperationDispatcher credentialOperationDispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public MetadataObjectCredentialOperations(CredentialOperationDispatcher dispatcher) {
        this.credentialOperationDispatcher = dispatcher;
    }

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-credentials.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-credentials", absolute=true)
    public Response getCredentials(@PathParam(value="metalake") String metalake, @PathParam(value="type") String type, @PathParam(value="fullName") String fullName) {
        LOG.info("Received get credentials request for object type: {}, full name: {} under metalake: {}", new Object[]{type, fullName, metalake});
        try {
            return Utils.doAs(this.httpRequest, () -> {
                MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)type.toUpperCase(Locale.ROOT)));
                if (!MetadataObjectCredentialOperations.supportsCredentialOperations(object)) {
                    throw new NotSupportedException("Doesn't support credential operations for metadata object type");
                }
                NameIdentifier identifier = MetadataObjectUtil.toEntityIdent((String)metalake, (MetadataObject)object);
                List credentials = this.credentialOperationDispatcher.getCredentials(identifier);
                if (credentials == null) {
                    return Utils.ok(new CredentialResponse(new CredentialDTO[0]));
                }
                return Utils.ok(new CredentialResponse(DTOConverters.toDTO((Credential[])credentials.toArray(new Credential[credentials.size()]))));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleCredentialException(OperationType.GET, fullName, e);
        }
    }

    private static boolean supportsCredentialOperations(MetadataObject metadataObject) {
        return supportsCredentialMetadataTypes.contains(metadataObject.type());
    }
}

