/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.utils.DecimalUtils;

class BooleanToNumericCastRule
extends AbstractCastRule<Boolean, Object> {
    static final BooleanToNumericCastRule INSTANCE = new BooleanToNumericCastRule();

    private BooleanToNumericCastRule() {
        super(CastRulePredicate.builder().input(DataTypeRoot.BOOLEAN).target(DataTypeFamily.NUMERIC).build());
    }

    @Override
    public CastExecutor<Boolean, Object> create(DataType inputType, DataType targetType) {
        switch (targetType.getTypeRoot()) {
            case TINYINT: {
                return value -> (byte)this.toInt((boolean)value);
            }
            case SMALLINT: {
                return value -> (short)this.toInt((boolean)value);
            }
            case INTEGER: {
                return this::toInt;
            }
            case BIGINT: {
                return value -> (long)this.toInt((boolean)value);
            }
            case FLOAT: {
                return value -> Float.valueOf(this.toInt((boolean)value));
            }
            case DOUBLE: {
                return value -> (double)this.toInt((boolean)value);
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)targetType;
                return value -> DecimalUtils.castFrom((long)this.toInt((boolean)value), (int)decimalType.getPrecision(), (int)decimalType.getScale());
            }
        }
        return null;
    }

    private int toInt(boolean bool) {
        return bool ? 1 : 0;
    }
}

