/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.io.ObjectStreamException;
import org.apache.iceberg.transforms.Dates;
import org.apache.iceberg.transforms.Months;
import org.apache.iceberg.transforms.SerializationProxies;
import org.apache.iceberg.transforms.TimeTransform;
import org.apache.iceberg.transforms.Timestamps;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.TransformUtil;
import org.apache.iceberg.transforms.Years;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class Days<T>
extends TimeTransform<T> {
    private static final Days<?> INSTANCE = new Days();

    static <T> Days<T> get() {
        return INSTANCE;
    }

    @Override
    protected Transform<T, Integer> toEnum(Type type) {
        switch (type.typeId()) {
            case DATE: {
                return Dates.DAY;
            }
            case TIMESTAMP: {
                return Timestamps.DAY;
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    @Override
    public Type getResultType(Type sourceType) {
        return Types.DateType.get();
    }

    @Override
    public boolean satisfiesOrderOf(Transform<?, ?> other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Timestamps) {
            return Timestamps.DAY.satisfiesOrderOf(other);
        }
        if (other instanceof Dates) {
            return Dates.DAY.satisfiesOrderOf(other);
        }
        return other instanceof Days || other instanceof Months || other instanceof Years;
    }

    @Override
    public String toHumanString(Type alwaysDate, Integer value) {
        return value != null ? TransformUtil.humanDay(value) : "null";
    }

    public String toString() {
        return "day";
    }

    Object writeReplace() throws ObjectStreamException {
        return SerializationProxies.DaysTransformProxy.get();
    }
}

