/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.iceberg.converter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.gravitino.catalog.lakehouse.iceberg.IcebergTable;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;

public class ToIcebergTypeVisitor<T> {
    public static <T> T visit(Type type, ToIcebergTypeVisitor<T> visitor) {
        if (type instanceof Types.MapType) {
            Types.MapType map = (Types.MapType)type;
            return visitor.map(map, ToIcebergTypeVisitor.visit(map.keyType(), visitor), ToIcebergTypeVisitor.visit(map.valueType(), visitor));
        }
        if (type instanceof Types.ListType) {
            Types.ListType list = (Types.ListType)type;
            return visitor.array(list, ToIcebergTypeVisitor.visit(list.elementType(), visitor));
        }
        if (type instanceof Types.StructType) {
            Types.StructType.Field[] fields = ((Types.StructType)type).fields();
            ArrayList fieldResults = Lists.newArrayListWithExpectedSize((int)fields.length);
            for (Types.StructType.Field field : fields) {
                fieldResults.add(visitor.field(field, ToIcebergTypeVisitor.visit(field.type(), visitor)));
            }
            return visitor.struct((Types.StructType)type, fieldResults);
        }
        return visitor.atomic((Type.PrimitiveType)type);
    }

    public T struct(IcebergTable struct, List<T> fieldResults) {
        throw new UnsupportedOperationException();
    }

    public T struct(Types.StructType struct, List<T> fieldResults) {
        throw new UnsupportedOperationException();
    }

    public T field(Types.StructType.Field field, T typeResult) {
        throw new UnsupportedOperationException();
    }

    public T array(Types.ListType array, T elementResult) {
        throw new UnsupportedOperationException();
    }

    public T map(Types.MapType map, T keyResult, T valueResult) {
        throw new UnsupportedOperationException();
    }

    public T atomic(Type.PrimitiveType primitive) {
        throw new UnsupportedOperationException();
    }
}

