/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iceberg.exceptions.UnprocessableEntityException;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.rest.RESTRequest;

public class UpdateNamespacePropertiesRequest
implements RESTRequest {
    private List<String> removals;
    private Map<String, String> updates;

    public UpdateNamespacePropertiesRequest() {
    }

    private UpdateNamespacePropertiesRequest(List<String> removals, Map<String, String> updates) {
        this.removals = removals;
        this.updates = updates;
        this.validate();
    }

    @Override
    public void validate() {
        Sets.SetView commonKeys = Sets.intersection(this.updates().keySet(), (Set)Sets.newHashSet(this.removals()));
        if (!commonKeys.isEmpty()) {
            throw new UnprocessableEntityException("Invalid namespace update, cannot simultaneously set and remove keys: %s", new Object[]{commonKeys});
        }
    }

    public List<String> removals() {
        return this.removals == null ? ImmutableList.of() : this.removals;
    }

    public Map<String, String> updates() {
        return this.updates == null ? ImmutableMap.of() : this.updates;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("removals", this.removals).add("updates", this.updates).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableSet.Builder<String> removalsBuilder = ImmutableSet.builder();
        private final ImmutableMap.Builder<String, String> updatesBuilder = ImmutableMap.builder();

        private Builder() {
        }

        public Builder remove(String removal) {
            Preconditions.checkNotNull((Object)removal, (Object)"Invalid property to remove: null");
            this.removalsBuilder.add((Object)removal);
            return this;
        }

        public Builder removeAll(Collection<String> removals) {
            Preconditions.checkNotNull(removals, (Object)"Invalid list of properties to remove: null");
            Preconditions.checkArgument((!removals.contains(null) ? 1 : 0) != 0, (Object)"Invalid property to remove: null");
            this.removalsBuilder.addAll(removals);
            return this;
        }

        public Builder update(String key, String value) {
            Preconditions.checkNotNull((Object)key, (Object)"Invalid property to update: null");
            Preconditions.checkNotNull((Object)value, (String)"Invalid value to update for key [%s]: null. Use remove instead", (Object)key);
            this.updatesBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder updateAll(Map<String, String> updates) {
            Preconditions.checkNotNull(updates, (Object)"Invalid collection of properties to update: null");
            Preconditions.checkArgument((!updates.containsKey(null) ? 1 : 0) != 0, (Object)"Invalid property to update: null");
            Preconditions.checkArgument((!updates.containsValue(null) ? 1 : 0) != 0, (String)"Invalid value to update for properties %s: null. Use remove instead", Maps.filterValues(updates, Objects::isNull).keySet());
            this.updatesBuilder.putAll(updates);
            return this;
        }

        public UpdateNamespacePropertiesRequest build() {
            ImmutableList removals = this.removalsBuilder.build().asList();
            ImmutableMap updates = this.updatesBuilder.build();
            return new UpdateNamespacePropertiesRequest((List)removals, (Map)updates);
        }
    }
}

