/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.auth;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class KerberosUtils {
    public static final Oid GSS_SPNEGO_MECH_OID = KerberosUtils.getNumericOidInstance("1.3.6.1.5.5.2");
    public static final Oid GSS_KRB5_MECH_OID = KerberosUtils.getNumericOidInstance("1.2.840.113554.1.2.2");
    public static final Oid NT_GSS_KRB5_PRINCIPAL_OID = KerberosUtils.getNumericOidInstance("1.2.840.113554.1.2.2.1");

    private KerberosUtils() {
    }

    private static Oid getNumericOidInstance(String oidName) {
        try {
            return new Oid(oidName);
        }
        catch (GSSException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static LoginContext login(String principal, String keyTabFile) throws LoginException {
        HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
        principals.add(new KerberosPrincipal(principal));
        Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
        LoginContext loginContext = new LoginContext("", subject, null, new KerberosConfiguration(principal, keyTabFile));
        loginContext.login();
        return loginContext;
    }

    public static <T> T doAs(Subject subject, final Callable<T> callable) throws Exception {
        try {
            return Subject.doAs(subject, new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return callable.call();
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw ex.getException();
        }
    }

    public static String getKrb5LoginModuleName() {
        return "com.sun.security.auth.module.Krb5LoginModule";
    }

    private static class KerberosConfiguration
    extends Configuration {
        private final String principal;
        private final String keyTabFile;

        public KerberosConfiguration(String principal, String keyTabFile) {
            this.principal = principal;
            this.keyTabFile = keyTabFile;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            if (this.keyTabFile != null) {
                options.put("useKeyTab", "true");
                options.put("keyTab", this.keyTabFile);
                options.put("storeKey", "true");
            } else {
                options.put("useTicketCache", "true");
                String ticketCache = System.getenv("KRB5CCNAME");
                if (ticketCache != null) {
                    options.put("ticketCache", ticketCache);
                }
                options.put("renewTGT", "true");
            }
            options.put("principal", this.principal);
            options.put("doNotPrompt", "true");
            options.put("refreshKrb5Config", "true");
            options.put("isInitiator", "true");
            options.put("debug", "true");
            return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosUtils.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

