/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.Configuration;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.filter.Filterable;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.StringUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbDatabaseMetaData
extends Filterable
implements DatabaseMetaData {
    public DmdbConnection connection = null;
    private static final String m_esp = " ESCAPE '!' ";
    public static final int TABLE_DB_TYPE_NORMAL = 0;
    public static final int TABLE_DB_TYPE_VERTICAL = 3;
    public static final int TABLE_DB_TYPE_VERTICAL_PARTITION = 4;
    public static final int TABLE_DB_TYPE_VERTICAL_PARTITION_S = 5;
    public static final int TABLE_DB_TYPE_RANGE_PARTITION = 6;
    public static final int TABLE_DB_TYPE_RANGE_PARTITION_S = 7;
    public static final int TABLE_DB_TYPE_HASH_PARTITION = 8;
    public static final int TABLE_DB_TYPE_HASH_PARTITION_S = 9;
    public static final int TABLE_DB_TYPE_BITMAP_JOIN = 10;
    public static final int TABLE_DB_TYPE_LIST_PARTITION = 11;
    public static final int TABLE_DB_TYPE_LIST_PARTITION_S = 12;
    public static final int TABLE_DB_TYPE_EXTERNAL = 13;
    public static final int TABLE_DB_TYPE_ARR = 14;
    public static final int TABLE_DB_TYPE_REMOTE = 15;
    public static final int TABLE_DB_TYPE_HUGE = 19;
    public static final int TABLE_DB_TYPE_V_RANGE_PARTITION = 17;
    public static final int TABLE_DB_TYPE_V_RANGE_PARTITION_S = 18;
    public static final int TABLE_DB_TYPE_V_HASH_PARTITION = 20;
    public static final int TABLE_DB_TYPE_V_HASH_PARTITION_S = 21;
    public static final int TABLE_DB_TYPE_V_LIST_PARTITION = 22;
    public static final int TABLE_DB_TYPE_V_LIST_PARTITION_S = 23;
    public static final int TABLE_DB_TYPE_HUG_RANGE_PARTITION = 24;
    public static final int TABLE_DB_TYPE_HUG_RANGE_PARTITION_S = 25;
    public static final int TABLE_DB_TYPE_HUG_HASH_PARTITION = 26;
    public static final int TABLE_DB_TYPE_HUG_HASH_PARTITION_S = 27;
    public static final int TABLE_DB_TYPE_HUG_LIST_PARTITION = 28;
    public static final int TABLE_DB_TYPE_HUG_LIST_PARTITION_S = 29;
    public static final int TABLE_DB_TYPE_BITMAP = 32;
    public static final int TABLE_TEMP_TYPE_NO_TEMP = 0;
    public static final int TABLE_TEMP_TYPE_GLOBAL_TEMP = 1;
    public static final int TABLE_TEMP_TYPE_LOCAL_TEMP = 2;
    public static AtomicLong IDGenerator = new AtomicLong(0L);

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    public DmdbDatabaseMetaData(DmdbConnection dmdbConnection) {
        super(dmdbConnection, null);
        this.connection = dmdbConnection;
    }

    public DmdbResultSet do_getCatalogs() {
        String string = DmdbDatabaseMetaData.SQL_getCatalogs();
        return DriverUtil.executeQuery(this.connection, string);
    }

    public static String SQL_getCatalogs() {
        String string = "SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS TABLE_CAT FROM SYS.SYSDUAL WHERE 1=2;";
        String string2 = "/*+ gateway metadata JDBC_getCatalogs()*/ ";
        return String.valueOf(string2) + string;
    }

    public DmdbResultSet do_getSchemas() {
        String string = DmdbDatabaseMetaData.SQL_getSchemas();
        return DriverUtil.executeQuery(this.connection, string);
    }

    public static String SQL_getSchemas() {
        String string = "SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NAME AS TABLE_SCHEM, NULL AS TABLE_CATALOG ";
        string = String.valueOf(string) + " FROM SYS.SYSOBJECTS USERS WHERE TYPE$='SCH'";
        string = String.valueOf(string) + " ORDER BY TABLE_SCHEM ASC;";
        String string2 = "/*+ gateway metadata JDBC_getSchemas()*/ ";
        return String.valueOf(string2) + string;
    }

    public DmdbResultSet do_getSchemas(String string, String string2) {
        String string3 = StringUtil.isEmpty(string) ? this.connection.do_getCatalog() : StringUtil.processSingleQuoteOfName(string.trim());
        String string4 = StringUtil.isEmpty(string2) ? "%" : StringUtil.processSingleQuoteOfName(string2);
        String string5 = DmdbDatabaseMetaData.SQL_getSchemas(string3, string4);
        return DriverUtil.executeQuery(this.connection, string5);
    }

    public static String SQL_getSchemas(String string, String string2) {
        if (StringUtil.isEmpty(string) && StringUtil.isEmpty(string2)) {
            return DmdbDatabaseMetaData.SQL_getSchemas();
        }
        String string3 = "";
        string3 = StringUtil.isEmpty(string) ? "SELECT DISTINCT NAME AS TABLE_SCHEM, NULL AS TABLE_CATALOG FROM " : "SELECT DISTINCT NAME AS TABLE_SCHEM, '" + string + "' AS TABLE_CATALOG FROM ";
        string3 = DmdbDatabaseMetaData.getEscape(string2) ? (!string2.equalsIgnoreCase("%") ? String.valueOf(string3) + "SYS.SYSOBJECTS USERS WHERE TYPE$='SCH' AND NAME LIKE '" + string2 + "'" + m_esp : String.valueOf(string3) + "SYS.SYSOBJECTS USERS WHERE TYPE$='SCH' ") : String.valueOf(string3) + "SYS.SYSOBJECTS USERS WHERE TYPE$='SCH' AND NAME = '" + string2 + "'";
        string3 = String.valueOf(string3) + " ORDER BY TABLE_SCHEM ASC;";
        String string4 = "/*+ gateway metadata JDBC_getSchemas(" + DmdbDatabaseMetaData.gatewayFormat(string) + ", " + DmdbDatabaseMetaData.gatewayFormat(string2) + ")*/ ";
        return String.valueOf(string4) + string3;
    }

    public DmdbResultSet do_getTableTypes() {
        String string = DmdbDatabaseMetaData.SQL_getTableTypes();
        return DriverUtil.executeQuery(this.connection, string);
    }

    public static String SQL_getTableTypes() {
        String string = "(SELECT 'SYSTEM TABLE' AS TABLE_TYPE FROM SYS.SYSDUAL) UNION (SELECT 'TABLE' AS TABLE_TYPE FROM SYS.SYSDUAL) UNION (SELECT 'VIEW' AS TABLE_TYPE FROM SYS.SYSDUAL) UNION (SELECT 'GLOBAL TEMPORARY' AS TABLE_TYPE FROM SYS.SYSDUAL) UNION (SELECT 'LOCAL TEMPORARY' AS TABLE_TYPE FROM SYS.SYSDUAL) UNION (SELECT 'SYNONYM' AS TABLE_TYPE FROM SYS.SYSDUAL) ";
        String string2 = "/*+ gateway metadata JDBC_getTableTypes()*/ ";
        return String.valueOf(string2) + string;
    }

    public DmdbResultSet do_getTypeInfo() {
        String string = DmdbDatabaseMetaData.SQL_getTypeInfo();
        return DriverUtil.executeQuery(this.connection, string);
    }

    public static String SQL_getTypeInfo() {
        String string = "select TYPEINFO.TYPE_NAME, TYPEINFO.DATA_TYPE, TYPEINFO.PRECISION, TYPEINFO.LITERAL_PREFIX, TYPEINFO.LITERAL_SUFFIX, TYPEINFO.CREATE_PARAMS, TYPEINFO.NULLABLE, TYPEINFO.CASE_SENSITIVE, TYPEINFO.SEARCHABLE,TYPEINFO.UNSIGNED_ATTRIBUTE, TYPEINFO.FIXED_PREC_SCALE, TYPEINFO.\"AUTO_INCREMENT\", TYPEINFO.LOCAL_TYPE_NAME, TYPEINFO.MINIMUM_SCALE, TYPEINFO.MAXIMUM_SCALE, TYPEINFO.SQL_DATA_TYPE, TYPEINFO.SQL_DATETIME_SUB, TYPEINFO.NUM_PREC_RADIX from (";
        string = String.valueOf(string) + "SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT TYPE_NAME AS TYPE_NAME,";
        string = String.valueOf(string) + " CASE DATA_TYPE WHEN 101 THEN 2000 WHEN 102 THEN 2000 WHEN 103 THEN 2000 WHEN 104 THEN 2000 WHEN 105 THEN 2000 WHEN 106 THEN 2000 WHEN 107 THEN 2000 WHEN 108 THEN 2000 WHEN 109 THEN 2000 WHEN 110 THEN 2000 WHEN 111 THEN 2000 WHEN 112 THEN 2000 WHEN 113 THEN 2000 ELSE DATA_TYPE END AS DATA_TYPE,";
        string = String.valueOf(string) + " COLUMN_SIZE AS \"PRECISION\",LITERAL_PREFIX AS LITERAL_PREFIX,LITERAL_SUFFIX AS LITERAL_SUFFIX,CREATE_PARAMS AS CREATE_PARAMS,NULLABLE$ AS NULLABLE,CASE_SENSITIVE AS CASE_SENSITIVE,SEARCHABLE AS SEARCHABLE,UNSIGNED_ATTRIBUTE AS UNSIGNED_ATTRIBUTE,FIXED_PREC_SCALE AS FIXED_PREC_SCALE,AUTO_UNIQUE_VALUE AS \"AUTO_INCREMENT\",LOCAL_TYPE_NAME AS LOCAL_TYPE_NAME,MINIMUM_SCALE AS MINIMUM_SCALE,MAXIMUM_SCALE AS MAXIMUM_SCALE,NULL AS SQL_DATA_TYPE,NULL AS SQL_DATETIME_SUB,NUM_PREC_RADIX AS NUM_PREC_RADIX";
        string = String.valueOf(string) + " FROM SYS.SYSTYPEINFOS WHERE (TYPE_VERSION = 'O3' OR TYPE_VERSION = 'J3') AND TYPE_NAME <> 'double precision' AND TYPE_NAME <> 'image' AND TYPE_NAME <> 'text' AND TYPE_NAME <> 'money'";
        string = String.valueOf(string) + " ORDER BY DATA_TYPE) TYPEINFO;";
        String string2 = "/*+ gateway metadata JDBC_getTypeInfo()*/ ";
        return String.valueOf(string2) + string;
    }

    public DmdbResultSet do_getAttributes(String string, String string2, String string3, String string4) {
        String string5 = DmdbDatabaseMetaData.SQL_getAttributes(string, string2, string3, string4);
        return DriverUtil.executeQuery(this.connection, string5);
    }

    public static String SQL_getAttributes(String string, String string2, String string3, String string4) {
        String string5 = "SELECT CAST(NULL AS VARCHAR(128)) AS TYPE_CAT,CAST(NULL AS VARCHAR(128)) AS TYPE_SCHEM,CAST(NULL AS VARCHAR(128)) AS TYPE_NAME,CAST(NULL AS VARCHAR(128)) AS ATTR_NAME,CAST(NULL AS INT) AS DATA_TYPE,CAST(NULL AS VARCHAR(128)) AS ATTR_TYPE_NAME,CAST(NULL AS INT) AS ATTR_SIZE,CAST(NULL AS INT) AS DECIMAL_DIGITS,CAST(NULL AS INT) AS NUM_PREC_RADIX,CAST(NULL AS INT) AS NULLABLE,CAST(NULL AS VARCHAR(128)) AS REMARKS,CAST(NULL AS VARCHAR(128)) AS ATTR_DEF,CAST(NULL AS INT) AS SQL_DATA_TYPE,CAST(NULL AS INT) AS SQL_DATETIME_SUB,CAST(NULL AS INT) AS CHAR_OCTET_LENGTH,CAST(NULL AS INT) AS ORDINAL_POSITION,CAST(NULL AS VARCHAR(128)) AS IS_NULLABLE,CAST(NULL AS VARCHAR(128)) AS SCOPE_CATALOG,CAST(NULL AS VARCHAR(128)) AS SCOPE_SCHEMA,CAST(NULL AS VARCHAR(128)) AS SCOPE_TABLE,CAST(NULL AS SMALLINT) AS SOURCE_DATA_TYPE FROM DUAL WHERE 1 = 2";
        String string6 = "/*+ gateway metadata JDBC_getAttributes(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + "," + DmdbDatabaseMetaData.gatewayFormat(string4) + ")*/ ";
        return String.valueOf(string6) + string5;
    }

    public DmdbResultSet do_getTables(String string, String string2, String string3, String[] stringArray) {
        String string4 = DmdbDatabaseMetaData.SQL_getTables(string, string2, string3, stringArray);
        return DriverUtil.executeQuery(this.connection, string4);
    }

    public static String SQL_getTables(String string, String string2, String string3, String[] stringArray) {
        String string4 = StringUtil.isEmpty(string2) ? "%" : StringUtil.processSingleQuoteOfName(string2);
        String string5 = string3 == null ? "%" : StringUtil.processSingleQuoteOfName(string3);
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS TABLE_CAT,SCHEMAS.NAME AS TABLE_SCHEM,TABS.NAME AS TABLE_NAME, CASE TABS.SUBTYPE$ WHEN 'UTAB' THEN 'TABLE' WHEN 'VIEW' THEN 'VIEW' WHEN 'STAB' THEN 'SYSTEM TABLE' WHEN 'SYNOM' THEN 'SYNONYM' END AS TABLE_TYPE, (SELECT COMMENT$ FROM SYS.SYSTABLECOMMENTS WHERE SCHNAME = SCHEMAS.NAME AND TVNAME = TABS.NAME) AS REMARKS, NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS SELF_REFERENCING_COL_NAME, NULL AS REF_GENERATION ");
        stringBuilder.append(" FROM");
        stringBuilder.append(DmdbDatabaseMetaData.schemaClause(string4, "SCHEMAS,"));
        stringBuilder.append(DmdbDatabaseMetaData.tableClause(string5, stringArray, "TABS"));
        stringBuilder.append(" WHERE TABS.SCHID = SCHEMAS.ID ");
        stringBuilder.append(" AND (SF_CHECK_PRIV_OPT(UID(), CURRENT_USERTYPE(), TABS.ID, SCHEMAS.PID, -1, TABS.ID) = 1) ");
        stringBuilder.append(" ORDER BY TABLE_TYPE ASC,TABLE_SCHEM ASC,TABLE_NAME ASC;");
        String string6 = "/*+ gateway metadata JDBC_getTables(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + "," + DmdbDatabaseMetaData.gatewayFormat(stringArray) + ")*/ ";
        return String.valueOf(string6) + stringBuilder.toString();
    }

    public DmdbResultSet do_getTablePrivileges(String string, String string2, String string3) {
        String string4 = DmdbDatabaseMetaData.SQL_getTablePrivileges(string, string2, string3);
        return DriverUtil.executeQuery(this.connection, string4.toString());
    }

    public static String SQL_getTablePrivileges(String string, String string2, String string3) {
        String string4 = StringUtil.isEmpty(string2) ? "%" : StringUtil.processSingleQuoteOfName(string2);
        String string5 = string3 == null ? "%" : StringUtil.processSingleQuoteOfName(string3);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL AS TABLE_CAT,");
        stringBuilder.append("USERS.NAME AS TABLE_SCHEM, ");
        stringBuilder.append("TABS.NAME AS TABLE_NAME,");
        stringBuilder.append("GRANTORS.NAME AS GRANTOR,");
        stringBuilder.append("GRANTEES.NAME AS GRANTEE,");
        stringBuilder.append("SF_GET_SYS_PRIV(CAST (TVGRANTS.PRIVID AS INT)) AS PRIVILEGE,");
        stringBuilder.append("CASE TVGRANTS.GRANTABLE WHEN 'Y' THEN 'YES' WHEN 'N' THEN 'NO' END AS IS_GRANTABLE");
        stringBuilder.append(" FROM ");
        stringBuilder.append(DmdbDatabaseMetaData.schemaClause(string4, "USERS")).append(",");
        stringBuilder.append(DmdbDatabaseMetaData.tableClause_utab(string5, "TABS")).append(",");
        stringBuilder.append("(SELECT ID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'UR' AND SUBTYPE$ = 'USER')GRANTORS,");
        stringBuilder.append("(SELECT ID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'UR' AND SUBTYPE$ = 'USER')GRANTEES,");
        stringBuilder.append("(SELECT * FROM SYS.SYSGRANTS WHERE PRIVID <> -1 )TVGRANTS");
        stringBuilder.append(" WHERE");
        stringBuilder.append(" TABS.SCHID = USERS.ID AND ");
        stringBuilder.append(" TVGRANTS.OBJID = TABS.ID AND TVGRANTS.URID = GRANTEES.ID AND ");
        stringBuilder.append(" TVGRANTS.GRANTOR = GRANTORS.ID");
        stringBuilder.append(" ORDER BY  TABLE_SCHEM ASC, TABLE_NAME ASC,  PRIVILEGE ASC;");
        String string6 = "/*+ gateway metadata JDBC_getTablePrivileges(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + ")*/ ";
        return String.valueOf(string6) + stringBuilder.toString();
    }

    public DmdbResultSet do_getColumns(String string, String string2, String string3, String string4) {
        String string5 = DmdbDatabaseMetaData.SQL_getColumns(string, string2, string3, string4, this.connection.compatibleOracle());
        return DriverUtil.executeQuery(this.connection, string5);
    }

    public static String SQL_getColumns(String string, String string2, String string3, String string4, boolean bl) {
        String string5 = StringUtil.isEmpty(string2) ? "%" : StringUtil.processSingleQuoteOfName(string2);
        String string6 = string3 == null ? "%" : StringUtil.processSingleQuoteOfName(string3);
        String string7 = string4 == null ? "%" : StringUtil.processSingleQuoteOfName(string4);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT ");
        stringBuilder.append("NULL AS TABLE_CAT, ");
        stringBuilder.append("SCHS.NAME AS TABLE_SCHEM, ");
        stringBuilder.append("TABS.NAME AS TABLE_NAME, ");
        stringBuilder.append("COLS.NAME AS COLUMN_NAME, ");
        stringBuilder.append(DmdbDatabaseMetaData.makeDataTypeClause("COLS.TYPE$", "COLS.SCALE", bl));
        stringBuilder.append("AS DATA_TYPE,");
        stringBuilder.append(DmdbDatabaseMetaData.makeDataTypeNameClause("COLS.TYPE$", bl));
        stringBuilder.append("AS TYPE_NAME,");
        stringBuilder.append("CASE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END ");
        stringBuilder.append("AS COLUMN_SIZE,");
        stringBuilder.append("CASE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END ");
        stringBuilder.append("AS BUFFER_LENGTH,");
        stringBuilder.append("CASE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) END ");
        stringBuilder.append("AS DECIMAL_DIGITS,");
        stringBuilder.append("10 AS NUM_PREC_RADIX,");
        stringBuilder.append("CASE COLS.NULLABLE$ WHEN 'Y' THEN 1 ELSE 0 END AS NULLABLE,");
        stringBuilder.append("(SELECT COMMENT$ FROM SYS.SYSCOLUMNCOMMENTS WHERE SCHNAME=SCHS.NAME AND TVNAME=TABS.NAME AND COLNAME=COLS.NAME) AS REMARKS,");
        stringBuilder.append("COLS.DEFVAL AS COLUMN_DEF,");
        stringBuilder.append("0 AS SQL_DATA_TYPE,");
        stringBuilder.append("0 AS SQL_DATETIME_SUB,");
        stringBuilder.append("CASE SF_GET_OCT_LENGTH(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ").append("ELSE SF_GET_OCT_LENGTH(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT)) END ").append("AS CHAR_OCTET_LENGTH,");
        stringBuilder.append("COLS.COLID + 1 AS ORDINAL_POSITION,");
        stringBuilder.append("CASE COLS.NULLABLE$ WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE,");
        stringBuilder.append("NULL AS SCOPE_CATLOG,");
        stringBuilder.append("NULL AS SCOPE_SCHEMA,");
        stringBuilder.append("NULL AS SCOPE_TABLE,");
        stringBuilder.append("0 AS SOURCE_DATA_TYPE, ");
        stringBuilder.append("CASE COLS.INFO2 & 0x01 WHEN 1 THEN 'YES' ELSE 'NO' END AS IS_AUTOINCREMENT, ");
        stringBuilder.append("CASE (select INFO1 & 0x01 from SYS.SYSCOLINFOS where ID = COLS.ID and COLID = COLS.COLID) WHEN 1 THEN 'YES' ELSE 'NO' END AS IS_GENERATEDCOLUMN ");
        stringBuilder.append("FROM ");
        stringBuilder.append(DmdbDatabaseMetaData.schemaClause(string5, "SCHS"));
        stringBuilder.append(", ");
        stringBuilder.append(DmdbDatabaseMetaData.tableClause_tab(string6, "TABS"));
        stringBuilder.append(", ");
        stringBuilder.append(DmdbDatabaseMetaData.argClause(string7, "COLS"));
        stringBuilder.append(" WHERE TABS.ID = COLS.ID AND SCHS.ID = TABS.SCHID ");
        stringBuilder.append(" ORDER BY TABLE_SCHEM ASC,TABLE_NAME ASC,ORDINAL_POSITION ASC;");
        String string8 = "/*+ gateway metadata JDBC_getColumns(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + "," + DmdbDatabaseMetaData.gatewayFormat(string4) + ")*/ ";
        return String.valueOf(string8) + stringBuilder.toString();
    }

    public DmdbResultSet do_getColumnPrivileges(String string, String string2, String string3, String string4) {
        if (string3 == null) {
            DBError.ECJDBC_TABNAME_NULL.throwz(new Object[0]);
        }
        String string5 = StringUtil.isEmpty(string2) ? this.connection.schema : StringUtil.processSingleQuoteOfName(string2);
        String string6 = DmdbDatabaseMetaData.SQL_getColumnPrivileges(string, string5, string3, string4);
        return DriverUtil.executeQuery(this.connection, string6);
    }

    public static String SQL_getColumnPrivileges(String string, String string2, String string3, String string4) {
        String string5 = StringUtil.isEmpty(string2) ? "%" : StringUtil.processSingleQuoteOfName(string2);
        String string6 = string3 == null ? "%" : StringUtil.processSingleQuoteOfName(string3);
        String string7 = string4 == null ? "%" : StringUtil.processSingleQuoteOfName(string4);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL AS TABLE_CAT,");
        stringBuilder.append("SCHEMAS.NAME AS TABLE_SCHEM,");
        stringBuilder.append("TABS.NAME AS TABLE_NAME, ");
        stringBuilder.append("COLS.NAME AS COLUMN_NAME, ");
        stringBuilder.append("GRANTORS.NAME AS GRANTOR,");
        stringBuilder.append("GRANTEES.NAME AS GRANTEE,");
        stringBuilder.append("SF_GET_SYS_PRIV(CAST (COLGRANTS.PRIVID AS INT)) AS PRIVILEGE, ");
        stringBuilder.append("CASE COLGRANTS.GRANTABLE WHEN 'Y' THEN 'YES' WHEN 'N' THEN 'NO' END AS IS_GRANTABLE ");
        stringBuilder.append("FROM SYS.SYSGRANTS COLGRANTS, ");
        stringBuilder.append(DmdbDatabaseMetaData.argClause(string7, "COLS")).append(",");
        stringBuilder.append("SYS.SYSOBJECTS GRANTORS, ");
        stringBuilder.append("(SELECT ID, NAME FROM SYS.SYSOBJECTS WHERE SUBTYPE$='USER' OR SUBTYPE$='ROLE') GRANTEES,");
        stringBuilder.append(DmdbDatabaseMetaData.schemaClause(string5, "SCHEMAS")).append(",");
        stringBuilder.append(DmdbDatabaseMetaData.tableClause_utab(string6, "TABS"));
        stringBuilder.append(" WHERE TABS.SCHID = SCHEMAS.ID");
        stringBuilder.append(" AND COLGRANTS.OBJID = TABS.ID ");
        stringBuilder.append(" AND COLGRANTS.GRANTOR = GRANTORS.ID AND COLGRANTS.URID = GRANTEES.ID AND ");
        stringBuilder.append("COLGRANTS.COLID = COLS.COLID AND COLGRANTS.OBJID = COLS.ID");
        stringBuilder.append(" ORDER BY COLUMN_NAME ASC,PRIVILEGE ASC;");
        String string8 = "/*+ gateway metadata JDBC_getColumnPrivilages(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + "," + DmdbDatabaseMetaData.gatewayFormat(string4) + ")*/ ";
        return String.valueOf(string8) + stringBuilder.toString();
    }

    public DmdbResultSet do_getBestRowIdentifier(String string, String string2, String string3, int n2, boolean bl) {
        String string4 = StringUtil.isEmpty(string2) ? "%" : StringUtil.processSingleQuoteOfName(string2);
        String string5 = string3 == null ? "%" : StringUtil.processSingleQuoteOfName(string3);
        StringBuilder stringBuilder = new StringBuilder();
        DmdbResultSet dmdbResultSet = this.do_getPrimaryKeys(string, string2, string3);
        if (dmdbResultSet.next()) {
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("(SELECT COLS.NAME");
            stringBuilder2.append(" FROM");
            stringBuilder2.append(" SYS.SYSINDEXES SYSIND,");
            stringBuilder2.append(" SYS.SYSINDEXES COLS,");
            stringBuilder2.append(" (SELECT ID, PID, NAME FROM SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX')IND_OBJ,");
            stringBuilder2.append(" SYS.SYSCONS CONS");
            stringBuilder2.append(" WHERE SCHEMAS.ID = TABS.SCHID AND CONS.TABLEID = TABS.ID");
            stringBuilder2.append(" AND COLS.ID = CONS.TABLEID AND IND_OBJ.ID = CONS.INDEXID AND IND_OBJ.ID = SYSIND.ID AND CONS.TYPE$ = 'P' AND SF_COL_IS_IDX_KEY(SYSIND.KEYNUM, SYSIND.KEYINFO,COLS.COLID)=1)");
            stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ '").append(n2).append("' as \"SCOPE\",COLS.NAME AS COLUMN_NAME,").append(DmdbDatabaseMetaData.makeDataTypeClause("COLS.TYPE$", "COLS.SCALE", this.connection.compatibleOracle())).append("AS DATA_TYPE, ").append(DmdbDatabaseMetaData.makeDataTypeNameClause("COLS.TYPE$", this.connection.compatibleOracle())).append("AS TYPE_NAME, ");
            stringBuilder.append("CASE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END AS COLUMN_SIZE,CASE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END AS BUFFER_LENGTH,CASE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) END AS DECIMAL_DIGITS,0 AS PSEUDO_COLUMN");
            stringBuilder.append(" FROM SYS.SYSCOLUMNS COLS,");
            stringBuilder.append(DmdbDatabaseMetaData.schemaClause(string4, "SCHEMAS")).append(",");
            stringBuilder.append(DmdbDatabaseMetaData.tableClause_utab(string5, "TABS"));
            stringBuilder.append(" WHERE");
            stringBuilder.append(" COLS.NAME IN ");
            stringBuilder.append(stringBuilder2.toString());
            stringBuilder.append(" AND TABS.SCHID = SCHEMAS.ID AND COLS.ID = TABS.ID");
            if (!bl) {
                stringBuilder.append(" AND COLS.NULLABLE$ = 'N'");
            }
        } else {
            stringBuilder.append("select /*+ MAX_OPT_N_TABLES(5) */ '").append(n2).append("' as \"SCOPE\",'ROWID' as COLUMN_NAME,-2 as DATA_TYPE,'LONG' as TYPE_NAME,8 as COLUMN_SIZE,8 as BUFFER_LENGTH,0 as DECIMAL_DIGITS,0 as PSEUDO_COLUMN");
        }
        return DriverUtil.executeQuery(this.connection, stringBuilder.toString());
    }

    public static String SQL_getBestRowIdentifier(String string, String string2, String string3, int n2, boolean bl, boolean bl2) {
        string2 = StringUtil.isEmpty(string2) ? "%" : StringUtil.processSingleQuoteOfName(string2);
        string3 = string3 == null ? "%" : StringUtil.processSingleQuoteOfName(string3);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ ");
        stringBuilder.append("1 AS SCOPE,");
        stringBuilder.append("COLS.NAME AS COLUMN_NAME,");
        stringBuilder.append(String.valueOf(DmdbDatabaseMetaData.makeDataTypeClause("COLS.TYPE$", "COLS.SCALE", bl2)) + "AS DATA_TYPE, ");
        stringBuilder.append(String.valueOf(DmdbDatabaseMetaData.makeDataTypeNameClause("COLS.TYPE$", bl2)) + "AS TYPE_NAME, ");
        stringBuilder.append("CASE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END AS COLUMN_SIZE,CASE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END AS BUFFER_LENGTH,CASE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) END AS DECIMAL_DIGITS,0 AS PSEUDO_COLUMN");
        stringBuilder.append(" FROM SYS.SYSINDEXES INDS,");
        stringBuilder.append("(SELECT OBJ.NAME, CON.ID, CON.TYPE$, CON.TABLEID, CON.COLID, CON.INDEXID FROM SYS.SYSCONS AS CON, SYS.SYSOBJECTS AS OBJ WHERE CON.TYPE$ = 'P' AND OBJ.SUBTYPE$='CONS' AND OBJ.ID=CON.ID) CONS,");
        stringBuilder.append("SYS.SYSCOLUMNS COLS,");
        stringBuilder.append(DmdbDatabaseMetaData.schemaClause(string2, "SCHEMAS")).append(",");
        stringBuilder.append(DmdbDatabaseMetaData.tableClause_utab(string3, "TAB")).append(",");
        stringBuilder.append("(SELECT ID, NAME FROM SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX')OBJ_INDS");
        stringBuilder.append(" WHERE SCHEMAS.ID = TAB.SCHID AND CONS.INDEXID=INDS.ID AND INDS.ID=OBJ_INDS.ID AND TAB.ID=COLS.ID AND CONS.TABLEID=TAB.ID AND SF_COL_IS_IDX_KEY(INDS.KEYNUM, INDS.KEYINFO,COLS.COLID)=1");
        if (!bl) {
            stringBuilder.append(" AND COLS.NULLABLE$ = 'N'");
        }
        stringBuilder.append("ORDER BY COLUMN_NAME ASC");
        String string4 = "/*+ gateway metadata JDBC_getBestRowIdentifier(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + "," + DmdbDatabaseMetaData.gatewayFormat(n2) + "," + DmdbDatabaseMetaData.gatewayFormat(bl) + ")*/ ";
        return String.valueOf(string4) + stringBuilder.toString();
    }

    public DmdbResultSet do_getVersionColumns(String string, String string2, String string3) {
        String string4 = DmdbDatabaseMetaData.SQL_getVersionColumns(string, string2, string3, this.connection.compatibleOracle());
        return DriverUtil.executeQuery(this.connection, string4);
    }

    public static String SQL_getVersionColumns(String string, String string2, String string3, boolean bl) {
        String string4 = "";
        string4 = String.valueOf(string4) + "SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL AS \"SCOPE\",COLS.NAME AS COLUMN_NAME, ";
        string4 = String.valueOf(string4) + DmdbDatabaseMetaData.makeDataTypeClause("COLS.TYPE$", "COLS.SCALE", bl) + "AS DATA_TYPE, ";
        string4 = String.valueOf(string4) + DmdbDatabaseMetaData.makeDataTypeNameClause("COLS.TYPE$", bl) + "AS TYPE_NAME, ";
        string4 = String.valueOf(string4) + "CASE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END AS COLUMN_SIZE,CASE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END AS BUFFER_LENGTH,CASE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) END AS DECIMAL_DIGITS,0 AS PSEUDO_COLUMN";
        string4 = String.valueOf(string4) + " FROM SYS.SYSCOLUMNS COLS WHERE 1 = 2;";
        String string5 = "/*+ gateway metadata JDBC_getVersionColumns(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + ")*/ ";
        return String.valueOf(string5) + string4;
    }

    public DmdbResultSet do_getPrimaryKeys(String string, String string2, String string3) {
        if (string3 == null) {
            DBError.ECJDBC_TABNAME_NULL.throwz(new Object[0]);
        }
        String string4 = StringUtil.isEmpty(string2) ? this.connection.schema : StringUtil.processSingleQuoteOfName(string2);
        String string5 = DmdbDatabaseMetaData.SQL_getPrimaryKeys(string, string4, string3, this.connection.compatibleOracle());
        return DriverUtil.executeQuery(this.connection, string5);
    }

    public static String SQL_getPrimaryKeys(String string, String string2, String string3, boolean bl) {
        string2 = StringUtil.isEmpty(string2) ? "%" : StringUtil.processSingleQuoteOfName(string2);
        string3 = string3 == null ? "%" : StringUtil.processSingleQuoteOfName(string3);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS TABLE_CAT,");
        stringBuilder.append("SCHEMAS.NAME AS TABLE_SCHEM,");
        stringBuilder.append("TAB.NAME AS TABLE_NAME,COLS.NAME AS COLUMN_NAME,SF_GET_INDEX_KEY_SEQ(INDS.KEYNUM, INDS.KEYINFO, COLS.COLID) AS KEY_SEQ,");
        if (bl) {
            stringBuilder.append(" OBJ_INDS.NAME AS PK_NAME ");
        } else {
            stringBuilder.append(" CONS.NAME AS PK_NAME ");
        }
        stringBuilder.append(" FROM");
        stringBuilder.append(" SYS.SYSINDEXES INDS,");
        stringBuilder.append("(SELECT OBJ.NAME, CON.ID, CON.TYPE$, CON.TABLEID, CON.COLID, CON.INDEXID FROM SYS.SYSCONS AS CON, SYS.SYSOBJECTS AS OBJ WHERE CON.TYPE$ = 'P' AND OBJ.SUBTYPE$='CONS' AND OBJ.ID=CON.ID) CONS,");
        stringBuilder.append("SYS.SYSCOLUMNS COLS,");
        stringBuilder.append(DmdbDatabaseMetaData.schemaClause(string2, "SCHEMAS")).append(",");
        stringBuilder.append(DmdbDatabaseMetaData.tableClause_utab(string3, "TAB")).append(",");
        stringBuilder.append("(SELECT ID, NAME FROM SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX')OBJ_INDS");
        stringBuilder.append(" WHERE SCHEMAS.ID = TAB.SCHID AND CONS.INDEXID=INDS.ID AND INDS.ID=OBJ_INDS.ID AND TAB.ID=COLS.ID AND CONS.TABLEID=TAB.ID AND SF_COL_IS_IDX_KEY(INDS.KEYNUM, INDS.KEYINFO,COLS.COLID)=1");
        stringBuilder.append("ORDER BY COLUMN_NAME ASC");
        String string4 = "/*+ gateway metadata JDBC_getPrimaryKeys(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + ")*/ ";
        return String.valueOf(string4) + stringBuilder.toString();
    }

    public DmdbResultSet do_getImportedKeys(String string, String string2, String string3) {
        if (string3 == null) {
            DBError.ECJDBC_TABNAME_NULL.throwz(new Object[0]);
        }
        String string4 = StringUtil.isEmpty(string2) ? this.connection.schema : StringUtil.processSingleQuoteOfName(string2);
        String string5 = DmdbDatabaseMetaData.SQL_getImportedKeys(string, string4, string3);
        return DriverUtil.executeQuery(this.connection, string5);
    }

    public static String SQL_getImportedKeys(String string, String string2, String string3) {
        string2 = StringUtil.isEmpty(string2) ? "%" : StringUtil.processSingleQuoteOfName(string2);
        string3 = string3 == null ? "%" : StringUtil.processSingleQuoteOfName(string3);
        String string4 = "SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS PKTABLE_CAT,T_REFED.SCHNAME AS PKTABLE_SCHEM, T_REFED.NAME AS PKTABLE_NAME, T_REFED.REFED_COL_NAME AS PKCOLUMN_NAME, NULL AS FKTABLE_CAT,T_REF.SCHNAME AS FKTABLE_SCHEM,T_REF.NAME AS FKTABLE_NAME, T_REF.REF_COL_NAME AS FKCOLUMN_NAME, T_REF.REF_KEYNO AS KEY_SEQ, SF_GET_UPD_RULE(T_REF.FACTION) AS UPDATE_RULE, SF_GET_DEL_RULE(T_REF.FACTION) AS DELETE_RULE, T_REF.REF_CONS_NAME AS FK_NAME, T_REFED.REFED_CONS_NAME AS PK_NAME, 0 AS DEFERRABILITY FROM (SELECT T_REF_TAB.NAME AS NAME, T_REF_TAB.SCHNAME AS SCHNAME, T_REF_CONS.FINDEXID AS REFED_ID, T_REF_CONS.NAME AS REF_CONS_NAME, SF_GET_INDEX_KEY_SEQ(T_REF_IND.KEYNUM, T_REF_IND.KEYINFO, T_REF_COL.COLID) AS REF_KEYNO, T_REF_COL.NAME AS REF_COL_NAME, T_REF_CONS.FACTION AS FACTION FROM (SELECT NAME, INDEXID, FINDEXID, TABLEID, FACTION, CONS.TYPE$ as TYPE FROM SYS.SYSCONS CONS, SYS.SYSOBJECTS OBJECTS WHERE CONS.ID = OBJECTS.ID) AS T_REF_CONS, (SELECT TABS.NAME AS NAME, TABS.ID, SCHEMAS.NAME AS SCHNAME FROM" + DmdbDatabaseMetaData.schemaClause(string2, "SCHEMAS") + "," + DmdbDatabaseMetaData.tableClause_utab(string3, "TABS") + " WHERE SCHEMAS.ID == TABS.SCHID)T_REF_TAB," + "SYS.SYSINDEXES AS T_REF_IND, " + "(SELECT ID, PID FROM SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REF_INDS_OBJ, " + "SYS.SYSCOLUMNS AS T_REF_COL " + "WHERE " + "T_REF_TAB.ID = T_REF_CONS.TABLEID AND T_REF_CONS.TYPE='F' AND T_REF_TAB.ID = T_REF_INDS_OBJ.PID AND T_REF_TAB.ID = T_REF_COL.ID " + "AND T_REF_CONS.INDEXID = T_REF_INDS_OBJ.ID AND T_REF_IND.ID = T_REF_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REF_IND.KEYNUM, T_REF_IND.KEYINFO, T_REF_COL.COLID)=1) AS T_REF, " + "(SELECT T_REFED_CONS.INDEXID AS REFED_ID, T_REFED_TAB.SCH_NAME AS SCHNAME, " + "T_REFED_TAB.TAB_NAME AS NAME, T_REFED_IND.ID AS REFED_IND_ID, " + "T_REFED_CONS.NAME AS REFED_CONS_NAME, SF_GET_INDEX_KEY_SEQ(T_REFED_IND.KEYNUM, T_REFED_IND.KEYINFO, T_REFED_COL.COLID) AS REFED_KEYNO, " + "T_REFED_COL.NAME AS REFED_COL_NAME FROM " + "(SELECT NAME, INDEXID, FINDEXID, TABLEID, FACTION, CONS.TYPE$ as TYPE FROM SYS.SYSCONS CONS, SYS.SYSOBJECTS OBJECTS WHERE CONS.ID = OBJECTS.ID) AS T_REFED_CONS, " + "(SELECT TAB.ID AS ID, TAB.NAME AS TAB_NAME, SCH.NAME AS SCH_NAME FROM " + "SYS.SYSOBJECTS TAB, " + "SYS.SYSOBJECTS SCH WHERE TAB.SUBTYPE$='UTAB' AND SCH.TYPE$='SCH' AND TAB.SCHID=SCH.ID) AS T_REFED_TAB, " + "SYS.SYSINDEXES AS T_REFED_IND, (SELECT ID, PID, NAME FROM " + "SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REFED_INDS_OBJ, " + "SYS.SYSCOLUMNS AS T_REFED_COL WHERE " + "T_REFED_TAB.ID = T_REFED_CONS.TABLEID AND T_REFED_CONS.TYPE='P' AND T_REFED_TAB.ID = T_REFED_INDS_OBJ.PID AND T_REFED_TAB.ID = T_REFED_COL.ID" + " AND T_REFED_CONS.INDEXID = T_REFED_INDS_OBJ.ID AND T_REFED_IND.ID = T_REFED_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REFED_IND.KEYNUM, T_REFED_IND.KEYINFO, T_REFED_COL.COLID)=1) AS T_REFED " + "WHERE T_REF.REFED_ID = T_REFED.REFED_ID AND T_REF.REF_KEYNO = T_REFED.REFED_KEYNO " + "ORDER BY FKTABLE_CAT ASC, FKTABLE_SCHEM ASC, FKTABLE_NAME ASC, KEY_SEQ ASC";
        String string5 = "/*+ gateway metadata JDBC_getImportedKeys(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + ")*/ ";
        return String.valueOf(string5) + string4;
    }

    public DmdbResultSet do_getExportedKeys(String string, String string2, String string3) {
        if (string3 == null) {
            DBError.ECJDBC_TABNAME_NULL.throwz(new Object[0]);
        }
        String string4 = StringUtil.isEmpty(string2) ? this.connection.schema : StringUtil.processSingleQuoteOfName(string2);
        String string5 = DmdbDatabaseMetaData.SQL_getExportedKeys(string, string4, string3);
        return DriverUtil.executeQuery(this.connection, string5);
    }

    public static String SQL_getExportedKeys(String string, String string2, String string3) {
        string2 = StringUtil.isEmpty(string2) ? "%" : StringUtil.processSingleQuoteOfName(string2);
        string3 = string3 == null ? "%" : StringUtil.processSingleQuoteOfName(string3);
        String string4 = "SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS PKTABLE_CAT,T_REFED.SCHNAME AS PKTABLE_SCHEM,T_REFED.NAME AS PKTABLE_NAME, T_REFED.REFED_COL_NAME AS PKCOLUMN_NAME, NULL AS FKTABLE_CAT, T_REF.REF_SCH_NAME AS FKTABLE_SCHEM, T_REF.REF_TAB_NAME AS FKTABLE_NAME, T_REF.REF_COL_NAME AS FKCOLUMN_NAME, T_REF.REF_KEYNO AS KEY_SEQ, SF_GET_UPD_RULE(T_REF.FACTION) AS UPDATE_RULE, SF_GET_DEL_RULE(T_REF.FACTION) AS DELETE_RULE, (SELECT NAME FROM SYS.SYSOBJECTS WHERE ID = T_REF.REF_CONS_ID) AS FK_NAME, (SELECT NAME FROM SYS.SYSOBJECTS WHERE ID = T_REFED.REFED_CONS_ID) AS PK_NAME, 0 AS DEFERRABILITY FROM (SELECT T_REF_TAB.SCH_NAME AS REF_SCH_NAME, T_REF_TAB.TAB_NAME AS REF_TAB_NAME, T_REF_CONS.ID AS REF_CONS_ID, SF_GET_INDEX_KEY_SEQ(T_REF_IND.KEYNUM, T_REF_IND.KEYINFO, T_REF_COL.COLID) AS REF_KEYNO, T_REF_COL.NAME AS REF_COL_NAME, T_REF_CONS.FINDEXID AS REFED_ID, T_REF_CONS.FACTION AS FACTION FROM SYS.SYSCONS AS T_REF_CONS, (SELECT TAB.ID AS ID, TAB.NAME AS TAB_NAME, SCH.NAME AS SCH_NAME FROM SYS.SYSOBJECTS TAB, SYS.SYSOBJECTS SCH WHERE TAB.SUBTYPE$='UTAB' AND SCH.TYPE$='SCH' AND TAB.SCHID=SCH.ID) AS T_REF_TAB, SYS.SYSINDEXES AS T_REF_IND,(SELECT ID, PID, NAME FROM SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REF_INDS_OBJ, SYS.SYSCOLUMNS AS T_REF_COL WHERE T_REF_TAB.ID = T_REF_CONS.TABLEID AND T_REF_CONS.TYPE$='F' AND T_REF_TAB.ID = T_REF_INDS_OBJ.PID AND T_REF_TAB.ID = T_REF_COL.ID AND T_REF_CONS.INDEXID = T_REF_INDS_OBJ.ID AND T_REF_IND.ID = T_REF_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REF_IND.KEYNUM, T_REF_IND.KEYINFO, T_REF_COL.COLID)=1) AS T_REF, (SELECT T_REFED_TAB.NAME AS NAME, T_REFED_TAB.SCHNAME AS SCHNAME, T_REFED_CONS.ID AS REFED_CONS_ID, SF_GET_INDEX_KEY_SEQ(T_REFED_IND.KEYNUM, T_REFED_IND.KEYINFO, T_REFED_COL.COLID) AS REFED_KEYNO, T_REFED_COL.NAME AS REFED_COL_NAME, T_REFED_CONS.INDEXID AS REFED_ID FROM SYS.SYSCONS AS T_REFED_CONS, (SELECT TABS.NAME AS NAME, TABS.ID AS ID, SCHEMAS.NAME AS SCHNAME  FROM " + DmdbDatabaseMetaData.schemaClause(string2, "SCHEMAS") + "," + DmdbDatabaseMetaData.tableClause_utab(string3, "TABS") + " WHERE TABS.SCHID = SCHEMAS.ID" + ") AS T_REFED_TAB, " + "SYS.SYSINDEXES AS T_REFED_IND, " + "(SELECT ID, PID, NAME FROM " + "SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REFED_INDS_OBJ, " + "SYS.SYSCOLUMNS AS T_REFED_COL WHERE " + "T_REFED_TAB.ID = T_REFED_CONS.TABLEID AND T_REFED_CONS.TYPE$='P' AND T_REFED_TAB.ID = T_REFED_INDS_OBJ.PID AND T_REFED_TAB.ID = T_REFED_COL.ID " + "AND T_REFED_CONS.INDEXID = T_REFED_INDS_OBJ.ID AND T_REFED_IND.ID = T_REFED_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REFED_IND.KEYNUM, T_REFED_IND.KEYINFO, T_REFED_COL.COLID)=1) AS T_REFED " + " WHERE T_REF.REFED_ID = T_REFED.REFED_ID AND " + "T_REF.REF_KEYNO = T_REFED.REFED_KEYNO ORDER BY FKTABLE_CAT ASC, " + "FKTABLE_SCHEM ASC, FKTABLE_NAME ASC, KEY_SEQ ASC";
        String string5 = "/*+ gateway metadata JDBC_getExportedKeys(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + ")*/ ";
        return String.valueOf(string5) + string4;
    }

    public DmdbResultSet do_getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) {
        if (string3 == null || string6 == null) {
            DBError.ECJDBC_TABNAME_NULL.throwz(new Object[0]);
        }
        String string7 = StringUtil.isEmpty(string2) ? this.connection.schema : StringUtil.processSingleQuoteOfName(string2);
        String string8 = StringUtil.isEmpty(string5) ? this.connection.schema : StringUtil.processSingleQuoteOfName(string5);
        String string9 = DmdbDatabaseMetaData.SQL_getCrossReference(string, string7, string3, string4, string8, string6);
        return DriverUtil.executeQuery(this.connection, string9);
    }

    public static String SQL_getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) {
        string2 = StringUtil.isEmpty(string2) ? "%" : StringUtil.processSingleQuoteOfName(string2);
        string3 = string3 == null ? "%" : StringUtil.processSingleQuoteOfName(string3);
        string5 = StringUtil.isEmpty(string5) ? "%" : StringUtil.processSingleQuoteOfName(string5);
        string6 = string6 == null ? "%" : StringUtil.processSingleQuoteOfName(string6);
        String string7 = "SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS PKTABLE_CAT,T_REFED.SCHNAME AS PKTABLE_SCHEM,T_REFED.NAME AS PKTABLE_NAME,T_REFED.REFED_COL_NAME AS PKCOLUMN_NAME, NULL AS FKTABLE_CAT,T_REF.SCHNAME AS FKTABLE_SCHEM,T_REF.NAME AS FKTABLE_NAME,T_REF.REF_COL_NAME AS FKCOLUMN_NAME,T_REF.REF_KEYNO AS KEY_SEQ, SF_GET_UPD_RULE(FACTION) AS UPDATE_RULE, SF_GET_DEL_RULE(FACTION) AS DELETE_RULE,T_REF.REF_CONS_NAME AS FK_NAME,T_REFED.REFED_CONS_NAME AS PK_NAME,0 AS DEFERRABILITY FROM (SELECT T_REF_TAB.NAME AS NAME, T_REF_TAB.SCHNAME AS SCHNAME, T_REF_CONS.FINDEXID AS REFED_IND_ID,T_REF_INDS_OBJ.NAME AS REF_CONS_NAME, SF_GET_INDEX_KEY_SEQ(T_REF_INDS.KEYNUM, T_REF_INDS.KEYINFO, T_REF_COL.COLID) AS REF_KEYNO,T_REF_COL.NAME AS REF_COL_NAME, T_REF_CONS.FACTION AS FACTION FROM SYS.SYSCONS AS T_REF_CONS,(SELECT TABS.NAME AS NAME, TABS.ID AS ID, SCHEMAS.NAME AS SCHNAME FROM" + DmdbDatabaseMetaData.schemaClause(string5, "SCHEMAS") + "," + DmdbDatabaseMetaData.tableClause_utab(string6, "TABS") + " WHERE SCHEMAS.ID = TABS.SCHID)AS T_REF_TAB," + "SYS.SYSINDEXES AS T_REF_INDS, (SELECT ID, PID, NAME FROM " + "SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REF_INDS_OBJ, " + "SYS.SYSCOLUMNS AS T_REF_COL WHERE " + "T_REF_TAB.ID = T_REF_CONS.TABLEID AND T_REF_CONS.TYPE$='F' AND T_REF_TAB.ID = T_REF_INDS_OBJ.PID AND T_REF_TAB.ID = T_REF_COL.ID " + "AND T_REF_CONS.INDEXID = T_REF_INDS_OBJ.ID AND T_REF_INDS.ID = T_REF_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REF_INDS.KEYNUM, T_REF_INDS.KEYINFO, T_REF_COL.COLID)=1) AS T_REF, " + "(SELECT T_REFED_TAB.NAME AS NAME, T_REFED_TAB.SCHNAME AS SCHNAME, T_REFED_INDS.ID AS REFED_IND_ID,T_REFED_INDS_OBJ.NAME AS REFED_CONS_NAME, SF_GET_INDEX_KEY_SEQ(T_REFED_INDS.KEYNUM, T_REFED_INDS.KEYINFO, T_REFED_COL.COLID) AS REFED_KEYNO,T_REFED_COL.NAME AS REFED_COL_NAME FROM " + "SYS.SYSCONS AS T_REFED_CONS," + "(SELECT TABS.NAME AS NAME, TABS.ID AS ID, SCHEMAS.NAME AS SCHNAME FROM " + DmdbDatabaseMetaData.schemaClause(string2, "SCHEMAS") + "," + DmdbDatabaseMetaData.tableClause_utab(string3, "TABS") + " WHERE SCHEMAS.ID = TABS.SCHID) AS T_REFED_TAB," + "SYS.SYSINDEXES AS T_REFED_INDS, (SELECT ID, PID, NAME FROM " + "SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REFED_INDS_OBJ," + "SYS.SYSCOLUMNS AS T_REFED_COL WHERE " + "T_REFED_TAB.ID = T_REFED_CONS.TABLEID AND T_REFED_CONS.TYPE$='P' AND T_REFED_TAB.ID = T_REFED_INDS_OBJ.PID AND T_REFED_TAB.ID = T_REFED_COL.ID " + "AND T_REFED_CONS.INDEXID = T_REFED_INDS_OBJ.ID AND T_REFED_INDS.ID = T_REFED_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REFED_INDS.KEYNUM, T_REFED_INDS.KEYINFO, T_REFED_COL.COLID)=1) AS T_REFED" + " WHERE T_REF.REFED_IND_ID = T_REFED.REFED_IND_ID AND T_REF.REF_KEYNO = T_REFED.REFED_KEYNO ORDER BY FKTABLE_CAT ASC,FKTABLE_SCHEM ASC,FKTABLE_NAME ASC,KEY_SEQ ASC";
        String string8 = "/*+ gateway metadata JDBC_getCrossReference(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + "," + DmdbDatabaseMetaData.gatewayFormat(string4) + "," + DmdbDatabaseMetaData.gatewayFormat(string5) + "," + DmdbDatabaseMetaData.gatewayFormat(string6) + ")*/ ";
        return String.valueOf(string8) + string7;
    }

    public DmdbResultSet do_getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) {
        String string4 = DmdbDatabaseMetaData.SQL_getIndexInfo(string, string2, string3, bl, bl2);
        return DriverUtil.executeQuery(this.connection, string4);
    }

    public static String SQL_getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) {
        string2 = StringUtil.isEmpty(string2) ? "%" : StringUtil.processSingleQuoteOfName(string2);
        string3 = string3 == null ? "%" : StringUtil.processSingleQuoteOfName(string3);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL");
        stringBuilder.append(" AS TABLE_CAT,USERS.NAME AS TABLE_SCHEM,TAB.NAME AS TABLE_NAME, ");
        stringBuilder.append("CASE INDS.ISUNIQUE WHEN 'Y' THEN 0 ELSE 1 END AS NON_UNIQUE, NULL AS INDEX_QUALIFIER, ");
        stringBuilder.append("OBJ_INDS.NAME AS INDEX_NAME, ");
        stringBuilder.append("CASE INDS.XTYPE & 0x01 WHEN 0 THEN 1 ");
        stringBuilder.append("ELSE 3 END AS \"TYPE\", ");
        stringBuilder.append("SF_GET_INDEX_KEY_SEQ(INDS.KEYNUM, INDS.KEYINFO, COLS.COLID) AS ORDINAL_POSITION, ");
        stringBuilder.append("COLS.NAME AS COLUMN_NAME, ");
        stringBuilder.append("SF_GET_INDEX_KEY_ORDER(INDS.KEYNUM, INDS.KEYINFO, COLS.COLID) AS ASC_OR_DESC, ");
        stringBuilder.append("0 AS CARDINALITY, 0 AS PAGES, NULL AS FILTER_CONDITION ");
        stringBuilder.append(" FROM ");
        stringBuilder.append(DmdbDatabaseMetaData.schemaClause(string2, "USERS")).append(",");
        stringBuilder.append(DmdbDatabaseMetaData.tableClause_utab(string3, "TAB")).append(",");
        stringBuilder.append("(SELECT ID, PID, NAME FROM SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS OBJ_INDS,");
        stringBuilder.append("SYS.SYSINDEXES AS INDS,");
        stringBuilder.append("SYS.SYSCOLUMNS AS COLS ");
        stringBuilder.append("WHERE TAB.ID=COLS.ID AND TAB.ID=OBJ_INDS.PID ");
        stringBuilder.append("AND INDS.ID=OBJ_INDS.ID AND TAB.SCHID = USERS.ID AND ");
        stringBuilder.append("SF_COL_IS_IDX_KEY(INDS.KEYNUM, INDS.KEYINFO, COLS.COLID)=1");
        if (bl) {
            stringBuilder.append(" AND INDS.ISUNIQUE = 'Y' ORDER BY NON_UNIQUE ASC,TYPE ASC,INDEX_NAME ASC,ORDINAL_POSITION ASC;");
        } else {
            stringBuilder.append(" ORDER BY NON_UNIQUE ASC,TYPE ASC,INDEX_NAME ASC,ORDINAL_POSITION ASC;");
        }
        String string4 = "/*+ gateway metadata JDBC_getIndexInfo(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + "," + DmdbDatabaseMetaData.gatewayFormat(bl) + "," + DmdbDatabaseMetaData.gatewayFormat(bl2) + ")*/ ";
        return String.valueOf(string4) + stringBuilder.toString();
    }

    public DmdbResultSet do_getUDTs(String string, String string2, String string3, int[] nArray) {
        String string4 = DmdbDatabaseMetaData.SQL_getUDTs(string, string2, string3, nArray);
        return DriverUtil.executeQuery(this.connection, string4);
    }

    public static String SQL_getUDTs(String string, String string2, String string3, int[] nArray) {
        String string4 = "SELECT CAST(NULL AS VARCHAR(128)) AS TYPE_CAT, CAST(NULL AS VARCHAR(128)) AS TYPE_SCHEM, CAST(NULL AS VARCHAR(128)) AS TYPE_NAME, CAST(NULL AS VARCHAR(128)) AS CLASS_NAME, CAST(NULL AS INT) AS DATA_TYPE, CAST(NULL AS VARCHAR(1024)) AS REMARKS, CAST(NULL AS SMALLINT) AS BASE_TYPE FROM DUAL WHERE 1 = 2";
        String string5 = "/*+ gateway metadata JDBC_getUDTs(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + "," + DmdbDatabaseMetaData.gatewayFormat(nArray) + ")*/ ";
        return String.valueOf(string5) + string4;
    }

    public DmdbResultSet do_getSuperTypes(String string, String string2, String string3) {
        String string4 = DmdbDatabaseMetaData.SQL_getSuperTypes(string, string2, string3);
        return DriverUtil.executeQuery(this.connection, string4);
    }

    public static String SQL_getSuperTypes(String string, String string2, String string3) {
        String string4 = "SELECT CAST(NULL AS VARCHAR(128)) AS TYPE_CAT, CAST(NULL AS VARCHAR(128)) AS TYPE_SCHEM, CAST(NULL AS VARCHAR(128)) AS TYPE_NAME, CAST(NULL AS VARCHAR(128)) AS SUPERTYPE_CAT,CAST(NULL AS VARCHAR(128)) AS SUPERTYPE_SCHEM,CAST(NULL AS VARCHAR(128)) AS SUPERTYPE_NAME FROM DUAL WHERE 1 = 2";
        String string5 = "/*+ gateway metadata JDBC_getSuperTypes(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + ")*/ ";
        return String.valueOf(string5) + string4;
    }

    public DmdbResultSet do_getSuperTables(String string, String string2, String string3) {
        String string4 = DmdbDatabaseMetaData.SQL_getSuperTables(string, string2, string3);
        return DriverUtil.executeQuery(this.connection, string4);
    }

    public static String SQL_getSuperTables(String string, String string2, String string3) {
        String string4 = "SELECT CAST(NULL AS VARCHAR(128))  AS TABLE_CAT,CAST(NULL AS VARCHAR(128)) AS TABLE_SCHEM,CAST(NULL AS VARCHAR(128)) AS TABLE_NAME,CAST(NULL AS VARCHAR(128)) AS SUPERTABLE_NAME FROM DUAL WHERE 1 = 2";
        String string5 = "/*+ gateway metadata JDBC_getSuperTables(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + ")*/ ";
        return String.valueOf(string5) + string4;
    }

    public DmdbResultSet do_getProcedures(String string, String string2, String string3) {
        String string4;
        if (this.connection.compatibleOracle() && StringUtil.isNotEmpty(string)) {
            string4 = StringUtil.processSingleQuoteOfName(string);
            try {
                String string5 = DmdbDatabaseMetaData.SQL_getProcedures(string4, string2, string3, this.connection.compatibleOracle());
                return DriverUtil.executeQuery(this.connection, string5.toString());
            }
            catch (SQLException sQLException) {}
        }
        string4 = DmdbDatabaseMetaData.SQL_getProcedures(string, string2, string3, this.connection.compatibleOracle());
        return DriverUtil.executeQuery(this.connection, string4.toString());
    }

    public static String SQL_getProcedures(String string, String string2, String string3, boolean bl) {
        if (bl && StringUtil.isNotEmpty(string)) {
            return DmdbDatabaseMetaData.SQL_getPkgProcedures(string2, string, string3, 0);
        }
        string2 = StringUtil.isEmpty(string2) ? "%" : StringUtil.processSingleQuoteOfName(string2);
        string3 = string3 == null ? "%" : StringUtil.processSingleQuoteOfName(string3);
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL AS PROCEDURE_CAT,");
        stringBuilder.append("SCHEMAS.NAME AS PROCEDURE_SCHEM,");
        stringBuilder.append("PROCS.NAME AS PROCEDURE_NAME,");
        stringBuilder.append("'RESERVED1' AS RESERVED1,'RESERVED2' AS RESERVED2,'RESERVED3' AS RESERVED3, NULL AS REMARKS, 1 AS PROCEDURE_TYPE");
        stringBuilder.append(" FROM ");
        stringBuilder.append(DmdbDatabaseMetaData.schemaClause(string2, "SCHEMAS")).append(",");
        stringBuilder.append(DmdbDatabaseMetaData.procClause(string3, "PROCS", bl));
        stringBuilder.append(" WHERE SCHEMAS.ID = PROCS.SCHID");
        stringBuilder.append(" ORDER BY PROCEDURE_SCHEM ASC,PROCEDURE_NAME ASC;");
        String string4 = "/*+ gateway metadata JDBC_getProcedures(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + ")*/ ";
        return String.valueOf(string4) + stringBuilder.toString();
    }

    public DmdbResultSet do_getProcedureColumns(String string, String string2, String string3, String string4) {
        if (this.connection.compatibleOracle() && StringUtil.isNotEmpty(string)) {
            try {
                String string5 = DmdbDatabaseMetaData.SQL_getProcedureColumns(string2, string, string3, string4, this.connection.compatibleOracle());
                return DriverUtil.executeQuery(this.connection, string5);
            }
            catch (SQLException sQLException) {}
        }
        String string6 = DmdbDatabaseMetaData.SQL_getProcedureColumns(string, string2, string3, string4, this.connection.compatibleOracle());
        return DriverUtil.executeQuery(this.connection, string6);
    }

    public static String SQL_getProcedureColumns(String string, String string2, String string3, String string4, boolean bl) {
        if (bl && StringUtil.isNotEmpty(string)) {
            return DmdbDatabaseMetaData.SQL_getPkgProcedureColumns(string2, string, string3, string4, 0, bl);
        }
        string2 = StringUtil.isEmpty(string2) ? "%" : StringUtil.processSingleQuoteOfName(string2);
        string3 = string3 == null ? "%" : StringUtil.processSingleQuoteOfName(string3);
        string4 = string4 == null ? "%" : StringUtil.processSingleQuoteOfName(string4);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT ");
        stringBuilder.append("NULL AS PROCEDURE_CAT,");
        stringBuilder.append("SCHEMAS.NAME AS PROCEDURE_SCHEM,");
        stringBuilder.append("PROCS.NAME AS PROCEDURE_NAME,");
        if (bl) {
            stringBuilder.append("CASE ARG.INFO1 WHEN 3 THEN NULL ELSE ARG.NAME END AS COLUMN_NAME, ");
        } else {
            stringBuilder.append("ARG.NAME AS COLUMN_NAME,");
        }
        stringBuilder.append("CASE ARG.INFO1 WHEN 0 THEN 1 WHEN 1 THEN 4 WHEN 2 THEN 2 WHEN 3 THEN 5 END AS COLUMN_TYPE, ");
        stringBuilder.append(DmdbDatabaseMetaData.makeDataTypeClause("ARG.TYPE$", "ARG.SCALE", bl));
        stringBuilder.append("AS DATA_TYPE, ");
        stringBuilder.append(DmdbDatabaseMetaData.makeDataTypeNameClause("ARG.TYPE$", bl));
        stringBuilder.append("AS TYPE_NAME, ");
        stringBuilder.append("CASE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END ");
        stringBuilder.append("AS \"PRECISION\", ");
        stringBuilder.append("CASE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END ");
        stringBuilder.append("AS LENGTH, ");
        stringBuilder.append("CASE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) END ");
        stringBuilder.append("AS SCALE, ");
        stringBuilder.append("10 AS RADIX, ");
        stringBuilder.append("1 AS NULLABLE, ");
        stringBuilder.append("NULL AS REMARKS, ");
        stringBuilder.append("ARG.DEFVAL AS COLUMN_DEF, ");
        stringBuilder.append("NULL AS SQL_DATA_TYPE, ");
        stringBuilder.append("NULL AS SQL_DATETIME_SUB, ");
        stringBuilder.append("NULL AS CHAR_OCTET_LENGTH, ");
        stringBuilder.append("ARG.COLID AS ORDINAL_POSITION, ");
        stringBuilder.append("CASE ARG.NULLABLE$ WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE, ");
        stringBuilder.append("NULL AS SPECIFIC_NAME ");
        stringBuilder.append("FROM ");
        stringBuilder.append(DmdbDatabaseMetaData.schemaClause(string2, "SCHEMAS")).append(",");
        stringBuilder.append(DmdbDatabaseMetaData.procClause(string3, "PROCS", bl)).append(",");
        stringBuilder.append(DmdbDatabaseMetaData.argClause(string4, "ARG"));
        stringBuilder.append(" WHERE SCHEMAS.ID = PROCS.SCHID AND PROCS.ID = ARG.ID ");
        stringBuilder.append(" ORDER BY PROCEDURE_SCHEM ASC,PROCEDURE_NAME ASC, ORDINAL_POSITION ASC;");
        String string5 = "/*+ gateway metadata JDBC_getProcedureColumns(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + "," + DmdbDatabaseMetaData.gatewayFormat(string4) + ")*/ ";
        return String.valueOf(string5) + stringBuilder.toString();
    }

    public DmdbResultSet do_getFunctions(String string, String string2, String string3) {
        if (this.connection.compatibleOracle() && StringUtil.isNotEmpty(string)) {
            try {
                String string4 = DmdbDatabaseMetaData.SQL_getFunctions(string, string2, string3, this.connection.compatibleOracle());
                return DriverUtil.executeQuery(this.connection, string4.toString());
            }
            catch (SQLException sQLException) {}
        }
        String string5 = DmdbDatabaseMetaData.SQL_getFunctions(string, string2, string3, this.connection.compatibleOracle());
        return DriverUtil.executeQuery(this.connection, string5.toString());
    }

    public static String SQL_getFunctions(String string, String string2, String string3, boolean bl) {
        if (bl && StringUtil.isNotEmpty(string)) {
            return DmdbDatabaseMetaData.SQL_getPkgProcedures(string2, string, string3, 2);
        }
        string = string == null ? string : StringUtil.processSingleQuoteOfName(string.trim());
        string2 = StringUtil.isEmpty(string2) ? "%" : StringUtil.processSingleQuoteOfName(string2);
        string3 = string3 == null ? "%" : StringUtil.processSingleQuoteOfName(string3);
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("SELECT DISTINCT ");
        if (string == null) {
            stringBuilder.append("NULL");
        } else {
            stringBuilder.append("'").append(string).append("'");
        }
        stringBuilder.append(" AS FUNCTION_CAT, SCHEMAS.NAME AS FUNCTION_SCHEM, FUNCS.NAME AS FUNCTION_NAME, NULL AS REMARKS, 2 AS FUNCTION_TYPE, FUNCS.NAME AS SPECIFIC_NAME");
        stringBuilder.append(" FROM ");
        stringBuilder.append(DmdbDatabaseMetaData.funcClause(string3, "FUNCS")).append(",");
        stringBuilder.append(DmdbDatabaseMetaData.schemaClause(string2, "SCHEMAS"));
        stringBuilder.append(" WHERE SCHEMAS.ID = FUNCS.SCHID");
        stringBuilder.append(" ORDER BY FUNCTION_SCHEM ASC,FUNCTION_NAME ASC;");
        String string4 = "/*+ gateway metadata JDBC_getFunctions(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + ")*/ ";
        return String.valueOf(string4) + stringBuilder.toString();
    }

    public DmdbResultSet do_getFunctionColumns(String string, String string2, String string3, String string4) {
        String string5 = null;
        if (this.connection.compatibleOracle() && StringUtil.isNotEmpty(string)) {
            try {
                string5 = DmdbDatabaseMetaData.SQL_getPkgProcedureColumns(string2, string, string3, string4, 2, this.connection.compatibleOracle());
                return DriverUtil.executeQuery(this.connection, string5);
            }
            catch (SQLException sQLException) {}
        }
        string5 = DmdbDatabaseMetaData.SQL_getFunctionColumns(string, string2, string3, string4, this.connection.compatibleOracle());
        return DriverUtil.executeQuery(this.connection, string5);
    }

    public static String SQL_getFunctionColumns(String string, String string2, String string3, String string4, boolean bl) {
        if (bl && StringUtil.isNotEmpty(string)) {
            return DmdbDatabaseMetaData.SQL_getPkgProcedureColumns(string2, string, string3, string4, 2, bl);
        }
        string = string == null ? string : StringUtil.processSingleQuoteOfName(string.trim());
        string2 = StringUtil.isEmpty(string2) ? "%" : StringUtil.processSingleQuoteOfName(string2);
        string3 = string3 == null ? "%" : StringUtil.processSingleQuoteOfName(string3);
        string4 = string4 == null ? "%" : StringUtil.processSingleQuoteOfName(string4);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT DISTINCT ");
        if (string == null) {
            stringBuilder.append("NULL");
        } else {
            stringBuilder.append("'").append(string).append("'");
        }
        stringBuilder.append(" AS FUNCTION_CAT,");
        stringBuilder.append("USERS.NAME AS FUNCTION_SCHEM,");
        stringBuilder.append("FUNCS.NAME AS FUNCTION_NAME,");
        if (bl) {
            stringBuilder.append("CASE ARG.INFO1 WHEN 3 THEN NULL ELSE ARG.NAME END AS COLUMN_NAME, ");
        } else {
            stringBuilder.append("ARG.NAME AS COLUMN_NAME,");
        }
        stringBuilder.append("CASE ARG.INFO1 WHEN 0 THEN 1 WHEN 1 THEN 3 WHEN 2 THEN 2 WHEN 3 THEN 4 END AS COLUMN_TYPE,");
        stringBuilder.append(DmdbDatabaseMetaData.makeDataTypeClause("ARG.TYPE$", "ARG.SCALE", bl));
        stringBuilder.append("AS DATA_TYPE,");
        stringBuilder.append(DmdbDatabaseMetaData.makeDataTypeNameClause("ARG.TYPE$", bl));
        stringBuilder.append("AS TYPE_NAME,");
        stringBuilder.append("CASE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END AS \"PRECISION\",");
        stringBuilder.append("CASE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END AS LENGTH,");
        stringBuilder.append("CASE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) END AS SCALE,");
        stringBuilder.append("10 AS RADIX,");
        stringBuilder.append("1 AS NULLABLE,");
        stringBuilder.append("NULL AS REMARKS, ");
        stringBuilder.append("CASE SF_GET_OCT_LENGTH(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT)) WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_OCT_LENGTH(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT)) END AS CHAR_OCTET_LENGTH, ");
        stringBuilder.append("CASE ARG.INFO1 WHEN 3 THEN 0 ELSE ARG.COLID + 1 END AS ORDINAL_POSITION, ");
        stringBuilder.append("CASE ARG.NULLABLE$ WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE, ");
        stringBuilder.append("FUNCS.NAME AS SPECIFIC_NAME, ");
        stringBuilder.append("ARG.COLID ");
        stringBuilder.append(" FROM ");
        stringBuilder.append(DmdbDatabaseMetaData.schemaClause(string2, "USERS")).append(",");
        stringBuilder.append(DmdbDatabaseMetaData.funcClause(string3, "FUNCS")).append(",");
        stringBuilder.append(DmdbDatabaseMetaData.argClause(string4, "ARG"));
        stringBuilder.append(" WHERE USERS.ID = FUNCS.SCHID AND FUNCS.ID = ARG.ID");
        stringBuilder.append(" ORDER BY FUNCTION_SCHEM ASC,FUNCTION_NAME ASC, ARG.COLID ASC;");
        String string5 = "/*+ gateway metadata JDBC_getFuctionColumns(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + "," + DmdbDatabaseMetaData.gatewayFormat(string4) + ")*/ ";
        return String.valueOf(string5) + stringBuilder.toString();
    }

    public DmdbResultSet do_getClientInfoProperties() {
        String string = DmdbDatabaseMetaData.SQL_getClientInfoProperties();
        return DriverUtil.executeQuery(this.connection, string);
    }

    public static String SQL_getClientInfoProperties() {
        Object object2;
        StringBuilder stringBuilder = new StringBuilder("declare \ntype RowVal is record (NAME varchar, MAX_LEN int, DEFAULT_VALUE varchar, DESCRIPTION varchar); \ntype RowVals is array RowVal[];\nr RowVal; \nrs RowVals;\n");
        stringBuilder.append("begin \n");
        stringBuilder.append("rs = new RowVal[").append(Configuration.values().size()).append("]; \n");
        int n2 = 1;
        for (Object object2 : Configuration.values()) {
            stringBuilder.append("r.name = '").append(((Configuration)object2).getName()).append("';\n");
            stringBuilder.append("r.max_len = 128;\n");
            stringBuilder.append("r.default_value = '").append(((Configuration)object2).getDefault()).append("';\n");
            stringBuilder.append("r.description = '").append(((Configuration)object2).getDescription()).append("';\n");
            stringBuilder.append("rs[").append(n2).append("] = r;\n");
            ++n2;
        }
        stringBuilder.append("select * from array rs;\n");
        stringBuilder.append("end;");
        object2 = "/*+ gateway metadata JDBC_getClientInfoProperties()*/ ";
        return String.valueOf(object2) + stringBuilder.toString();
    }

    public boolean do_allProceduresAreCallable() {
        return true;
    }

    public boolean do_allTablesAreSelectable() {
        return true;
    }

    public boolean do_autoCommitFailureClosesAllResultSets() {
        return false;
    }

    public boolean do_dataDefinitionCausesTransactionCommit() {
        return this.connection.ddlAutoCommit;
    }

    public boolean do_dataDefinitionIgnoredInTransactions() {
        return !this.connection.ddlAutoCommit;
    }

    public String do_getDatabaseProductName() {
        if (StringUtil.isNotEmpty(this.connection.databaseProductName)) {
            return this.connection.databaseProductName;
        }
        if (this.connection.compatibleOracle()) {
            return "Oracle";
        }
        return "DM DBMS";
    }

    /*
     * Exception decompiling
     */
    public String do_getDatabaseProductVersion() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int do_getDatabaseMajorVersion() {
        if (this.connection.compatibleOracle()) {
            return 11;
        }
        String[] stringArray = this.connection.do_getClientInfo("serverVersion").split("\\.");
        return Integer.parseInt(stringArray[0]);
    }

    public int do_getDatabaseMinorVersion() {
        if (this.connection.compatibleOracle()) {
            return 1;
        }
        String[] stringArray = this.connection.do_getClientInfo("serverVersion").split("\\.");
        return Integer.parseInt(stringArray[1]);
    }

    public String do_getDriverName() {
        return DmDriver.class.getName();
    }

    public String do_getDriverVersion() {
        return "8.1.2.141";
    }

    public int do_getDriverMajorVersion() {
        String[] stringArray = this.do_getDriverVersion().split("\\.");
        return Integer.valueOf(stringArray[0]);
    }

    public int do_getDriverMinorVersion() {
        String[] stringArray = this.do_getDriverVersion().split("\\.");
        return Integer.valueOf(stringArray[1]);
    }

    public int do_getJDBCMajorVersion() {
        String[] stringArray = "4.0".split("\\.");
        return Integer.valueOf(stringArray[0]);
    }

    public int do_getJDBCMinorVersion() {
        String[] stringArray = "4.0".split("\\.");
        return Integer.valueOf(stringArray[1]);
    }

    public String do_getURL() {
        return this.connection.url;
    }

    public String do_getUserName() {
        return this.connection.user;
    }

    public DmdbConnection do_getConnection() {
        return this.connection;
    }

    public int do_getResultSetHoldability() {
        return 1;
    }

    public int do_getSQLStateType() {
        return 1;
    }

    public String do_getIdentifierQuoteString() {
        return "\"";
    }

    public String do_getSQLKeywords() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("BREAK,BROWSE,BULK,CHECKPOINT,CLUSTERED,COMMITTED,COMPUTE,");
        stringBuffer.append(" CONFIRM,CONTROLROW,DATABASE,DBCC,DISK,DISTRIBUTED,DUMMY,");
        stringBuffer.append(" DUMP,ERRLVL,ERROREXIT,EXIT,FILE,FILLFACTOR,FLOPPY,HOLDLOCK,");
        stringBuffer.append(" IDENTITY_INSERT,IDENTITYCOL,IF,KILL,LINENO,LOAD,MIRROREXIT,");
        stringBuffer.append("NONCLUSTERED,OFF,OFFSETS,ONCE,OVER,PERCENT,PERM,PERMANENT,PLAN, PRINT,");
        stringBuffer.append("AFTER,ASSIGN,AUDIT,BEFORE,BITMAP,CACHE,CALL,CHAIN,CLUSTER,CYCLE,");
        stringBuffer.append(" DATABASE, DATAFILE, DEBUG, #DECODE, #DELETING, DISABLE,");
        stringBuffer.append(" EACH,ELSEIF,END,EXCLUSIVE, EXIT,FILLFACTOR, FUNCTION,");
        stringBuffer.append(" HEXTORAW,IDENTIFIED,IF, IFNULL,INCREASE, INDEX, ");
        stringBuffer.append(" INITIAL,INTENTION,ISNULL,ISOPEN,MAXVALUE,");
        stringBuffer.append(" MINVALUE,MODIFY,NATURAL,NEW, NEXT, NOAUDIT, NOCACHE,NOCYCLE,");
        stringBuffer.append(" NOTFOUND,  NVL, OFF, OLD, OUT,PENDANT, PERCENT, PRINT, PRIOR,");
        stringBuffer.append("RAISE,RAWTOHEX,READ,RENAME,RETURN,REVERSE,ROLE,ROWCOUNT,ROWNUM,SAVEPOINT,SERIALIZABLE,");
        stringBuffer.append(" SEQUENCE, SHARE, STATEMENT,TIES, TIMESTAMPADD, TIMESTAMPDIFF,");
        stringBuffer.append("TOP,TRIGGER,TRIGGERS,TRUNCATE,TYPECAST,UNCOMMITED,UNTIL,VSIZE,WHILE,LOGIN,");
        stringBuffer.append("EXTERNALLY,SESSION_PER_USER,CONNECT_IDLE_TIME,FAILED_LOGIN_ATTEMPS,");
        stringBuffer.append("PASSWORD_LIFE_TIME,PASSWORD_REUSE_TIME,PASSWORD_REUSE_MAX,");
        stringBuffer.append("PASSWORD_LOCK_TIME,PASSWORD_GRACE_TIME,POLICY,CATEGORY,UNLIMITED");
        return stringBuffer.toString();
    }

    public String do_getNumericFunctions() {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE,CEIL,COSH,LN,SINH,TANH";
    }

    public String do_getStringFunctions() {
        return "ASCII,CHAR,CONCAT,DIFFERENCE,INSERT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPEAT,REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,UCASE,BIT_LENGTH,CHAR_LENGTH,CHARACTER_LENGTH,CHR,INITCAP,INSSTR,INSTR,INSTRB,LEFTSTR,LENGTHB,OCTET_LENGTH,LOWER,LPAD,POSITION,REPEATSTR,REVERSE,RIGHTSTR,RPAD,SUBSTR,SUBSTRB,TO_CHAR,TRANSLATE,TRIM,UPPER";
    }

    public String do_getSystemFunctions() {
        return "IFNULL,USER,CUR_DATABASE,DBID,EXTENT,PAGE,SESSID,UID,TABLEDEF,VSIZE,SET_TABLE_OPTION,SET_INDEX_OPTION,CFALGORITHMSENCRYPT,CFALGORITHMSDECRYPT,BFALGORITHMSENCRYPT,BFALGORITHMSDECRYPT,LABEL_TO_CHAR,LABEL_FROM_CHAR,LABEL_CMP,LABEL_STR_CMP";
    }

    public String do_getTimeDateFunctions() {
        return "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,WEEK,YEAR,ADD_DAYS,ADD_MONTHS,ADD_WEEKS,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,DATEADD,DATEDIFF,DATEPART,DAYS_BETWEEN,EXTRACT,GETDATE,LAST_DAY,MONTHS_BETWEEN,NEXT_DAY,ROUND,SYSDATE,TO_DATE,TRUNC,WEEKDAY,YEARS_BETWEEN";
    }

    public String do_getSearchStringEscape() {
        return "!";
    }

    public String do_getExtraNameCharacters() {
        return "";
    }

    public int do_getMaxBinaryLiteralLength() {
        return Integer.MAX_VALUE;
    }

    public int do_getMaxCharLiteralLength() {
        return this.connection.maxRowSize;
    }

    public int do_getMaxColumnNameLength() {
        return 128;
    }

    public int do_getMaxColumnsInGroupBy() {
        return 64;
    }

    public int do_getMaxColumnsInIndex() {
        return 16;
    }

    public int do_getMaxColumnsInOrderBy() {
        return 64;
    }

    public int do_getMaxColumnsInSelect() {
        return 1024;
    }

    public int do_getMaxColumnsInTable() {
        return 1024;
    }

    public int do_getMaxConnections() {
        return this.connection.maxSession;
    }

    public int do_getMaxCursorNameLength() {
        return 128;
    }

    public int do_getMaxIndexLength() {
        return 1020;
    }

    public int do_getMaxSchemaNameLength() {
        return 128;
    }

    public int do_getMaxProcedureNameLength() {
        return 128;
    }

    public int do_getMaxCatalogNameLength() {
        return 0;
    }

    public int do_getMaxRowSize() {
        return 0;
    }

    public int do_getMaxStatementLength() {
        return 8000;
    }

    public int do_getMaxStatements() {
        return 128;
    }

    public int do_getMaxTableNameLength() {
        return 128;
    }

    public int do_getMaxTablesInSelect() {
        return 50;
    }

    public int do_getMaxUserNameLength() {
        return 128;
    }

    public int do_getDefaultTransactionIsolation() {
        return 2;
    }

    public String do_getSchemaTerm() {
        return "SCHEMA";
    }

    public String do_getProcedureTerm() {
        return "PROCEDURE";
    }

    public String do_getCatalogTerm() {
        return "CATALOG";
    }

    public String do_getCatalogSeparator() {
        return "";
    }

    public boolean do_isCatalogAtStart() {
        return false;
    }

    public boolean do_isReadOnly() {
        return this.connection.readOnly;
    }

    public boolean do_locatorsUpdateCopy() {
        return false;
    }

    public boolean do_nullsAreSortedHigh() {
        return false;
    }

    public boolean do_nullsAreSortedLow() {
        return true;
    }

    public boolean do_nullsAreSortedAtStart() {
        return false;
    }

    public boolean do_nullsAreSortedAtEnd() {
        return false;
    }

    public boolean do_nullPlusNonNullIsNull() {
        return true;
    }

    public boolean do_usesLocalFiles() {
        return false;
    }

    public boolean do_usesLocalFilePerTable() {
        return false;
    }

    public boolean do_storesUpperCaseIdentifiers() {
        return false;
    }

    public boolean do_storesLowerCaseIdentifiers() {
        return false;
    }

    public boolean do_storesMixedCaseIdentifiers() {
        return true;
    }

    public boolean do_storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    public boolean do_storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    public boolean do_storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    public boolean do_supportsAlterTableWithAddColumn() {
        return true;
    }

    public boolean do_supportsAlterTableWithDropColumn() {
        return true;
    }

    public boolean do_supportsColumnAliasing() {
        return true;
    }

    public boolean do_supportsMixedCaseIdentifiers() {
        return false;
    }

    public boolean do_supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    public boolean do_supportsConvert() {
        return true;
    }

    public boolean do_supportsConvert(int n2, int n3) {
        boolean bl = false;
        if (n3 == 3 || n3 == 2 || n3 == -6 || n3 == 4 || n3 == 6 || n3 == 8 || n3 == 7 || n3 == 5 || n3 == -5 || n3 == 1 || n3 == 12 || n3 == -7 || n3 == 16 || n3 == -1) {
            switch (n2) {
                case -7: 
                case -6: 
                case -5: 
                case -1: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 16: {
                    bl = true;
                    break;
                }
            }
            return bl;
        }
        if (n3 == 91) {
            switch (n2) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 91: 
                case 93: 
                case 2005: {
                    bl = true;
                    break;
                }
            }
            return bl;
        }
        if (n3 == 92) {
            switch (n2) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 92: 
                case 93: 
                case 2005: {
                    bl = true;
                    break;
                }
            }
            return bl;
        }
        if (n3 == 93) {
            switch (n2) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 91: 
                case 92: 
                case 93: 
                case 2005: {
                    bl = true;
                    break;
                }
            }
            return bl;
        }
        if (n3 == 2004) {
            switch (n2) {
                case -4: 
                case 2004: {
                    bl = true;
                    break;
                }
            }
            return bl;
        }
        if (n3 == 2005) {
            switch (n2) {
                case -1: 
                case 2005: {
                    bl = true;
                    break;
                }
            }
            return bl;
        }
        return bl;
    }

    public boolean do_supportsTableCorrelationNames() {
        return true;
    }

    public boolean do_supportsDifferentTableCorrelationNames() {
        return true;
    }

    public boolean do_supportsExpressionsInOrderBy() {
        return true;
    }

    public boolean do_supportsOrderByUnrelated() {
        return true;
    }

    public boolean do_supportsGroupBy() {
        return true;
    }

    public boolean do_supportsGroupByUnrelated() {
        return true;
    }

    public boolean do_supportsGroupByBeyondSelect() {
        return true;
    }

    public boolean do_supportsLikeEscapeClause() {
        return true;
    }

    public boolean do_supportsMultipleResultSets() {
        return true;
    }

    public boolean do_supportsMultipleTransactions() {
        return true;
    }

    public boolean do_supportsNonNullableColumns() {
        return true;
    }

    public boolean do_supportsMinimumSQLGrammar() {
        return true;
    }

    public boolean do_supportsCoreSQLGrammar() {
        return true;
    }

    public boolean do_supportsExtendedSQLGrammar() {
        return true;
    }

    public boolean do_supportsANSI92EntryLevelSQL() {
        return true;
    }

    public boolean do_supportsANSI92IntermediateSQL() {
        return true;
    }

    public boolean do_supportsANSI92FullSQL() {
        return false;
    }

    public boolean do_supportsIntegrityEnhancementFacility() {
        return true;
    }

    public boolean do_supportsOuterJoins() {
        return true;
    }

    public boolean do_supportsFullOuterJoins() {
        return true;
    }

    public boolean do_supportsLimitedOuterJoins() {
        return true;
    }

    public boolean do_supportsSchemasInDataManipulation() {
        return true;
    }

    public boolean do_supportsSchemasInProcedureCalls() {
        return true;
    }

    public boolean do_supportsSchemasInTableDefinitions() {
        return true;
    }

    public boolean do_supportsSchemasInIndexDefinitions() {
        return true;
    }

    public boolean do_supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    public boolean do_supportsCatalogsInDataManipulation() {
        return false;
    }

    public boolean do_supportsCatalogsInProcedureCalls() {
        return false;
    }

    public boolean do_supportsCatalogsInTableDefinitions() {
        return false;
    }

    public boolean do_supportsCatalogsInIndexDefinitions() {
        return false;
    }

    public boolean do_supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    public boolean do_supportsPositionedDelete() {
        return true;
    }

    public boolean do_supportsPositionedUpdate() {
        return true;
    }

    public boolean do_supportsSelectForUpdate() {
        return true;
    }

    public boolean do_supportsStoredProcedures() {
        return true;
    }

    public boolean do_supportsSubqueriesInComparisons() {
        return true;
    }

    public boolean do_supportsSubqueriesInExists() {
        return true;
    }

    public boolean do_supportsSubqueriesInIns() {
        return true;
    }

    public boolean do_supportsSubqueriesInQuantifieds() {
        return true;
    }

    public boolean do_supportsCorrelatedSubqueries() {
        return true;
    }

    public boolean do_supportsUnion() {
        return true;
    }

    public boolean do_supportsUnionAll() {
        return true;
    }

    public boolean do_supportsOpenCursorsAcrossCommit() {
        return true;
    }

    public boolean do_supportsOpenCursorsAcrossRollback() {
        return true;
    }

    public boolean do_supportsOpenStatementsAcrossCommit() {
        return true;
    }

    public boolean do_supportsOpenStatementsAcrossRollback() {
        return true;
    }

    public boolean do_supportsTransactions() {
        return true;
    }

    public boolean do_supportsTransactionIsolationLevel(int n2) {
        return n2 == 2 || n2 == 1 || n2 == 4 || n2 == 8;
    }

    public boolean do_supportsDataDefinitionAndDataManipulationTransactions() {
        return !this.connection.ddlAutoCommit;
    }

    public boolean do_supportsDataManipulationTransactionsOnly() {
        return this.connection.ddlAutoCommit;
    }

    public boolean do_supportsResultSetType(int n2) {
        return n2 == 1003 || n2 == 1004;
    }

    public boolean do_supportsResultSetConcurrency(int n2, int n3) {
        return true;
    }

    public boolean do_supportsBatchUpdates() {
        return true;
    }

    public boolean do_supportsSavepoints() {
        return true;
    }

    public boolean do_supportsNamedParameters() {
        return true;
    }

    public boolean do_supportsMultipleOpenResults() {
        return false;
    }

    public boolean do_supportsGetGeneratedKeys() {
        return true;
    }

    public boolean do_supportsResultSetHoldability(int n2) {
        return n2 == 2 || n2 == 1;
    }

    public boolean do_supportsStatementPooling() {
        return true;
    }

    public boolean do_supportsStoredFunctionsUsingCallSyntax() {
        return true;
    }

    public boolean do_ownUpdatesAreVisible(int n2) {
        return false;
    }

    public boolean do_ownDeletesAreVisible(int n2) {
        return false;
    }

    public boolean do_ownInsertsAreVisible(int n2) {
        return false;
    }

    public boolean do_othersUpdatesAreVisible(int n2) {
        return false;
    }

    public boolean do_othersDeletesAreVisible(int n2) {
        return false;
    }

    public boolean do_othersInsertsAreVisible(int n2) {
        return false;
    }

    public boolean do_updatesAreDetected(int n2) {
        return false;
    }

    public boolean do_deletesAreDetected(int n2) {
        return false;
    }

    public boolean do_insertsAreDetected(int n2) {
        return false;
    }

    public boolean do_doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    public DmdbResultSet do_getPseudoColumns(String string, String string2, String string3, String string4) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    public boolean do_generatedKeyAlwaysReturned() {
        return false;
    }

    public long do_getMaxLogicalLobSize() {
        return Integer.MAX_VALUE;
    }

    public boolean do_supportsRefCursors() {
        return true;
    }

    public RowIdLifetime do_getRowIdLifetime() {
        return RowIdLifetime.ROWID_VALID_FOREVER;
    }

    @Override
    public boolean allProceduresAreCallable() {
        if (this.filterChain == null) {
            return this.do_allProceduresAreCallable();
        }
        return this.filterChain.reset().DatabaseMetaData_allProceduresAreCallable(this);
    }

    @Override
    public boolean allTablesAreSelectable() {
        if (this.filterChain == null) {
            return this.do_allTablesAreSelectable();
        }
        return this.filterChain.reset().DatabaseMetaData_allTablesAreSelectable(this);
    }

    @Override
    public String getURL() {
        if (this.filterChain == null) {
            return this.do_getURL();
        }
        return this.filterChain.reset().DatabaseMetaData_getURL(this);
    }

    @Override
    public String getUserName() {
        if (this.filterChain == null) {
            return this.do_getUserName();
        }
        return this.filterChain.reset().DatabaseMetaData_getUserName(this);
    }

    @Override
    public boolean isReadOnly() {
        if (this.filterChain == null) {
            return this.do_isReadOnly();
        }
        return this.filterChain.reset().DatabaseMetaData_isReadOnly(this);
    }

    @Override
    public boolean nullsAreSortedHigh() {
        if (this.filterChain == null) {
            return this.do_nullsAreSortedHigh();
        }
        return this.filterChain.reset().DatabaseMetaData_nullsAreSortedHigh(this);
    }

    @Override
    public boolean nullsAreSortedLow() {
        if (this.filterChain == null) {
            return this.do_nullsAreSortedLow();
        }
        return this.filterChain.reset().DatabaseMetaData_nullsAreSortedLow(this);
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        if (this.filterChain == null) {
            return this.do_nullsAreSortedAtStart();
        }
        return this.filterChain.reset().DatabaseMetaData_nullsAreSortedAtStart(this);
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        if (this.filterChain == null) {
            return this.do_nullsAreSortedAtEnd();
        }
        return this.filterChain.reset().DatabaseMetaData_nullsAreSortedAtEnd(this);
    }

    @Override
    public String getDatabaseProductName() {
        if (this.filterChain == null) {
            return this.do_getDatabaseProductName();
        }
        return this.filterChain.reset().DatabaseMetaData_getDatabaseProductName(this);
    }

    @Override
    public String getDatabaseProductVersion() {
        if (this.filterChain == null) {
            return this.do_getDatabaseProductVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getDatabaseProductVersion(this);
    }

    @Override
    public String getDriverName() {
        if (this.filterChain == null) {
            return this.do_getDriverName();
        }
        return this.filterChain.reset().DatabaseMetaData_getDriverName(this);
    }

    @Override
    public String getDriverVersion() {
        if (this.filterChain == null) {
            return this.do_getDriverVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getDriverVersion(this);
    }

    @Override
    public int getDriverMajorVersion() {
        if (this.filterChain == null) {
            return this.do_getDriverMajorVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getDriverMajorVersion(this);
    }

    @Override
    public int getDriverMinorVersion() {
        if (this.filterChain == null) {
            return this.do_getDriverMinorVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getDriverMinorVersion(this);
    }

    @Override
    public boolean usesLocalFiles() {
        if (this.filterChain == null) {
            return this.do_usesLocalFiles();
        }
        return this.filterChain.reset().DatabaseMetaData_usesLocalFiles(this);
    }

    @Override
    public boolean usesLocalFilePerTable() {
        if (this.filterChain == null) {
            return this.do_usesLocalFilePerTable();
        }
        return this.filterChain.reset().DatabaseMetaData_usesLocalFilePerTable(this);
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        if (this.filterChain == null) {
            return this.do_supportsMixedCaseIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsMixedCaseIdentifiers(this);
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        if (this.filterChain == null) {
            return this.do_storesUpperCaseIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_storesUpperCaseIdentifiers(this);
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        if (this.filterChain == null) {
            return this.do_storesLowerCaseIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_storesLowerCaseIdentifiers(this);
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        if (this.filterChain == null) {
            return this.do_storesMixedCaseIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_storesMixedCaseIdentifiers(this);
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        if (this.filterChain == null) {
            return this.do_supportsMixedCaseQuotedIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(this);
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        if (this.filterChain == null) {
            return this.do_storesUpperCaseQuotedIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_storesUpperCaseQuotedIdentifiers(this);
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        if (this.filterChain == null) {
            return this.do_storesLowerCaseQuotedIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_storesLowerCaseQuotedIdentifiers(this);
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        if (this.filterChain == null) {
            return this.do_storesMixedCaseQuotedIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_storesMixedCaseQuotedIdentifiers(this);
    }

    @Override
    public String getIdentifierQuoteString() {
        if (this.filterChain == null) {
            return this.do_getIdentifierQuoteString();
        }
        return this.filterChain.reset().DatabaseMetaData_getIdentifierQuoteString(this);
    }

    @Override
    public String getSQLKeywords() {
        if (this.filterChain == null) {
            return this.do_getSQLKeywords();
        }
        return this.filterChain.reset().DatabaseMetaData_getSQLKeywords(this);
    }

    @Override
    public String getNumericFunctions() {
        if (this.filterChain == null) {
            return this.do_getNumericFunctions();
        }
        return this.filterChain.reset().DatabaseMetaData_getNumericFunctions(this);
    }

    @Override
    public String getStringFunctions() {
        if (this.filterChain == null) {
            return this.do_getStringFunctions();
        }
        return this.filterChain.reset().DatabaseMetaData_getStringFunctions(this);
    }

    @Override
    public String getSystemFunctions() {
        if (this.filterChain == null) {
            return this.do_getSystemFunctions();
        }
        return this.filterChain.reset().DatabaseMetaData_getSystemFunctions(this);
    }

    @Override
    public String getTimeDateFunctions() {
        if (this.filterChain == null) {
            return this.do_getTimeDateFunctions();
        }
        return this.filterChain.reset().DatabaseMetaData_getTimeDateFunctions(this);
    }

    @Override
    public String getSearchStringEscape() {
        if (this.filterChain == null) {
            return this.do_getSearchStringEscape();
        }
        return this.filterChain.reset().DatabaseMetaData_getSearchStringEscape(this);
    }

    @Override
    public String getExtraNameCharacters() {
        if (this.filterChain == null) {
            return this.do_getExtraNameCharacters();
        }
        return this.filterChain.reset().DatabaseMetaData_getExtraNameCharacters(this);
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        if (this.filterChain == null) {
            return this.do_supportsAlterTableWithAddColumn();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsAlterTableWithAddColumn(this);
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        if (this.filterChain == null) {
            return this.do_supportsAlterTableWithDropColumn();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsAlterTableWithDropColumn(this);
    }

    @Override
    public boolean supportsColumnAliasing() {
        if (this.filterChain == null) {
            return this.do_supportsColumnAliasing();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsColumnAliasing(this);
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        if (this.filterChain == null) {
            return this.do_nullPlusNonNullIsNull();
        }
        return this.filterChain.reset().DatabaseMetaData_nullPlusNonNullIsNull(this);
    }

    @Override
    public boolean supportsConvert() {
        if (this.filterChain == null) {
            return this.do_supportsConvert();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsConvert(this);
    }

    @Override
    public boolean supportsConvert(int n2, int n3) {
        if (this.filterChain == null) {
            return this.do_supportsConvert(n2, n3);
        }
        return this.filterChain.reset().DatabaseMetaData_supportsConvert(this, n2, n3);
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        if (this.filterChain == null) {
            return this.do_supportsTableCorrelationNames();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsTableCorrelationNames(this);
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        if (this.filterChain == null) {
            return this.do_supportsDifferentTableCorrelationNames();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsDifferentTableCorrelationNames(this);
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        if (this.filterChain == null) {
            return this.do_supportsExpressionsInOrderBy();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsExpressionsInOrderBy(this);
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        if (this.filterChain == null) {
            return this.do_supportsOrderByUnrelated();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsOrderByUnrelated(this);
    }

    @Override
    public boolean supportsGroupBy() {
        if (this.filterChain == null) {
            return this.do_supportsGroupBy();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsGroupBy(this);
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        if (this.filterChain == null) {
            return this.do_supportsGroupByUnrelated();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsGroupByUnrelated(this);
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        if (this.filterChain == null) {
            return this.do_supportsGroupByBeyondSelect();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsGroupByBeyondSelect(this);
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        if (this.filterChain == null) {
            return this.do_supportsLikeEscapeClause();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsLikeEscapeClause(this);
    }

    @Override
    public boolean supportsMultipleResultSets() {
        if (this.filterChain == null) {
            return this.do_supportsMultipleResultSets();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsMultipleResultSets(this);
    }

    @Override
    public boolean supportsMultipleTransactions() {
        if (this.filterChain == null) {
            return this.do_supportsMultipleTransactions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsMultipleTransactions(this);
    }

    @Override
    public boolean supportsNonNullableColumns() {
        if (this.filterChain == null) {
            return this.do_supportsNonNullableColumns();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsNonNullableColumns(this);
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        if (this.filterChain == null) {
            return this.do_supportsMinimumSQLGrammar();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsMinimumSQLGrammar(this);
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        if (this.filterChain == null) {
            return this.do_supportsCoreSQLGrammar();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCoreSQLGrammar(this);
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        if (this.filterChain == null) {
            return this.do_supportsExtendedSQLGrammar();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsExtendedSQLGrammar(this);
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        if (this.filterChain == null) {
            return this.do_supportsANSI92EntryLevelSQL();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsANSI92EntryLevelSQL(this);
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        if (this.filterChain == null) {
            return this.do_supportsANSI92IntermediateSQL();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsANSI92IntermediateSQL(this);
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        if (this.filterChain == null) {
            return this.do_supportsANSI92FullSQL();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsANSI92FullSQL(this);
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        if (this.filterChain == null) {
            return this.do_supportsIntegrityEnhancementFacility();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsIntegrityEnhancementFacility(this);
    }

    @Override
    public boolean supportsOuterJoins() {
        if (this.filterChain == null) {
            return this.do_supportsOuterJoins();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsOuterJoins(this);
    }

    @Override
    public boolean supportsFullOuterJoins() {
        if (this.filterChain == null) {
            return this.do_supportsFullOuterJoins();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsFullOuterJoins(this);
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        if (this.filterChain == null) {
            return this.do_supportsLimitedOuterJoins();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsLimitedOuterJoins(this);
    }

    @Override
    public String getSchemaTerm() {
        if (this.filterChain == null) {
            return this.do_getSchemaTerm();
        }
        return this.filterChain.reset().DatabaseMetaData_getSchemaTerm(this);
    }

    @Override
    public String getProcedureTerm() {
        if (this.filterChain == null) {
            return this.do_getProcedureTerm();
        }
        return this.filterChain.reset().DatabaseMetaData_getProcedureTerm(this);
    }

    @Override
    public String getCatalogTerm() {
        if (this.filterChain == null) {
            return this.do_getCatalogTerm();
        }
        return this.filterChain.reset().DatabaseMetaData_getCatalogTerm(this);
    }

    @Override
    public boolean isCatalogAtStart() {
        if (this.filterChain == null) {
            return this.do_isCatalogAtStart();
        }
        return this.filterChain.reset().DatabaseMetaData_isCatalogAtStart(this);
    }

    @Override
    public String getCatalogSeparator() {
        if (this.filterChain == null) {
            return this.do_getCatalogSeparator();
        }
        return this.filterChain.reset().DatabaseMetaData_getCatalogSeparator(this);
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        if (this.filterChain == null) {
            return this.do_supportsSchemasInDataManipulation();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSchemasInDataManipulation(this);
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        if (this.filterChain == null) {
            return this.do_supportsSchemasInProcedureCalls();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSchemasInProcedureCalls(this);
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        if (this.filterChain == null) {
            return this.do_supportsSchemasInTableDefinitions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSchemasInTableDefinitions(this);
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        if (this.filterChain == null) {
            return this.do_supportsSchemasInIndexDefinitions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSchemasInIndexDefinitions(this);
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        if (this.filterChain == null) {
            return this.do_supportsSchemasInPrivilegeDefinitions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(this);
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        if (this.filterChain == null) {
            return this.do_supportsCatalogsInDataManipulation();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCatalogsInDataManipulation(this);
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        if (this.filterChain == null) {
            return this.do_supportsCatalogsInProcedureCalls();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCatalogsInProcedureCalls(this);
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        if (this.filterChain == null) {
            return this.do_supportsCatalogsInTableDefinitions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCatalogsInTableDefinitions(this);
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        if (this.filterChain == null) {
            return this.do_supportsCatalogsInIndexDefinitions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCatalogsInIndexDefinitions(this);
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        if (this.filterChain == null) {
            return this.do_supportsCatalogsInPrivilegeDefinitions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(this);
    }

    @Override
    public boolean supportsPositionedDelete() {
        if (this.filterChain == null) {
            return this.do_supportsPositionedDelete();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsPositionedDelete(this);
    }

    @Override
    public boolean supportsPositionedUpdate() {
        if (this.filterChain == null) {
            return this.do_supportsPositionedUpdate();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsPositionedUpdate(this);
    }

    @Override
    public boolean supportsSelectForUpdate() {
        if (this.filterChain == null) {
            return this.do_supportsSelectForUpdate();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSelectForUpdate(this);
    }

    @Override
    public boolean supportsStoredProcedures() {
        if (this.filterChain == null) {
            return this.do_supportsStoredProcedures();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsStoredProcedures(this);
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        if (this.filterChain == null) {
            return this.do_supportsSubqueriesInComparisons();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSubqueriesInComparisons(this);
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        if (this.filterChain == null) {
            return this.do_supportsSubqueriesInExists();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSubqueriesInExists(this);
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        if (this.filterChain == null) {
            return this.do_supportsSubqueriesInIns();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSubqueriesInIns(this);
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        if (this.filterChain == null) {
            return this.do_supportsSubqueriesInQuantifieds();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSubqueriesInQuantifieds(this);
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        if (this.filterChain == null) {
            return this.do_supportsCorrelatedSubqueries();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCorrelatedSubqueries(this);
    }

    @Override
    public boolean supportsUnion() {
        if (this.filterChain == null) {
            return this.do_supportsUnion();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsUnion(this);
    }

    @Override
    public boolean supportsUnionAll() {
        if (this.filterChain == null) {
            return this.do_supportsUnionAll();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsUnionAll(this);
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        if (this.filterChain == null) {
            return this.do_supportsOpenCursorsAcrossCommit();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsOpenCursorsAcrossCommit(this);
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        if (this.filterChain == null) {
            return this.do_supportsOpenCursorsAcrossRollback();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsOpenCursorsAcrossRollback(this);
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        if (this.filterChain == null) {
            return this.do_supportsOpenStatementsAcrossCommit();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsOpenStatementsAcrossCommit(this);
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        if (this.filterChain == null) {
            return this.do_supportsOpenStatementsAcrossRollback();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsOpenStatementsAcrossRollback(this);
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        if (this.filterChain == null) {
            return this.do_getMaxBinaryLiteralLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxBinaryLiteralLength(this);
    }

    @Override
    public int getMaxCharLiteralLength() {
        if (this.filterChain == null) {
            return this.do_getMaxCharLiteralLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxCharLiteralLength(this);
    }

    @Override
    public int getMaxColumnNameLength() {
        if (this.filterChain == null) {
            return this.do_getMaxColumnNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxColumnNameLength(this);
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        if (this.filterChain == null) {
            return this.do_getMaxColumnsInGroupBy();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxColumnsInGroupBy(this);
    }

    @Override
    public int getMaxColumnsInIndex() {
        if (this.filterChain == null) {
            return this.do_getMaxColumnsInIndex();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxColumnsInIndex(this);
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        if (this.filterChain == null) {
            return this.do_getMaxColumnsInOrderBy();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxColumnsInOrderBy(this);
    }

    @Override
    public int getMaxColumnsInSelect() {
        if (this.filterChain == null) {
            return this.do_getMaxColumnsInSelect();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxColumnsInSelect(this);
    }

    @Override
    public int getMaxColumnsInTable() {
        if (this.filterChain == null) {
            return this.do_getMaxColumnsInTable();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxColumnsInTable(this);
    }

    @Override
    public int getMaxConnections() {
        if (this.filterChain == null) {
            return this.do_getMaxConnections();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxConnections(this);
    }

    @Override
    public int getMaxCursorNameLength() {
        if (this.filterChain == null) {
            return this.do_getMaxCursorNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxCursorNameLength(this);
    }

    @Override
    public int getMaxIndexLength() {
        if (this.filterChain == null) {
            return this.do_getMaxIndexLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxIndexLength(this);
    }

    @Override
    public int getMaxSchemaNameLength() {
        if (this.filterChain == null) {
            return this.do_getMaxSchemaNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxSchemaNameLength(this);
    }

    @Override
    public int getMaxProcedureNameLength() {
        if (this.filterChain == null) {
            return this.do_getMaxProcedureNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxProcedureNameLength(this);
    }

    @Override
    public int getMaxCatalogNameLength() {
        if (this.filterChain == null) {
            return this.do_getMaxCatalogNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxCatalogNameLength(this);
    }

    @Override
    public int getMaxRowSize() {
        if (this.filterChain == null) {
            return this.do_getMaxRowSize();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxRowSize(this);
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        if (this.filterChain == null) {
            return this.do_doesMaxRowSizeIncludeBlobs();
        }
        return this.filterChain.reset().DatabaseMetaData_doesMaxRowSizeIncludeBlobs(this);
    }

    @Override
    public int getMaxStatementLength() {
        if (this.filterChain == null) {
            return this.do_getMaxStatementLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxStatementLength(this);
    }

    @Override
    public int getMaxStatements() {
        if (this.filterChain == null) {
            return this.do_getMaxStatements();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxStatements(this);
    }

    @Override
    public int getMaxTableNameLength() {
        if (this.filterChain == null) {
            return this.do_getMaxTableNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxTableNameLength(this);
    }

    @Override
    public int getMaxTablesInSelect() {
        if (this.filterChain == null) {
            return this.do_getMaxTablesInSelect();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxTablesInSelect(this);
    }

    @Override
    public int getMaxUserNameLength() {
        if (this.filterChain == null) {
            return this.do_getMaxUserNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxUserNameLength(this);
    }

    @Override
    public int getDefaultTransactionIsolation() {
        if (this.filterChain == null) {
            return this.do_getDefaultTransactionIsolation();
        }
        return this.filterChain.reset().DatabaseMetaData_getDefaultTransactionIsolation(this);
    }

    @Override
    public boolean supportsTransactions() {
        if (this.filterChain == null) {
            return this.do_supportsTransactions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsTransactions(this);
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n2) {
        if (this.filterChain == null) {
            return this.do_supportsTransactionIsolationLevel(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_supportsTransactionIsolationLevel(this, n2);
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        if (this.filterChain == null) {
            return this.do_supportsDataDefinitionAndDataManipulationTransactions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(this);
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        if (this.filterChain == null) {
            return this.do_supportsDataManipulationTransactionsOnly();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsDataManipulationTransactionsOnly(this);
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        if (this.filterChain == null) {
            return this.do_dataDefinitionCausesTransactionCommit();
        }
        return this.filterChain.reset().DatabaseMetaData_dataDefinitionCausesTransactionCommit(this);
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        if (this.filterChain == null) {
            return this.do_dataDefinitionIgnoredInTransactions();
        }
        return this.filterChain.reset().DatabaseMetaData_dataDefinitionIgnoredInTransactions(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getProcedures(String string, String string2, String string3) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getProcedures(string, string2, string3);
            }
            return this.filterChain.reset().DatabaseMetaData_getProcedures(this, string, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getProcedureColumns(string, string2, string3, string4);
            }
            return this.filterChain.reset().DatabaseMetaData_getProcedureColumns(this, string, string2, string3, string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTables(string, string2, string3, stringArray);
            }
            return this.filterChain.reset().DatabaseMetaData_getTables(this, string, string2, string3, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSchemas() {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSchemas();
            }
            return this.filterChain.reset().DatabaseMetaData_getSchemas(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCatalogs() {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCatalogs();
            }
            return this.filterChain.reset().DatabaseMetaData_getCatalogs(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTableTypes() {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTableTypes();
            }
            return this.filterChain.reset().DatabaseMetaData_getTableTypes(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getColumns(string, string2, string3, string4);
            }
            return this.filterChain.reset().DatabaseMetaData_getColumns(this, string, string2, string3, string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getColumnPrivileges(string, string2, string3, string4);
            }
            return this.filterChain.reset().DatabaseMetaData_getColumnPrivileges(this, string, string2, string3, string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTablePrivileges(string, string2, string3);
            }
            return this.filterChain.reset().DatabaseMetaData_getTablePrivileges(this, string, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n2, boolean bl) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            DmdbConnection dmdbConnection2 = this.connection;
            synchronized (dmdbConnection2) {
                if (this.filterChain == null) {
                    return this.do_getBestRowIdentifier(string, string2, string3, n2, bl);
                }
                return this.filterChain.reset().DatabaseMetaData_getBestRowIdentifier(this, string, string2, string3, n2, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getVersionColumns(string, string2, string3);
            }
            return this.filterChain.reset().DatabaseMetaData_getVersionColumns(this, string, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getPrimaryKeys(string, string2, string3);
            }
            return this.filterChain.reset().DatabaseMetaData_getPrimaryKeys(this, string, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getImportedKeys(string, string2, string3);
            }
            return this.filterChain.reset().DatabaseMetaData_getImportedKeys(this, string, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getExportedKeys(string, string2, string3);
            }
            return this.filterChain.reset().DatabaseMetaData_getExportedKeys(this, string, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCrossReference(string, string2, string3, string4, string5, string6);
            }
            return this.filterChain.reset().DatabaseMetaData_getCrossReference(this, string, string2, string3, string4, string5, string6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTypeInfo() {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTypeInfo();
            }
            return this.filterChain.reset().DatabaseMetaData_getTypeInfo(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getIndexInfo(string, string2, string3, bl, bl2);
            }
            return this.filterChain.reset().DatabaseMetaData_getIndexInfo(this, string, string2, string3, bl, bl2);
        }
    }

    @Override
    public boolean supportsResultSetType(int n2) {
        if (this.filterChain == null) {
            return this.do_supportsResultSetType(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_supportsResultSetType(this, n2);
    }

    @Override
    public boolean supportsResultSetConcurrency(int n2, int n3) {
        if (this.filterChain == null) {
            return this.do_supportsResultSetConcurrency(n2, n3);
        }
        return this.filterChain.reset().DatabaseMetaData_supportsResultSetConcurrency(this, n2, n3);
    }

    @Override
    public boolean ownUpdatesAreVisible(int n2) {
        if (this.filterChain == null) {
            return this.do_ownUpdatesAreVisible(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_ownUpdatesAreVisible(this, n2);
    }

    @Override
    public boolean ownDeletesAreVisible(int n2) {
        if (this.filterChain == null) {
            return this.do_ownDeletesAreVisible(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_ownDeletesAreVisible(this, n2);
    }

    @Override
    public boolean ownInsertsAreVisible(int n2) {
        if (this.filterChain == null) {
            return this.do_ownInsertsAreVisible(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_ownInsertsAreVisible(this, n2);
    }

    @Override
    public boolean othersUpdatesAreVisible(int n2) {
        if (this.filterChain == null) {
            return this.do_othersUpdatesAreVisible(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_othersUpdatesAreVisible(this, n2);
    }

    @Override
    public boolean othersDeletesAreVisible(int n2) {
        if (this.filterChain == null) {
            return this.do_othersDeletesAreVisible(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_othersDeletesAreVisible(this, n2);
    }

    @Override
    public boolean othersInsertsAreVisible(int n2) {
        if (this.filterChain == null) {
            return this.do_othersInsertsAreVisible(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_othersInsertsAreVisible(this, n2);
    }

    @Override
    public boolean updatesAreDetected(int n2) {
        if (this.filterChain == null) {
            return this.do_updatesAreDetected(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_updatesAreDetected(this, n2);
    }

    @Override
    public boolean deletesAreDetected(int n2) {
        if (this.filterChain == null) {
            return this.do_deletesAreDetected(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_deletesAreDetected(this, n2);
    }

    @Override
    public boolean insertsAreDetected(int n2) {
        if (this.filterChain == null) {
            return this.do_insertsAreDetected(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_insertsAreDetected(this, n2);
    }

    @Override
    public boolean supportsBatchUpdates() {
        if (this.filterChain == null) {
            return this.do_supportsBatchUpdates();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsBatchUpdates(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getUDTs(string, string2, string3, nArray);
            }
            return this.filterChain.reset().DatabaseMetaData_getUDTs(this, string, string2, string3, nArray);
        }
    }

    @Override
    public Connection getConnection() {
        if (this.filterChain == null) {
            return this.do_getConnection();
        }
        return this.filterChain.reset().DatabaseMetaData_getConnection(this);
    }

    @Override
    public boolean supportsSavepoints() {
        if (this.filterChain == null) {
            return this.do_supportsSavepoints();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSavepoints(this);
    }

    @Override
    public boolean supportsNamedParameters() {
        if (this.filterChain == null) {
            return this.do_supportsNamedParameters();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsNamedParameters(this);
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        if (this.filterChain == null) {
            return this.do_supportsMultipleOpenResults();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsMultipleOpenResults(this);
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        if (this.filterChain == null) {
            return this.do_supportsGetGeneratedKeys();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsGetGeneratedKeys(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSuperTypes(string, string2, string3);
            }
            return this.filterChain.reset().DatabaseMetaData_getSuperTypes(this, string, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSuperTables(string, string2, string3);
            }
            return this.filterChain.reset().DatabaseMetaData_getSuperTables(this, string, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getAttributes(string, string2, string3, string4);
            }
            return this.filterChain.reset().DatabaseMetaData_getAttributes(this, string, string2, string3, string4);
        }
    }

    @Override
    public boolean supportsResultSetHoldability(int n2) {
        if (this.filterChain == null) {
            return this.do_supportsResultSetHoldability(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_supportsResultSetHoldability(this, n2);
    }

    @Override
    public int getResultSetHoldability() {
        if (this.filterChain == null) {
            return this.do_getResultSetHoldability();
        }
        return this.filterChain.reset().DatabaseMetaData_getResultSetHoldability(this);
    }

    @Override
    public int getDatabaseMajorVersion() {
        if (this.filterChain == null) {
            return this.do_getDatabaseMajorVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getDatabaseMajorVersion(this);
    }

    @Override
    public int getDatabaseMinorVersion() {
        if (this.filterChain == null) {
            return this.do_getDatabaseMinorVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getDatabaseMinorVersion(this);
    }

    @Override
    public int getJDBCMajorVersion() {
        if (this.filterChain == null) {
            return this.do_getJDBCMajorVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getJDBCMajorVersion(this);
    }

    @Override
    public int getJDBCMinorVersion() {
        if (this.filterChain == null) {
            return this.do_getJDBCMinorVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getJDBCMinorVersion(this);
    }

    @Override
    public int getSQLStateType() {
        if (this.filterChain == null) {
            return this.do_getSQLStateType();
        }
        return this.filterChain.reset().DatabaseMetaData_getSQLStateType(this);
    }

    @Override
    public boolean locatorsUpdateCopy() {
        if (this.filterChain == null) {
            return this.do_locatorsUpdateCopy();
        }
        return this.filterChain.reset().DatabaseMetaData_locatorsUpdateCopy(this);
    }

    @Override
    public boolean supportsStatementPooling() {
        if (this.filterChain == null) {
            return this.do_supportsStatementPooling();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsStatementPooling(this);
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        if (this.filterChain == null) {
            return this.do_getRowIdLifetime();
        }
        return this.filterChain.reset().DatabaseMetaData_getRowIdLifetime(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSchemas(String string, String string2) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSchemas(string, string2);
            }
            return this.filterChain.reset().DatabaseMetaData_getSchemas(this, string, string2);
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        if (this.filterChain == null) {
            return this.do_supportsStoredFunctionsUsingCallSyntax();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(this);
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        if (this.filterChain == null) {
            return this.do_autoCommitFailureClosesAllResultSets();
        }
        return this.filterChain.reset().DatabaseMetaData_autoCommitFailureClosesAllResultSets(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getClientInfoProperties() {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getClientInfoProperties();
            }
            return this.filterChain.reset().DatabaseMetaData_getClientInfoProperties(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getFunctions(String string, String string2, String string3) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getFunctions(string, string2, string3);
            }
            return this.filterChain.reset().DatabaseMetaData_getFunctions(this, string, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getFunctionColumns(string, string2, string3, string4);
            }
            return this.filterChain.reset().DatabaseMetaData_getFunctionColumns(this, string, string2, string3, string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getPseudoColumns(string, string2, string3, string4);
            }
            return this.filterChain.reset().DatabaseMetaData_getPseudoColumns(this, string, string2, string3, string4);
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        if (this.filterChain == null) {
            return this.do_generatedKeyAlwaysReturned();
        }
        return this.filterChain.reset().DatabaseMetaData_generatedKeyAlwaysReturned(this);
    }

    @Override
    public long getMaxLogicalLobSize() {
        if (this.filterChain == null) {
            return this.do_getMaxLogicalLobSize();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxLogicalLobSize(this);
    }

    @Override
    public boolean supportsRefCursors() {
        if (this.filterChain == null) {
            return this.do_supportsRefCursors();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsRefCursors(this);
    }

    public Object unwrap(Class clazz) {
        return clazz.cast(this);
    }

    public boolean isWrapperFor(Class clazz) {
        return clazz.isInstance(this);
    }

    public static String SQL_getPkgProcedureColumns(String string, String string2, String string3, String string4, int n2, boolean bl) {
        string = string == null ? "%" : StringUtil.processSingleQuoteOfName(string);
        string2 = string2 == null ? "%" : StringUtil.processSingleQuoteOfName(string2);
        string3 = string3 == null ? "%" : StringUtil.processSingleQuoteOfName(string3);
        string4 = string4 == null ? "%" : StringUtil.processSingleQuoteOfName(string4);
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT ");
        stringBuilder.append("PACKAGES.NAME AS PROCEDURE_CAT,");
        stringBuilder.append("SCHEMAS.NAME AS PROCEDURE_SCHEM,");
        stringBuilder.append("PROCS.MTDNAME AS PROCEDURE_NAME,");
        stringBuilder.append("CASE TRIM(ARG.IOFLAG) WHEN 'R' THEN NULL ELSE ARG.NAME END AS COLUMN_NAME, ");
        stringBuilder.append("CASE TRIM(ARG.IOFLAG)");
        stringBuilder.append(" WHEN 'I' THEN 1");
        stringBuilder.append(" WHEN 'O' THEN 4");
        stringBuilder.append(" WHEN 'IO' THEN 2");
        stringBuilder.append(" WHEN 'R' THEN 5");
        stringBuilder.append(" END AS COLUMN_TYPE, ");
        stringBuilder.append(DmdbDatabaseMetaData.makeDataTypeClause("ARG.TYPE$", "ARG.SCALE", bl));
        stringBuilder.append("AS DATA_TYPE, ");
        stringBuilder.append(DmdbDatabaseMetaData.makeDataTypeNameClause("ARG.TYPE$", bl));
        stringBuilder.append("AS TYPE_NAME, ");
        stringBuilder.append("CASE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END ");
        stringBuilder.append("AS \"PRECISION\", ");
        stringBuilder.append("CASE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END ");
        stringBuilder.append("AS LENGTH, ");
        stringBuilder.append("CASE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) END ");
        stringBuilder.append("AS SCALE, ");
        stringBuilder.append("10 AS RADIX, ");
        stringBuilder.append("1 AS NULLABLE, ");
        stringBuilder.append("NULL AS REMARKS, ");
        stringBuilder.append("ARG.DEFVAL AS COLUMN_DEF, ");
        stringBuilder.append("NULL AS SQL_DATA_TYPE, ");
        stringBuilder.append("NULL AS SQL_DATETIME_SUB, ");
        stringBuilder.append("NULL AS CHAR_OCTET_LENGTH, ");
        stringBuilder.append("ARG.PARAMID AS ORDINAL_POSITION, ");
        stringBuilder.append("CASE ARG.NULLABLE WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE, ");
        stringBuilder.append("NULL AS SPECIFIC_NAME ");
        stringBuilder.append("FROM");
        stringBuilder.append(DmdbDatabaseMetaData.schemaClause(string, "SCHEMAS")).append(",");
        stringBuilder.append(DmdbDatabaseMetaData.pkgClause(string2, "PACKAGES")).append(",");
        stringBuilder.append(DmdbDatabaseMetaData.pkgprocClause(string2, string3, n2, "PROCS")).append(",");
        stringBuilder.append(DmdbDatabaseMetaData.pkgprocargClause(string4, "ARG"));
        stringBuilder.append(" WHERE");
        stringBuilder.append(" PROCS.PKGID = PACKAGES.ID");
        stringBuilder.append(" AND PACKAGES.SCHID = SCHEMAS.ID");
        stringBuilder.append(" AND ARG.PKGID = PROCS.PKGID");
        stringBuilder.append(" AND ARG.MTDID = PROCS.MTDID");
        stringBuilder.append(" ORDER BY PROCEDURE_SCHEM ASC, PROCEDURE_CAT ASC, PROCEDURE_NAME ASC, ORDINAL_POSITION ASC;");
        String string5 = "/*+ gateway metadata JDBC_getPkgProcedureColumns(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + "," + DmdbDatabaseMetaData.gatewayFormat(string4) + DmdbDatabaseMetaData.gatewayFormat(n2) + ")*/ ";
        return String.valueOf(string5) + stringBuilder.toString();
    }

    private static String makeDataTypeClause(String string, String string2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CASE ").append(string);
        stringBuilder.append(" WHEN 'BOOL' THEN 16");
        stringBuilder.append(" WHEN 'BOOLEAN' THEN 16");
        stringBuilder.append(" WHEN 'BIT' THEN -7");
        stringBuilder.append(" WHEN 'NUMBER' THEN 3");
        stringBuilder.append(" WHEN 'NUMERIC' THEN 3");
        stringBuilder.append(" WHEN 'DEC' THEN 3");
        stringBuilder.append(" WHEN 'DECIMAL' THEN 3");
        if (bl) {
            stringBuilder.append(" WHEN 'INT' THEN 3");
            stringBuilder.append(" WHEN 'INTEGER' THEN 3");
            stringBuilder.append(" WHEN 'BIGINT' THEN 3");
            stringBuilder.append(" WHEN 'TINYINT' THEN 3");
            stringBuilder.append(" WHEN 'SMALLINT' THEN 3");
        } else {
            stringBuilder.append(" WHEN 'INT' THEN 4");
            stringBuilder.append(" WHEN 'INTEGER' THEN 4");
            stringBuilder.append(" WHEN 'BIGINT' THEN -5");
            stringBuilder.append(" WHEN 'TINYINT' THEN -6");
            stringBuilder.append(" WHEN 'SMALLINT' THEN 5");
        }
        stringBuilder.append(" WHEN 'FLOAT' THEN 6");
        stringBuilder.append(" WHEN 'DOUBLE' THEN 8");
        stringBuilder.append(" WHEN 'REAL' THEN 7");
        stringBuilder.append(" WHEN 'DOUBLE PRECISION' THEN 8");
        stringBuilder.append(" WHEN 'CHARACTER' THEN 1");
        stringBuilder.append(" WHEN 'VARCHAR' THEN 12");
        stringBuilder.append(" WHEN 'VARCHAR2' THEN 12");
        stringBuilder.append(" WHEN 'TEXT' THEN -1");
        stringBuilder.append(" WHEN 'LONGVARCHAR' THEN -1");
        stringBuilder.append(" WHEN 'CLOB' THEN 2005");
        stringBuilder.append(" WHEN 'BYTE' THEN -6");
        stringBuilder.append(" WHEN 'BINARY' THEN -2");
        stringBuilder.append(" WHEN 'VARBINARY' THEN -3");
        stringBuilder.append(" WHEN 'LONGVARBINARY' THEN -4");
        stringBuilder.append(" WHEN 'BLOB' THEN 2004");
        stringBuilder.append(" WHEN 'IMAGE' THEN -4");
        stringBuilder.append(" WHEN 'TIMESTAMP' THEN 93");
        stringBuilder.append(" WHEN 'DATE' THEN 91");
        stringBuilder.append(" WHEN 'TIME' THEN 92");
        stringBuilder.append(" WHEN 'DATETIME' THEN 93");
        stringBuilder.append(" WHEN 'CURSOR' THEN -10");
        stringBuilder.append(" ELSE SF_GET_DATA_TYPE(").append(string).append(", CAST(").append(string2).append(" AS INT), 3)");
        stringBuilder.append(" END ");
        return stringBuilder.toString();
    }

    private static String makeDataTypeNameClause(String string, boolean bl) {
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CASE ");
            stringBuilder.append("(CASE INSTR(" + string + ",'CLASS',1,1) WHEN 0 THEN " + string + " ELSE SF_GET_CLASS_NAME(" + string + ") END)  ");
            stringBuilder.append("WHEN 'INT' THEN 'NUMBER' ");
            stringBuilder.append("WHEN 'INTEGER' THEN 'NUMBER' ");
            stringBuilder.append("WHEN 'BIGINT' THEN 'NUMBER' ");
            stringBuilder.append("WHEN 'TINYINT' THEN 'NUMBER' ");
            stringBuilder.append("WHEN 'SMALLINT' THEN 'NUMBER' ");
            stringBuilder.append("WHEN 'NUMERIC' THEN 'NUMBER' ");
            stringBuilder.append("WHEN 'DEC' THEN 'NUMBER' ");
            stringBuilder.append("WHEN 'DECIMAL' THEN 'NUMBER' ");
            stringBuilder.append("ELSE ");
            stringBuilder.append("(CASE INSTR(" + string + ",'CLASS',1,1) WHEN 0 THEN " + string + " ELSE SF_GET_CLASS_NAME(" + string + ") END)  ");
            stringBuilder.append("END ");
            return stringBuilder.toString();
        }
        return "CASE INSTR(" + string + ",'CLASS',1,1) WHEN 0 THEN " + string + " ELSE SF_GET_CLASS_NAME(" + string + ") END ";
    }

    private static String makeTableTypeClause(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "(";
        String string2 = "CAST((INFO3 & 0x00FF & 0x003F) AS INT) not in ( 9, 27, 29, 25, 12,7, 21, 23, 18, 5) ";
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string3 = stringArray2[n3];
                if (string3 != null) {
                    if (string3.equalsIgnoreCase("TABLE")) {
                        stringBuilder.append("OR (SUBTYPE$='UTAB' AND ").append(string2).append(")");
                    } else if (string3.equalsIgnoreCase("VIEW")) {
                        stringBuilder.append("OR SUBTYPE$='VIEW' ");
                    } else if (string3.equalsIgnoreCase("SYSTEM TABLE")) {
                        stringBuilder.append("OR SUBTYPE$='STAB' ");
                    } else if (string3.equalsIgnoreCase("SYNONYM")) {
                        stringBuilder.append("OR SUBTYPE$='SYNOM' ");
                    } else if (string3.equalsIgnoreCase("GLOBAL TEMPORARY")) {
                        stringBuilder.append("OR ((info3 & 0x40) >> 6) =1 ");
                    } else if (string3.equalsIgnoreCase("LOCAL TEMPORARY")) {
                        stringBuilder.append("OR ((info3 & 0x40) >> 6) =2 ");
                    }
                }
                ++n3;
            }
            if (stringBuilder.length() > 3) {
                string = String.valueOf(string) + stringBuilder.substring(3);
                string = String.valueOf(string) + ")";
                return string;
            }
        } else {
            stringBuilder.append("( ");
            stringBuilder.append("(SUBTYPE$='UTAB' AND ").append(string2).append(") ");
            stringBuilder.append("OR SUBTYPE$ in ('STAB', 'VIEW', 'SYNOM') ");
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
        return null;
    }

    public static String SQL_getPkgProcedures(String string, String string2, String string3, int n2) {
        string = string == null ? "%" : StringUtil.processSingleQuoteOfName(string);
        string2 = string2 == null ? "%" : StringUtil.processSingleQuoteOfName(string2);
        string3 = string3 == null ? "%" : StringUtil.processSingleQuoteOfName(string3);
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT ");
        stringBuilder.append("PACKAGES.NAME AS PROCEDURE_CAT,");
        stringBuilder.append("SCHEMAS.NAME AS PROCEDURE_SCHEM,");
        stringBuilder.append("PKGPROCS.MTDNAME AS PROCEDURE_NAME,");
        stringBuilder.append("'RESERVED1' AS RESERVED1,'RESERVED2' AS RESERVED2,'RESERVED3' AS RESERVED3, NULL AS REMARKS, CASE PKGPROCS.IS_PROC WHEN 'Y' THEN 1 ELSE  2 END AS PROCEDURE_TYPE");
        stringBuilder.append(" FROM ");
        stringBuilder.append(DmdbDatabaseMetaData.schemaClause(string, "SCHEMAS,"));
        stringBuilder.append(DmdbDatabaseMetaData.pkgClause(string2, "PACKAGES,"));
        stringBuilder.append(DmdbDatabaseMetaData.pkgprocClause(string2, string3, n2, "PKGPROCS"));
        stringBuilder.append(" WHERE PKGPROCS.PKGID = PACKAGES.ID AND PACKAGES.SCHID = SCHEMAS.ID");
        stringBuilder.append(" ORDER BY PROCEDURE_SCHEM ASC, PROCEDURE_CAT ASC, PROCEDURE_NAME ASC;");
        String string4 = "/*+ gateway metadata JDBC_getPkgProcedures(" + DmdbDatabaseMetaData.gatewayFormat(string) + "," + DmdbDatabaseMetaData.gatewayFormat(string2) + "," + DmdbDatabaseMetaData.gatewayFormat(string3) + "," + DmdbDatabaseMetaData.gatewayFormat(n2) + ")*/ ";
        return String.valueOf(string4) + stringBuilder.toString();
    }

    private static String schemaClause(String string, String string2) {
        String string3 = "(SELECT ID, PID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCH'";
        if (!DmdbDatabaseMetaData.getEscape(string)) {
            string3 = String.valueOf(string3) + " AND NAME = '" + string + "'";
        } else if (!string.equalsIgnoreCase("%")) {
            string3 = String.valueOf(string3) + " AND NAME LIKE '" + string + "' " + m_esp;
        }
        string3 = String.valueOf(string3) + ")" + string2;
        return string3;
    }

    private static String pkgClause(String string, String string2) {
        String string3 = "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'PKG'";
        if (!DmdbDatabaseMetaData.getEscape(string)) {
            string3 = String.valueOf(string3) + " AND NAME = '" + string + "'";
        } else if (!string.equalsIgnoreCase("%")) {
            string3 = String.valueOf(string3) + " AND NAME LIKE '" + string + "' " + m_esp;
        }
        string3 = String.valueOf(string3) + ")" + string2;
        return string3;
    }

    private static String pkgprocClause(String string, String string2, int n2, String string3) {
        String string4 = "(SELECT PKGID, MTDID, IS_PROC, MTDNAME FROM SYS.V$PKGPROCS ";
        if (!DmdbDatabaseMetaData.getEscape(string)) {
            string4 = String.valueOf(string4) + " WHERE PKGNAME = '" + string + "'";
        } else if (!string.equalsIgnoreCase("%")) {
            string4 = String.valueOf(string4) + " WHERE PKGNAME LIKE '" + string + "' " + m_esp;
        }
        if (!string2.equalsIgnoreCase("%")) {
            string4 = string.equalsIgnoreCase("%") ? String.valueOf(string4) + " WHERE" : String.valueOf(string4) + " AND";
            if (!DmdbDatabaseMetaData.getEscape(string2)) {
                string4 = String.valueOf(string4) + " MTDNAME = '" + string2 + "'";
            } else if (!string2.equalsIgnoreCase("%")) {
                string4 = String.valueOf(string4) + " MTDNAME LIKE '" + string2 + "' " + m_esp;
            }
        }
        if (n2 == 1 || n2 == 2) {
            string4 = string2.equalsIgnoreCase("%") ? String.valueOf(string4) + " WHERE" : String.valueOf(string4) + " AND";
            if (n2 == 1) {
                string4 = String.valueOf(string4) + " IS_PROC = 'Y'";
            } else if (n2 == 2) {
                string4 = String.valueOf(string4) + " IS_PROC = 'N'";
            }
        }
        string4 = String.valueOf(string4) + ")" + string3;
        return string4;
    }

    private static String argClause(String string, String string2) {
        String string3 = "(SELECT A.NAME AS NAME, A.ID AS ID,A.COLID AS COLID, CASE WHEN B.INFO1 IS NULL OR ((B.INFO1>>2) & 0x01)=0 THEN A.TYPE$ WHEN (B.INFO2 & 0xFF) = 0 THEN 'NUMBER' ELSE 'FLOAT' END AS TYPE$, CASE WHEN B.INFO1 IS NULL OR ((B.INFO1>>2) & 0x01)=0 THEN A.LENGTH$ ELSE (B.INFO2 & 0xFF) END AS LENGTH$,CASE WHEN B.INFO1 IS NULL OR ((B.INFO1>>2) & 0x01)=0 THEN A.SCALE WHEN (B.INFO2 & 0xFF) = 0 THEN 0 ELSE 129 END AS SCALE,A.NULLABLE$ AS NULLABLE$,A.DEFVAL AS DEFVAL,A.INFO1 AS INFO1,A.INFO2 AS INFO2 FROM SYS.SYSCOLUMNS A LEFT JOIN SYS.SYSCOLINFOS B ON A.ID = B.ID AND A.COLID = B.COLID ";
        if (!DmdbDatabaseMetaData.getEscape(string)) {
            string3 = String.valueOf(string3) + " WHERE NAME = '" + string + "'";
        } else if (!string.equalsIgnoreCase("%")) {
            string3 = String.valueOf(string3) + " WHERE NAME LIKE '" + string + "' " + m_esp;
        }
        string3 = String.valueOf(string3) + ")" + string2;
        return string3;
    }

    private static String pkgprocargClause(String string, String string2) {
        String string3 = "(SELECT *  FROM SYS.V$PKGPROCPARAMS";
        if (!DmdbDatabaseMetaData.getEscape(string)) {
            string3 = String.valueOf(string3) + " WHERE NAME = '" + string + "'";
        } else if (!string.equalsIgnoreCase("%")) {
            string3 = String.valueOf(string3) + " WHERE NAME LIKE '" + string + "' " + m_esp;
        }
        string3 = String.valueOf(string3) + ")" + string2;
        return string3;
    }

    private static String tableClause(String string, String[] stringArray, String string2) {
        String string3 = "(SELECT ID, SCHID, SUBTYPE$, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ IN ('UTAB', 'STAB', 'VIEW', 'SYNOM')";
        String string4 = DmdbDatabaseMetaData.makeTableTypeClause(stringArray);
        if (string4 != null) {
            string3 = String.valueOf(string3) + " AND" + string4;
        }
        if (!string.equalsIgnoreCase("%")) {
            string3 = !DmdbDatabaseMetaData.getEscape(string) ? String.valueOf(string3) + " AND NAME = '" + string + "'" : String.valueOf(string3) + " AND NAME LIKE '" + string + "' " + m_esp;
        }
        string3 = String.valueOf(string3) + ")" + string2;
        return string3;
    }

    private static String tableClause_tab(String string, String string2) {
        String string3 = "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ IN ('UTAB', 'STAB', 'VIEW')";
        if (!string.equalsIgnoreCase("%")) {
            string3 = !DmdbDatabaseMetaData.getEscape(string) ? String.valueOf(string3) + "AND NAME = '" + string + "'" : String.valueOf(string3) + "AND NAME LIKE '" + string + "' " + m_esp;
        }
        string3 = String.valueOf(string3) + ")" + string2;
        return string3;
    }

    private static String tableClause_utab(String string, String string2) {
        String string3 = "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'UTAB'";
        if (!string.equalsIgnoreCase("%")) {
            string3 = !DmdbDatabaseMetaData.getEscape(string) ? String.valueOf(string3) + "AND NAME = '" + string + "'" : String.valueOf(string3) + "AND NAME LIKE '" + string + "' " + m_esp;
        }
        string3 = String.valueOf(string3) + ")" + string2;
        return string3;
    }

    private static String procClause(String string, String string2, boolean bl) {
        String string3 = "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'PROC'";
        if (!DmdbDatabaseMetaData.getEscape(string)) {
            string3 = String.valueOf(string3) + " AND NAME = '" + string + "'";
        } else if (!string.equalsIgnoreCase("%")) {
            string3 = String.valueOf(string3) + " AND NAME LIKE '" + string + "'" + m_esp;
        }
        string3 = String.valueOf(string3) + ")" + string2;
        return string3;
    }

    private static String funcClause(String string, String string2) {
        String string3 = "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'PROC'";
        if (!DmdbDatabaseMetaData.getEscape(string)) {
            string3 = String.valueOf(string3) + " AND NAME = '" + string + "'";
        } else if (!string.equalsIgnoreCase("%")) {
            string3 = String.valueOf(string3) + " AND NAME LIKE '" + string + "'" + m_esp;
        }
        string3 = String.valueOf(string3) + " AND INFO1&0X01 = 0";
        string3 = String.valueOf(string3) + ")" + string2;
        return string3;
    }

    private static boolean getEscape(String string) {
        int n2 = string.length();
        boolean bl = false;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            if (string.charAt(n3) == '%' || string.charAt(n3) == '_') {
                bl = true;
            }
            --n3;
        }
        return bl;
    }

    private static String gatewayFormat(Object object) {
        if (object == null) {
            return "null";
        }
        String string = "";
        string = object instanceof String ? (String)object : (object instanceof Boolean ? ((Boolean)object != false ? "1" : "0") : (object instanceof String[] ? Arrays.toString((String[])object) : object.toString()));
        return "'" + string + "'";
    }
}

