import { useEffect } from "react";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
export function useFocusableElement(ref, id, before) {
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const shouldFocus = useDmnEditorStore((s) => s.focus.consumableId === id);
    useEffect(() => {
        var _a;
        if (!id) {
            return;
        }
        const cb = () => {
            var _a;
            (_a = ref.current) === null || _a === void 0 ? void 0 : _a.select();
            dmnEditorStoreApi.setState((state) => {
                state.focus.consumableId = undefined;
            });
        };
        if (shouldFocus && ref.current) {
            (_a = before === null || before === void 0 ? void 0 : before(cb)) !== null && _a !== void 0 ? _a : cb();
        }
    }, [before, dmnEditorStoreApi, id, ref, shouldFocus]);
}
//# sourceMappingURL=useFocusableElement.js.map