"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultVsCodeKieEditorChannelApiImpl = void 0;
var paths_1 = require("./paths/paths");
var __path = require("path");
var vscode = require("vscode");
var workspaceRoot_1 = require("./workspace/workspaceRoot");
var DefaultVsCodeKieEditorChannelApiImpl = (function () {
    function DefaultVsCodeKieEditorChannelApiImpl(editor, resourceContentService, vscodeWorkspace, vscodeNotifications, javaCodeCompletionApi, viewType, i18n) {
        this.editor = editor;
        this.resourceContentService = resourceContentService;
        this.vscodeWorkspace = vscodeWorkspace;
        this.vscodeNotifications = vscodeNotifications;
        this.javaCodeCompletionApi = javaCodeCompletionApi;
        this.viewType = viewType;
        this.i18n = i18n;
    }
    DefaultVsCodeKieEditorChannelApiImpl.prototype.kogitoWorkspace_newEdit = function (workspaceEdit) {
        return __awaiter(this, void 0, void 0, function () {
            var changeDocumentSubscription_1, content, edit;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (this.editor.document.type === "custom") {
                            this.editor.document.document.notifyEdit(this.editor, workspaceEdit);
                            return [2];
                        }
                        if (!(this.editor.document.type === "text")) return [3, 2];
                        this.editor.stopListeningToDocumentChanges();
                        changeDocumentSubscription_1 = vscode.workspace.onDidChangeTextDocument(function (e) { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                if (e.contentChanges.length <= 0) {
                                    return [2];
                                }
                                this.editor.startListeningToDocumentChanges();
                                changeDocumentSubscription_1.dispose();
                                return [2];
                            });
                        }); });
                        return [4, this.editor.envelopeServer.envelopeApi.requests.kogitoEditor_contentRequest()];
                    case 1:
                        content = (_a.sent()).content;
                        edit = new vscode.WorkspaceEdit();
                        edit.replace(this.editor.document.document.uri, new vscode.Range(0, 0, this.editor.document.document.lineCount, 0), content);
                        vscode.workspace.applyEdit(edit);
                        return [2];
                    case 2: throw new Error("Document type not supported");
                }
            });
        });
    };
    DefaultVsCodeKieEditorChannelApiImpl.prototype.kogitoWorkspace_openFile = function (normalizedPosixPathRelativeToTheWorkspaceRoot) {
        if (__path.isAbsolute(normalizedPosixPathRelativeToTheWorkspaceRoot)) {
            throw new Error("VS CODE DEFAULT CHANNEL API IMPL: Can't open absolute path. Paths must be relative to the workspace root.");
        }
        this.vscodeWorkspace.openFile(__path.join((0, workspaceRoot_1.getWorkspaceRoot)(this.editor.document.document).workspaceRootAbsoluteFsPath, (0, paths_1.toFsPath)(normalizedPosixPathRelativeToTheWorkspaceRoot)));
    };
    DefaultVsCodeKieEditorChannelApiImpl.prototype.kogitoEditor_contentRequest = function () {
        return __awaiter(this, void 0, void 0, function () {
            var normalizedPosixPathRelativeToTheWorkspaceRoot, content, e_1, error_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        normalizedPosixPathRelativeToTheWorkspaceRoot = (0, workspaceRoot_1.getNormalizedPosixPathRelativeToWorkspaceRoot)(this.editor.document.document);
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 8]);
                        return [4, this.editor.getDocumentContent()];
                    case 2:
                        content = _a.sent();
                        return [3, 8];
                    case 3:
                        e_1 = _a.sent();
                        _a.label = 4;
                    case 4:
                        _a.trys.push([4, 6, , 7]);
                        return [4, vscode.workspace.fs.writeFile(this.editor.document.document.uri, new Uint8Array())];
                    case 5:
                        _a.sent();
                        return [2, { content: "", normalizedPosixPathRelativeToTheWorkspaceRoot: normalizedPosixPathRelativeToTheWorkspaceRoot }];
                    case 6:
                        error_1 = _a.sent();
                        console.error("Failed on vscode.workspace.fs.writeFile. document uri: ", this.editor.document.document.uri, "error: ", error_1);
                        throw error_1;
                    case 7: return [3, 8];
                    case 8: return [2, {
                            content: content,
                            normalizedPosixPathRelativeToTheWorkspaceRoot: normalizedPosixPathRelativeToTheWorkspaceRoot,
                        }];
                }
            });
        });
    };
    DefaultVsCodeKieEditorChannelApiImpl.prototype.kogitoEditor_setContentError = function (editorContent) {
        var _this = this;
        var i18n = this.i18n.getCurrent();
        vscode.window
            .showErrorMessage(i18n.errorOpeningFileText(this.editor.document.document.uri.fsPath.split("/").pop()), i18n.openAsTextButton)
            .then(function (s1) {
            if (s1 !== i18n.openAsTextButton) {
                return;
            }
            _this.editor.close();
            vscode.commands.executeCommand("vscode.openWith", _this.editor.document.document.uri, "default");
            vscode.window.showInformationMessage(i18n.reopenAsDiagramText, i18n.reopenAsDiagramButton).then(function (s2) {
                if (s2 !== i18n.reopenAsDiagramButton) {
                    return;
                }
                vscode.window
                    .showTextDocument(_this.editor.document.document.uri)
                    .then(function (editor) { return editor.document.save(); })
                    .then(function () { return vscode.commands.executeCommand("workbench.action.closeActiveEditor"); })
                    .then(function () {
                    return vscode.commands.executeCommand("vscode.openWith", _this.editor.document.document.uri, _this.viewType);
                });
            });
        });
    };
    DefaultVsCodeKieEditorChannelApiImpl.prototype.kogitoEditor_ready = function () {
    };
    DefaultVsCodeKieEditorChannelApiImpl.prototype.kogitoEditor_theme = function () {
        return { defaultValue: this.editor.getCurrentTheme() };
    };
    DefaultVsCodeKieEditorChannelApiImpl.prototype.kogitoEditor_stateControlCommandUpdate = function (command) {
    };
    DefaultVsCodeKieEditorChannelApiImpl.prototype.kogitoWorkspace_resourceContentRequest = function (request) {
        return this.resourceContentService.get(request.normalizedPosixPathRelativeToTheWorkspaceRoot, request.opts);
    };
    DefaultVsCodeKieEditorChannelApiImpl.prototype.kogitoWorkspace_resourceListRequest = function (request) {
        return this.resourceContentService.list(request.pattern, request.opts);
    };
    DefaultVsCodeKieEditorChannelApiImpl.prototype.kogitoI18n_getLocale = function () {
        return Promise.resolve(vscode.env.language);
    };
    DefaultVsCodeKieEditorChannelApiImpl.prototype.kogitoNotifications_createNotification = function (notification) {
        this.vscodeNotifications.createNotification(this.editor.document.document, notification);
    };
    DefaultVsCodeKieEditorChannelApiImpl.prototype.kogitoNotifications_setNotifications = function (normalizedPosixPathRelativeToTheWorkspaceRoot, notifications) {
        this.vscodeNotifications.setNotifications(this.editor.document.document, normalizedPosixPathRelativeToTheWorkspaceRoot, notifications);
    };
    DefaultVsCodeKieEditorChannelApiImpl.prototype.kogitoNotifications_removeNotifications = function (normalizedPosixPathRelativeToTheWorkspaceRoot) {
        this.vscodeNotifications.removeNotifications(this.editor.document.document, normalizedPosixPathRelativeToTheWorkspaceRoot);
    };
    DefaultVsCodeKieEditorChannelApiImpl.prototype.kogitoJavaCodeCompletion__getAccessors = function (fqcn, query) {
        return this.javaCodeCompletionApi.getAccessors(fqcn, query);
    };
    DefaultVsCodeKieEditorChannelApiImpl.prototype.kogitoJavaCodeCompletion__getClasses = function (query) {
        return this.javaCodeCompletionApi.getClasses(query);
    };
    DefaultVsCodeKieEditorChannelApiImpl.prototype.kogitoJavaCodeCompletion__isLanguageServerAvailable = function () {
        return this.javaCodeCompletionApi.isLanguageServerAvailable();
    };
    return DefaultVsCodeKieEditorChannelApiImpl;
}());
exports.DefaultVsCodeKieEditorChannelApiImpl = DefaultVsCodeKieEditorChannelApiImpl;
//# sourceMappingURL=DefaultVsCodeKieEditorChannelApiImpl.js.map