"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeRecommendation = void 0;
var vscode = require("vscode");
var VsCodeRecommendation = (function () {
    function VsCodeRecommendation() {
    }
    VsCodeRecommendation.showExtendedServicesRecommendation = function (context) {
        var message = "There is another extension available that might help you.\n" +
            "Click [here](command:vscode-extension.installExtendedServices) to install it.";
        var action = "Install Apache KIE™ Extended Services for VS Code";
        var disposable = vscode.commands.registerCommand("vscode-extension.installExtendedServices", function () {
            vscode.env.openExternal(vscode.Uri.parse("vscode:extension/kie-group.extended-services-vscode-extension"));
        });
        vscode.window.showInformationMessage(message, action).then(function (selection) {
            if (selection === action) {
                vscode.commands.executeCommand("vscode-extension.installExtendedServices");
            }
        });
        context.subscriptions.push(disposable);
    };
    return VsCodeRecommendation;
}());
exports.VsCodeRecommendation = VsCodeRecommendation;
//# sourceMappingURL=VsCodeRecommendation.js.map