import { SideBarView, WebView } from "vscode-extension-tester";
export declare class VSCodeTestHelper {
    private workbench;
    private browser;
    private driver;
    private workspaceSectionView;
    private sidebarView;
    private readonly EDITOR_LOADING_TIMEOUT;
    constructor();
    openFolder: (absoluteFsPath: string) => Promise<SideBarView>;
    openFileFromSidebar: (fileName: string, fileParentPath?: string) => Promise<WebView[]>;
    private openEditorWithOneWebView;
    private openEditorWithTwoWebViews;
    private openNonKieEditorFile;
    private openItemFromSidebar;
    private forceOpeningDashbuilderEditor;
    private waitUntilFolderStructureIsExpanded;
    renameFile: (fileName: string, newFileName: string) => Promise<void>;
    closeAllEditors: () => Promise<void>;
    closeAllNotifications: () => Promise<void>;
    waitUntilKogitoEditorIsLoaded: (webview: WebView) => Promise<void>;
    executeCommandFromPrompt: (command: string) => Promise<void>;
    takeScreenshotOnTestFailure: (testMochaContext: Mocha.Context, parentScreenshotFolder: string) => Promise<void>;
    private takeScreenshotAndSave;
    saveFileInTextEditor: () => Promise<void>;
    setVSCodeSettings: (...settings: {
        settingValue: string;
        settingName: string;
        settingCategories?: string[];
    }[]) => Promise<(string | boolean)[]>;
}
export declare function switchWebviewToFrame(webview: WebView): Promise<void>;
export declare function switchBack(webview: WebView): Promise<void>;
export declare function sleep(ms: number): Promise<unknown>;
//# sourceMappingURL=VSCodeTestHelper.d.ts.map