export const EMPTY_KUBERNETES_CONNECTION = {
    namespace: "",
    host: "",
    token: "",
    insecurelyDisableTlsCertificateValidation: false,
};
export var KubernetesConnectionStatus;
(function (KubernetesConnectionStatus) {
    KubernetesConnectionStatus["CONNECTED"] = "CONNECTED";
    KubernetesConnectionStatus["ERROR"] = "ERROR";
    KubernetesConnectionStatus["MISSING_PERMISSIONS"] = "MISSING_PERMISSIONS";
    KubernetesConnectionStatus["NAMESPACE_NOT_FOUND"] = "NAMESPACE_NOT_FOUND";
})(KubernetesConnectionStatus || (KubernetesConnectionStatus = {}));
export const isKubernetesConnectionValid = (connection) => isNamespaceValid(connection.namespace) && isHostValid(connection.host) && isTokenValid(connection.token);
export const isNamespaceValid = (namespace) => namespace.trim().length > 0;
export const isTokenValid = (token) => token.trim().length > 0;
export const isHostValid = (host) => {
    if (host.trim().length === 0) {
        return false;
    }
    try {
        new URL(host);
        return true;
    }
    catch (_) {
        return false;
    }
};
//# sourceMappingURL=KubernetesConnection.js.map