"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var lib_1 = require("./lib");
var console_logs_1 = require("./console_logs");
var path = require("path");
var fs = require("fs");
var os = require("os");
var special_print_cases_1 = require("./special_print_cases");
var static_print_cases_1 = require("./static_print_cases");
var opt = process.argv[2];
var flag = process.argv[3];
function main() {
    return __awaiter(this, void 0, void 0, function () {
        var _a, env, vars, self, propertyPath, envPropertyValue, _b, _c, p, isBoolean;
        var e_1, _d;
        return __generator(this, function (_e) {
            switch (_e.label) {
                case 0:
                    (0, static_print_cases_1.treatStaticPrintCases)({ opt: opt });
                    return [4, (0, lib_1.findEnv)(path.resolve("."), path.resolve("."))];
                case 1:
                    _a = _e.sent(), env = _a.env, vars = _a.vars, self = _a.self;
                    (0, special_print_cases_1.treatSpecialPrintCases)({ opt: opt, env: env, vars: vars, self: self });
                    propertyPath = opt;
                    if (!propertyPath) {
                        console.error(console_logs_1.LOGS.error.pleaseProvideEnvPropertyPath());
                        console.error(console_logs_1.LOGS.info.seeAllEnvProperties());
                        throw new Error("[build-env] property-path-not-provided-error");
                    }
                    envPropertyValue = env;
                    try {
                        for (_b = __values(propertyPath.split(".")), _c = _b.next(); !_c.done; _c = _b.next()) {
                            p = _c.value;
                            envPropertyValue = envPropertyValue[p];
                            if (envPropertyValue === undefined) {
                                console.error(console_logs_1.LOGS.error.propertyNotFound({ propertyPath: propertyPath }));
                                console.error(console_logs_1.LOGS.info.seeAllEnvProperties());
                                throw new Error("[build-env] property-not-found-error");
                            }
                        }
                    }
                    catch (e_1_1) { e_1 = { error: e_1_1 }; }
                    finally {
                        try {
                            if (_c && !_c.done && (_d = _b.return)) _d.call(_b);
                        }
                        finally { if (e_1) throw e_1.error; }
                    }
                    if (typeof envPropertyValue !== "string" &&
                        typeof envPropertyValue !== "boolean" &&
                        typeof envPropertyValue !== "number") {
                        console.error(console_logs_1.LOGS.error.cantReturnNonString({ propertyPath: propertyPath, propertyType: typeof envPropertyValue }));
                        console.error(envPropertyValue);
                        throw new Error("[build-env] cant-return-non-string-error");
                    }
                    if (flag === "--not") {
                        isBoolean = "".concat(envPropertyValue) === "true" || "".concat(envPropertyValue) === "false";
                        if (!isBoolean) {
                            console.error(console_logs_1.LOGS.error.cantNegateNonBoolean({ envPropertyValue: envPropertyValue }));
                            throw new Error("[build-env] cant-negate-non-boolean-error");
                        }
                        console.log(!("".concat(envPropertyValue) === "true"));
                    }
                    else {
                        console.log(envPropertyValue);
                    }
                    return [2];
            }
        });
    });
}
main().catch(function (e) {
    var suppliedLogFilePath = process.env[lib_1.ERROR_ACCESS_LOG_FILE_ABSOLUTE_PATH_ENV_VAR_NAME];
    var defaultLogFilePath = path.join(os.tmpdir(), "build-env-access-errors.log");
    var logFilePath;
    if (!suppliedLogFilePath) {
        logFilePath = defaultLogFilePath;
        console.error(console_logs_1.LOGS.warn.defaultingAccessErrorsLogFileToTmpDirBecauseNotSupplied({ logFilePath: logFilePath }));
    }
    else if (!path.isAbsolute(suppliedLogFilePath)) {
        logFilePath = defaultLogFilePath;
        console.error(console_logs_1.LOGS.warn.defaultingAccessErrorsLogFileToTmpDirBecauseNotSupplied({ logFilePath: logFilePath }));
    }
    else {
        logFilePath = suppliedLogFilePath;
        console.error(console_logs_1.LOGS.error.usingConfiguredAccessErrorLogFile({ logFilePath: logFilePath }));
    }
    try {
        fs.appendFileSync(logFilePath, "".concat(e.message, " :: cwd:").concat(path.resolve("."), " opt:").concat(opt, " flag:").concat(flag, "\n"), "utf-8");
        console.error(console_logs_1.LOGS.info.wroteAccessErrorLog({ logFilePath: logFilePath }));
    }
    catch (e) {
        console.error(console_logs_1.LOGS.error.errorWritingAccessErrorLog({ logFilePath: logFilePath }));
        console.error(e);
        throw e;
    }
});
//# sourceMappingURL=bin.js.map