import { jsx as _jsx } from "react/jsx-runtime";
import React, { useCallback } from "react";
import { RefForwardingEmbeddedEnvelope } from "@kie-tools-core/envelope/dist/embedded";
import { ContainerType } from "@kie-tools-core/envelope/dist/api";
import { init } from "../envelope";
import { ProcessDetailsChannelApiImpl } from "./ProcessDetailsChannelApiImpl";
export const EmbeddedProcessDetails = React.forwardRef((props, forwardedRef) => {
    const refDelegate = useCallback((envelopeServer) => ({}), []);
    const pollInit = useCallback((envelopeServer, container) => {
        init({
            config: {
                containerType: ContainerType.DIV,
                envelopeId: envelopeServer.id,
            },
            container: container(),
            bus: {
                postMessage(message, targetOrigin, transfer) {
                    window.postMessage(message, targetOrigin, transfer);
                },
            },
        });
        return envelopeServer.envelopeApi.requests.processDetails__init({
            origin: envelopeServer.origin,
            envelopeServerId: envelopeServer.id,
        }, {
            processInstance: props.processInstance,
            omittedProcessTimelineEvents: props.omittedProcessTimelineEvents,
            diagramPreviewSize: props.diagramPreviewSize,
            singularProcessLabel: props.singularProcessLabel,
            pluralProcessLabel: props.pluralProcessLabel,
        });
    }, []);
    return (_jsx(EmbeddedProcessDetailsEnvelope, { ref: forwardedRef, apiImpl: new ProcessDetailsChannelApiImpl(props.driver), origin: props.targetOrigin, refDelegate: refDelegate, pollInit: pollInit, config: { containerType: ContainerType.DIV } }));
});
const EmbeddedProcessDetailsEnvelope = React.forwardRef(RefForwardingEmbeddedEnvelope);
//# sourceMappingURL=EmbeddedProcessDetails.js.map