import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import React, { useCallback, useEffect, useMemo, useState } from "react";
import { ToolbarFilter, ToolbarGroup, ToolbarItem, ToolbarToggleGroup, Toolbar, ToolbarContent, } from "@patternfly/react-core/dist/js/components/Toolbar";
import { Select, SelectOption, SelectVariant, } from "@patternfly/react-core/dist/js/components/Select";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { InputGroup } from "@patternfly/react-core/dist/js/components/InputGroup";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { FilterIcon } from "@patternfly/react-icons/dist/js/icons/filter-icon";
import { SyncIcon } from "@patternfly/react-icons/dist/js/icons/sync-icon";
import _ from "lodash";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools/OuiaUtils";
var Category;
(function (Category) {
    Category["STATUS"] = "Status";
    Category["TASK_NAME"] = "Task name";
})(Category || (Category = {}));
const TaskInboxToolbar = ({ activeFilter, allTaskStates, activeTaskStates, applyFilter, refresh, ouiaSafe, ouiaId, }) => {
    const [isStatusExpanded, setStatusExpanded] = useState(false);
    const [allStates, setAllStates] = useState([]);
    const [activeStates, setActiveStates] = useState([]);
    const [filterTaskStates, setFilterTaskStates] = useState([]);
    const [filterTaskNames, setFilterTaskNames] = useState([]);
    const [selectedTaskStates, setSelectedTaskStates] = useState([]);
    const [taskNameInput, setTaskNameInput] = useState("");
    useEffect(() => {
        setAllStates(allTaskStates);
        setActiveStates(activeTaskStates);
        setSelectedTaskStates(activeFilter.taskStates);
        setFilterTaskStates(activeFilter.taskStates);
        setFilterTaskNames(activeFilter.taskNames);
    }, [activeFilter, activeTaskStates, allTaskStates]);
    const createStatusMenuItems = useCallback(() => {
        return allStates.map((state) => _jsx(SelectOption, { value: state }, state));
    }, [allStates]);
    const doResetFilter = useCallback(async () => {
        await applyFilter({
            taskStates: activeStates,
            taskNames: [],
        });
    }, [activeStates, applyFilter]);
    const onDeleteFilterGroup = useCallback(async (categoryName, value) => {
        const newFilterTaskStates = [...filterTaskStates];
        const newFilterTaskNames = [...filterTaskNames];
        switch (categoryName) {
            case Category.STATUS:
                _.remove(newFilterTaskStates, (status) => {
                    return status === value;
                });
                setFilterTaskStates(newFilterTaskStates);
                setSelectedTaskStates(newFilterTaskStates);
                break;
            case Category.TASK_NAME:
                _.remove(newFilterTaskNames, (status) => {
                    return status === value;
                });
                setFilterTaskNames(newFilterTaskNames);
                break;
        }
        await applyFilter({
            taskNames: newFilterTaskNames,
            taskStates: newFilterTaskStates,
        });
    }, [applyFilter, filterTaskNames, filterTaskStates]);
    const onSelectTaskState = useCallback((event, selection) => {
        const filter = [...selectedTaskStates];
        if (!filter.includes(selection.toString())) {
            filter.push(selection.toString());
        }
        else {
            _.remove(filter, (status) => {
                return status === selection;
            });
        }
        setSelectedTaskStates(filter);
    }, [selectedTaskStates]);
    const doApplyFilter = useCallback(async () => {
        const newTaskNames = [...filterTaskNames];
        if (taskNameInput && !newTaskNames.includes(taskNameInput)) {
            newTaskNames.push(taskNameInput);
            setFilterTaskNames(newTaskNames);
        }
        setFilterTaskStates([...selectedTaskStates]);
        setTaskNameInput("");
        applyFilter({
            taskStates: [...selectedTaskStates],
            taskNames: newTaskNames,
        });
    }, [applyFilter, filterTaskNames, selectedTaskStates, taskNameInput]);
    const toggleGroupItems = useMemo(() => (_jsx(React.Fragment, { children: _jsxs(ToolbarGroup, { variant: "filter-group", children: [_jsx(ToolbarFilter, { chips: filterTaskStates, deleteChip: onDeleteFilterGroup, categoryName: Category.STATUS, children: _jsx(Select, { variant: SelectVariant.checkbox, "aria-label": "Status", onToggle: setStatusExpanded, onSelect: onSelectTaskState, selections: selectedTaskStates, isOpen: isStatusExpanded, placeholderText: "Status", children: createStatusMenuItems() }) }), _jsx(ToolbarFilter, { chips: filterTaskNames, deleteChip: onDeleteFilterGroup, categoryName: Category.TASK_NAME, children: _jsx(InputGroup, { children: _jsx(TextInput, { name: "taskName", id: "taskName", type: "search", "aria-label": "task name", onChange: setTaskNameInput, placeholder: "Filter by Task name", value: taskNameInput }) }) }), _jsx(ToolbarItem, { children: _jsx(Button, { id: "apply-filter", variant: "primary", onClick: doApplyFilter, isDisabled: _.isEmpty(selectedTaskStates) && _.isEmpty(taskNameInput), children: "Apply Filter" }) })] }) })), [
        createStatusMenuItems,
        doApplyFilter,
        filterTaskNames,
        filterTaskStates,
        isStatusExpanded,
        onDeleteFilterGroup,
        onSelectTaskState,
        selectedTaskStates,
        taskNameInput,
    ]);
    const toolbarItems = useMemo(() => (_jsxs(React.Fragment, { children: [_jsx(ToolbarToggleGroup, { toggleIcon: _jsx(FilterIcon, {}), breakpoint: "xl", children: toggleGroupItems }), _jsx(ToolbarGroup, { variant: "icon-button-group", children: _jsx(ToolbarItem, { children: _jsx(Tooltip, { content: "Refresh", children: _jsx(Button, { variant: "plain", onClick: refresh, id: "refresh", children: _jsx(SyncIcon, {}) }) }) }) })] })), [refresh, toggleGroupItems]);
    return (_jsx(Toolbar, { id: "tasks-with-filter", className: "pf-m-toggle-group-container", collapseListedFiltersBreakpoint: "xl", clearAllFilters: doResetFilter, clearFiltersButtonText: "Reset to default", ...componentOuiaProps(ouiaId, "tasks-toolbar", ouiaSafe), children: _jsx(ToolbarContent, { children: toolbarItems }) }));
};
export default TaskInboxToolbar;
//# sourceMappingURL=TaskInboxToolbar.js.map