import { TokenTree } from "./TokenTree";
import { CharStreams, Token } from "antlr4";
import FEEL_1_1Lexer from "./generated-parser/FEEL_1_1Lexer";
import { IdentifierSymbol } from "./IdentifierSymbol";
import { FeelSyntacticSymbolNature } from "../FeelSyntacticSymbolNature";
export class ScopeImpl {
    constructor(name, parentScope, type, allowDynamicVariables) {
        this.childScopes = new Map();
        this.symbols = new Map();
        this.name = name;
        this.parentScope = parentScope;
        this.type = type;
        this._allowDynamicVariables = allowDynamicVariables;
        if (parentScope) {
            parentScope.addChildScope(this);
        }
    }
    get allowDynamicVariables() {
        return this._allowDynamicVariables;
    }
    addChildScope(scope) {
        this.childScopes.set(scope.getName(), scope);
    }
    start(token) {
        var _a, _b;
        if (!this.tokenTree) {
            this.initializeTokenTree();
        }
        (_a = this.tokenTree) === null || _a === void 0 ? void 0 : _a.start(token);
        if (this.getParentScope()) {
            (_b = this.getParentScope()) === null || _b === void 0 ? void 0 : _b.start(token);
        }
    }
    define(symbol) {
        var _a, _b, _c;
        if (this.symbols.has((_a = symbol.getId()) !== null && _a !== void 0 ? _a : "")) {
            return false;
        }
        this.symbols.set((_b = symbol.getId()) !== null && _b !== void 0 ? _b : "", symbol);
        if (this.tokenTree) {
            this.tokenTree.addName(this.tokenize((_c = symbol.getId()) !== null && _c !== void 0 ? _c : ""));
        }
        return true;
    }
    tokenize(symbol) {
        const input = CharStreams.fromString(symbol);
        const lexer = new FEEL_1_1Lexer(input);
        const tokens = new Array();
        for (let token = lexer.nextToken(); token.type != Token.EOF; token = lexer.nextToken()) {
            tokens.push(token.text);
        }
        return tokens;
    }
    followUp(token, isPredict) {
        var _a, _b, _c;
        const parent = (_b = (this.getParentScope() && ((_a = this.getParentScope()) === null || _a === void 0 ? void 0 : _a.followUp(token, isPredict)))) !== null && _b !== void 0 ? _b : false;
        return ((_c = this.tokenTree) === null || _c === void 0 ? void 0 : _c.followUp(token, !isPredict)) || parent;
    }
    getChildScopes() {
        return this.childScopes;
    }
    getName() {
        var _a;
        return (_a = this.name) !== null && _a !== void 0 ? _a : "";
    }
    getParentScope() {
        return this.parentScope;
    }
    getSymbols() {
        return this.symbols;
    }
    getType() {
        return this.type;
    }
    resolve(parameter) {
        if (typeof parameter === "string") {
            if (this._allowDynamicVariables) {
                return new IdentifierSymbol(parameter, {
                    name: "name",
                    source: {
                        value: "name",
                        feelSyntacticSymbolNature: FeelSyntacticSymbolNature.DynamicVariable,
                        expressionsThatUseTheIdentifier: new Map(),
                    },
                }, FeelSyntacticSymbolNature.DynamicVariable);
            }
            return this.resolveId(parameter);
        }
        else {
            return this.resolveQualifiedName(parameter);
        }
    }
    resolveId(id) {
        const s = this.symbols.get(id);
        if (s == null && this.parentScope) {
            return this.parentScope.resolve(id);
        }
        return s;
    }
    resolveQualifiedName(qualifiedName) {
        var _a;
        const root = this.symbols.get(qualifiedName[0]);
        if (root == null && this.parentScope) {
            return this.parentScope.resolve(qualifiedName);
        }
        else if (root != null) {
            let currentSymbol = root;
            for (let i = 1; i < qualifiedName.length && currentSymbol; i++) {
                currentSymbol = (_a = currentSymbol.getScope()) === null || _a === void 0 ? void 0 : _a.resolve(qualifiedName[i]);
            }
            return currentSymbol;
        }
        return undefined;
    }
    initializeTokenTree() {
        this.tokenTree = this.tokenTreeFromSymbols(this.getSymbols());
    }
    tokenTreeFromSymbols(symbols) {
        const tt = new TokenTree();
        for (const symbol of symbols.keys()) {
            const tokens = this.tokenize(symbol);
            tt.addName(tokens);
        }
        return tt;
    }
}
//# sourceMappingURL=ScopeImpl.js.map