import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { EmptyState, EmptyStateIcon, EmptyStateVariant, EmptyStateBody, } from "@patternfly/react-core/dist/js/components/EmptyState";
import { PageSection } from "@patternfly/react-core/dist/js/components/Page";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { ExclamationCircleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-circle-icon";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
export const ServerUnavailablePage = ({ displayName, reload, ouiaId, ouiaSafe }) => {
    const name = displayName || process.env.KOGITO_APP_NAME;
    return (_jsx(PageSection, { variant: "light", ...componentOuiaProps(ouiaId, "server-unavailable", ouiaSafe), children: _jsx(Bullseye, { children: _jsxs(EmptyState, { variant: EmptyStateVariant.full, children: [_jsx(EmptyStateIcon, { icon: ExclamationCircleIcon, color: "var(--pf-global--danger-color--100)" }), _jsx(Title, { headingLevel: "h1", size: "4xl", children: "Error connecting server" }), _jsx(EmptyStateBody, { "data-testid": "empty-state-body", children: `The ${name} could not access the server to display content.` }), _jsx(EmptyStateBody, { "data-testid": "empty-state-body", children: "Try reloading the page, or contact your administrator for more information." }), _jsx(Button, { variant: "primary", onClick: reload, "data-testid": "refresh-button", children: "Refresh" })] }) }) }));
};
//# sourceMappingURL=ServerUnavailablePage.js.map