export const root = {
    element: "Definitions",
    type: "dmn3__tDefinitions"
};
export const ns = new Map([
    ["http://www.omg.org/spec/DMN/20130901", ""],
    ["", "http://www.omg.org/spec/DMN/20130901"],
]);
export const subs = {
    "": {
        "Context": "Expression",
        "FunctionDefinition": "Expression",
        "Relation": "Expression",
        "List": "Expression",
        "LiteralExpression": "Expression",
        "Invocation": "Expression",
        "DecisionTable": "Expression",
        "Decision": "DRGElement",
        "BusinessKnowledgeModel": "DRGElement",
        "InputData": "DRGElement",
        "KnowledgeSource": "DRGElement",
        "PerformanceIndicator": "BusinessContextElement",
        "OrganizationUnit": "BusinessContextElement",
    },
};
export const elements = {
    "Context": "dmn3__tContext",
    "FunctionDefinition": "dmn3__tFunctionDefinition",
    "Relation": "dmn3__tRelation",
    "List": "dmn3__tList",
    "DMNElement": "dmn3__tDMNElement",
    "Definitions": "dmn3__tDefinitions",
    "Import": "dmn3__tImport",
    "ElementCollection": "dmn3__tElementCollection",
    "DRGElement": "dmn3__tDRGElement",
    "Decision": "dmn3__tDecision",
    "BusinessContextElement": "dmn3__tBusinessContextElement",
    "PerformanceIndicator": "dmn3__tPerformanceIndicator",
    "OrganizationUnit": "dmn3__tOrganizationUnit",
    "BusinessKnowledgeModel": "dmn3__tBusinessKnowledgeModel",
    "InputData": "dmn3__tInputData",
    "KnowledgeSource": "dmn3__tKnowledgeSource",
    "Expression": "dmn3__tExpression",
    "ItemDefinition": "dmn3__tItemDefinition",
    "LiteralExpression": "dmn3__tLiteralExpression",
    "Invocation": "dmn3__tInvocation",
    "InformationItem": "dmn3__tInformationItem",
    "DecisionTable": "dmn3__tDecisionTable",
};
export const meta = {
    "dmn3__tContext": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "inputVariable": { type: "string", isArray: true, fromType: "dmn3__tExpression", xsdType: "xsd:IDREF" },
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false, fromType: "dmn3__tExpression", xsdType: "// local type" },
        "contextEntry": { type: "dmn3__tContextEntry", isArray: true, fromType: "dmn3__tContext", xsdType: "// local type" },
    },
    "dmn3__tContextEntry": {
        "InformationItem": { type: "dmn3__tInformationItem", isArray: false, fromType: "dmn3__tContextEntry", xsdType: "// local type" },
        "Expression": { type: "dmn3__tExpression", isArray: false, fromType: "dmn3__tContextEntry", xsdType: "// local type" },
    },
    "dmn3__tFunctionDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "inputVariable": { type: "string", isArray: true, fromType: "dmn3__tExpression", xsdType: "xsd:IDREF" },
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false, fromType: "dmn3__tExpression", xsdType: "// local type" },
        "InformationItem": { type: "dmn3__tInformationItem", isArray: true, fromType: "dmn3__tFunctionDefinition", xsdType: "// local type" },
        "Expression": { type: "dmn3__tExpression", isArray: false, fromType: "dmn3__tFunctionDefinition", xsdType: "// local type" },
    },
    "dmn3__tRelation": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "inputVariable": { type: "string", isArray: true, fromType: "dmn3__tExpression", xsdType: "xsd:IDREF" },
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false, fromType: "dmn3__tExpression", xsdType: "// local type" },
        "column": { type: "dmn3__tContextEntry", isArray: true, fromType: "dmn3__tRelation", xsdType: "// local type" },
        "List": { type: "dmn3__tList", isArray: true, fromType: "dmn3__tRelation", xsdType: "// local type" },
    },
    "dmn3__tList": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "inputVariable": { type: "string", isArray: true, fromType: "dmn3__tExpression", xsdType: "xsd:IDREF" },
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false, fromType: "dmn3__tExpression", xsdType: "// local type" },
        "Expression": { type: "dmn3__tExpression", isArray: true, fromType: "dmn3__tList", xsdType: "// local type" },
    },
    "dmn3__tDMNElement": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
    },
    "dmn3__tNamedDMNElement": {},
    "dmn3__tDMNElementReference": {
        "@_href": { type: "string", isArray: false, fromType: "dmn3__tDMNElementReference", xsdType: "xsd:anyURI" },
    },
    "dmn3__tDefinitions": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "dmn3__tDefinitions", xsdType: "xsd:anyURI" },
        "@_typeLanguage": { type: "string", isArray: false, fromType: "dmn3__tDefinitions", xsdType: "xsd:anyURI" },
        "@_namespace": { type: "string", isArray: false, fromType: "dmn3__tDefinitions", xsdType: "xsd:anyURI" },
        "Import": { type: "dmn3__tImport", isArray: true, fromType: "dmn3__tDefinitions", xsdType: "// local type" },
        "ItemDefinition": { type: "dmn3__tItemDefinition", isArray: true, fromType: "dmn3__tDefinitions", xsdType: "// local type" },
        "DRGElement": { type: "dmn3__tDRGElement", isArray: true, fromType: "dmn3__tDefinitions", xsdType: "// local type" },
        "ElementCollection": { type: "dmn3__tElementCollection", isArray: true, fromType: "dmn3__tDefinitions", xsdType: "// local type" },
        "BusinessContextElement": { type: "dmn3__tBusinessContextElement", isArray: true, fromType: "dmn3__tDefinitions", xsdType: "// local type" },
    },
    "dmn3__tImport": {
        "@_namespace": { type: "string", isArray: false, fromType: "dmn3__tImport", xsdType: "xsd:anyURI" },
        "@_locationURI": { type: "string", isArray: false, fromType: "dmn3__tImport", xsdType: "xsd:anyURI" },
        "@_importType": { type: "string", isArray: false, fromType: "dmn3__tImport", xsdType: "xsd:anyURI" },
    },
    "dmn3__tElementCollection": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "drgElement": { type: "dmn3__tDMNElementReference", isArray: true, fromType: "dmn3__tElementCollection", xsdType: "// local type" },
    },
    "dmn3__tDRGElement": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
    },
    "dmn3__tDecision": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "question": { type: "string", isArray: false, fromType: "dmn3__tDecision", xsdType: "xsd:string" },
        "allowedAnswers": { type: "string", isArray: false, fromType: "dmn3__tDecision", xsdType: "xsd:string" },
        "outputDefinition": { type: "dmn3__tDMNElementReference", isArray: false, fromType: "dmn3__tDecision", xsdType: "// local type" },
        "informationRequirement": { type: "dmn3__tInformationRequirement", isArray: true, fromType: "dmn3__tDecision", xsdType: "// local type" },
        "knowledgeRequirement": { type: "dmn3__tKnowledgeRequirement", isArray: true, fromType: "dmn3__tDecision", xsdType: "// local type" },
        "authorityRequirement": { type: "dmn3__tAuthorityRequirement", isArray: true, fromType: "dmn3__tDecision", xsdType: "// local type" },
        "supportedObjective": { type: "dmn3__tDMNElementReference", isArray: true, fromType: "dmn3__tDecision", xsdType: "// local type" },
        "impactedPerformanceIndicator": { type: "dmn3__tDMNElementReference", isArray: true, fromType: "dmn3__tDecision", xsdType: "// local type" },
        "decisionMaker": { type: "dmn3__tDMNElementReference", isArray: true, fromType: "dmn3__tDecision", xsdType: "// local type" },
        "decisionOwner": { type: "dmn3__tDMNElementReference", isArray: true, fromType: "dmn3__tDecision", xsdType: "// local type" },
        "usingProcess": { type: "dmn3__tDMNElementReference", isArray: true, fromType: "dmn3__tDecision", xsdType: "// local type" },
        "usingTask": { type: "dmn3__tDMNElementReference", isArray: true, fromType: "dmn3__tDecision", xsdType: "// local type" },
        "Expression": { type: "dmn3__tExpression", isArray: false, fromType: "dmn3__tDecision", xsdType: "// local type" },
    },
    "dmn3__tBusinessContextElement": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "@_URI": { type: "string", isArray: false, fromType: "dmn3__tBusinessContextElement", xsdType: "xsd:anyURI" },
    },
    "dmn3__tPerformanceIndicator": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "@_URI": { type: "string", isArray: false, fromType: "dmn3__tBusinessContextElement", xsdType: "xsd:anyURI" },
        "impactingDecision": { type: "dmn3__tDMNElementReference", isArray: true, fromType: "dmn3__tPerformanceIndicator", xsdType: "// local type" },
    },
    "dmn3__tOrganizationUnit": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "@_URI": { type: "string", isArray: false, fromType: "dmn3__tBusinessContextElement", xsdType: "xsd:anyURI" },
        "decisionMade": { type: "dmn3__tDMNElementReference", isArray: true, fromType: "dmn3__tOrganizationUnit", xsdType: "// local type" },
        "decisionOwned": { type: "dmn3__tDMNElementReference", isArray: true, fromType: "dmn3__tOrganizationUnit", xsdType: "// local type" },
    },
    "dmn3__tBusinessKnowledgeModel": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "InformationItem": { type: "dmn3__tInformationItem", isArray: true, fromType: "dmn3__tBusinessKnowledgeModel", xsdType: "// local type" },
        "Expression": { type: "dmn3__tExpression", isArray: false, fromType: "dmn3__tBusinessKnowledgeModel", xsdType: "// local type" },
        "knowledgeRequirement": { type: "dmn3__tKnowledgeRequirement", isArray: true, fromType: "dmn3__tBusinessKnowledgeModel", xsdType: "// local type" },
        "authorityRequirement": { type: "dmn3__tAuthorityRequirement", isArray: true, fromType: "dmn3__tBusinessKnowledgeModel", xsdType: "// local type" },
    },
    "dmn3__tInputData": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false, fromType: "dmn3__tInputData", xsdType: "// local type" },
    },
    "dmn3__tKnowledgeSource": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "@_locationURI": { type: "string", isArray: false, fromType: "dmn3__tKnowledgeSource", xsdType: "xsd:anyURI" },
        "authorityRequirement": { type: "dmn3__tAuthorityRequirement", isArray: true, fromType: "dmn3__tKnowledgeSource", xsdType: "// local type" },
        "type": { type: "string", isArray: false, fromType: "dmn3__tKnowledgeSource", xsdType: "xsd:antType" },
        "owner": { type: "dmn3__tDMNElementReference", isArray: false, fromType: "dmn3__tKnowledgeSource", xsdType: "// local type" },
    },
    "dmn3__tInformationRequirement": {
        "InformationItem": { type: "dmn3__tInformationItem", isArray: false, fromType: "dmn3__tInformationRequirement", xsdType: "// local type" },
    },
    "dmn3__tKnowledgeRequirement": {
        "requiredKnowledge": { type: "dmn3__tDMNElementReference", isArray: false, fromType: "dmn3__tKnowledgeRequirement", xsdType: "// local type" },
    },
    "dmn3__tAuthorityRequirement": {},
    "dmn3__tExpression": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "inputVariable": { type: "string", isArray: true, fromType: "dmn3__tExpression", xsdType: "xsd:IDREF" },
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false, fromType: "dmn3__tExpression", xsdType: "// local type" },
    },
    "dmn3__tItemDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "@_typeLanguage": { type: "string", isArray: false, fromType: "dmn3__tItemDefinition", xsdType: "xsd:anyURI" },
        "@_isCollection": { type: "boolean", isArray: false, fromType: "dmn3__tItemDefinition", xsdType: "xsd:boolean" },
        "itemComponent": { type: "dmn3__tItemComponent", isArray: true, fromType: "dmn3__tItemDefinition", xsdType: "// local type" },
        "allowedValue": { type: "dmn3__tExpression", isArray: true, fromType: "dmn3__tItemDefinition", xsdType: "// local type" },
    },
    "dmn3__tItemComponent": {
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tItemComponent", xsdType: "xsd:string" },
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false, fromType: "dmn3__tItemComponent", xsdType: "// local type" },
    },
    "dmn3__tLiteralExpression__text": {},
    "dmn3__tLiteralExpression": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "inputVariable": { type: "string", isArray: true, fromType: "dmn3__tExpression", xsdType: "xsd:IDREF" },
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false, fromType: "dmn3__tExpression", xsdType: "// local type" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "dmn3__tLiteralExpression", xsdType: "xsd:anyURI" },
        "text": { type: "dmn3__tLiteralExpression__text", isArray: false, fromType: "dmn3__tLiteralExpression", xsdType: "Anonymous type..." },
        "Import": { type: "dmn3__tImport", isArray: false, fromType: "dmn3__tLiteralExpression", xsdType: "// local type" },
    },
    "dmn3__tInvocation": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "inputVariable": { type: "string", isArray: true, fromType: "dmn3__tExpression", xsdType: "xsd:IDREF" },
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false, fromType: "dmn3__tExpression", xsdType: "// local type" },
        "binding": { type: "dmn3__tBinding", isArray: true, fromType: "dmn3__tInvocation", xsdType: "// local type" },
    },
    "dmn3__tBinding": {
        "Expression": { type: "dmn3__tExpression", isArray: false, fromType: "dmn3__tBinding", xsdType: "// local type" },
        "parameter": { type: "dmn3__tDMNElementReference", isArray: false, fromType: "dmn3__tBinding", xsdType: "// local type" },
    },
    "dmn3__tInformationItem": {
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false, fromType: "dmn3__tInformationItem", xsdType: "// local type" },
    },
    "dmn3__tDecisionTable": {
        "@_id": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn3__tDMNElement", xsdType: "xsd:string" },
        "inputVariable": { type: "string", isArray: true, fromType: "dmn3__tExpression", xsdType: "xsd:IDREF" },
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false, fromType: "dmn3__tExpression", xsdType: "// local type" },
        "@_hitPolicy": { type: "dmn3__HitPolicy", isArray: false, fromType: "dmn3__tDecisionTable", xsdType: "// local type" },
        "@_aggregation": { type: "dmn3__BuiltinAggregator", isArray: false, fromType: "dmn3__tDecisionTable", xsdType: "// local type" },
        "@_preferedOrientation": { type: "dmn3__DecisionTableOrientation", isArray: false, fromType: "dmn3__tDecisionTable", xsdType: "// local type" },
        "@_isComplete": { type: "boolean", isArray: false, fromType: "dmn3__tDecisionTable", xsdType: "xsd:boolean" },
        "@_isConsistent": { type: "boolean", isArray: false, fromType: "dmn3__tDecisionTable", xsdType: "xsd:boolean" },
        "clause": { type: "dmn3__tClause", isArray: true, fromType: "dmn3__tDecisionTable", xsdType: "// local type" },
        "rule": { type: "dmn3__tDecisionRule", isArray: true, fromType: "dmn3__tDecisionTable", xsdType: "// local type" },
    },
    "dmn3__tClause": {
        "@_name": { type: "string", isArray: false, fromType: "dmn3__tClause", xsdType: "xsd:string" },
        "@_isOrdered": { type: "boolean", isArray: false, fromType: "dmn3__tClause", xsdType: "xsd:boolean" },
    },
    "dmn3__tDecisionRule": {
        "condition": { type: "string", isArray: true, fromType: "dmn3__tDecisionRule", xsdType: "xsd:IDREFS" },
        "conclusion": { type: "string", isArray: true, fromType: "dmn3__tDecisionRule", xsdType: "xsd:IDREFS" },
    },
};
//# sourceMappingURL=meta.js.map