export const root = {
    element: "definitions",
    type: "DMN14__tDefinitions"
};
export const ns = new Map([
    ["https://www.omg.org/spec/DMN/20211108/MODEL/", ""],
    ["", "https://www.omg.org/spec/DMN/20211108/MODEL/"],
    ["https://www.omg.org/spec/DMN/20191111/DMNDI/", "dmndi:"],
    ["dmndi:", "https://www.omg.org/spec/DMN/20191111/DMNDI/"],
    ["http://www.omg.org/spec/DMN/20180521/DC/", "dc:"],
    ["dc:", "http://www.omg.org/spec/DMN/20180521/DC/"],
    ["http://www.omg.org/spec/DMN/20180521/DI/", "di:"],
    ["di:", "http://www.omg.org/spec/DMN/20180521/DI/"],
]);
export const subs = {
    "": {
        "namedElement": "DMNElement",
        "informationRequirement": "DMNElement",
        "knowledgeRequirement": "DMNElement",
        "authorityRequirement": "DMNElement",
        "functionItem": "DMNElement",
        "artifact": "DMNElement",
        "contextEntry": "DMNElement",
        "definitions": "namedElement",
        "import": "namedElement",
        "elementCollection": "namedElement",
        "drgElement": "namedElement",
        "itemDefinition": "namedElement",
        "informationItem": "namedElement",
        "decision": "drgElement",
        "invocable": "drgElement",
        "inputData": "drgElement",
        "knowledgeSource": "drgElement",
        "performanceIndicator": "businessContextElement",
        "organizationUnit": "businessContextElement",
        "businessKnowledgeModel": "invocable",
        "decisionService": "invocable",
        "literalExpression": "expression",
        "invocation": "expression",
        "decisionTable": "expression",
        "context": "expression",
        "functionDefinition": "expression",
        "relation": "expression",
        "list": "expression",
        "for": "expression",
        "every": "expression",
        "some": "expression",
        "conditional": "expression",
        "filter": "expression",
        "group": "artifact",
        "textAnnotation": "artifact",
        "association": "artifact",
    },
    "dmndi:": {
        "dmndi:DMNShape": "dmndi:DMNDiagramElement",
        "dmndi:DMNEdge": "dmndi:DMNDiagramElement",
        "dmndi:DMNStyle": "di:Style",
    },
    "dc:": {},
    "di:": {},
};
export const elements = {
    "DMNElement": "DMN14__tDMNElement",
    "namedElement": "DMN14__tNamedElement",
    "definitions": "DMN14__tDefinitions",
    "import": "DMN14__tImport",
    "elementCollection": "DMN14__tElementCollection",
    "drgElement": "DMN14__tDRGElement",
    "decision": "DMN14__tDecision",
    "businessContextElement": "DMN14__tBusinessContextElement",
    "performanceIndicator": "DMN14__tPerformanceIndicator",
    "organizationUnit": "DMN14__tOrganizationUnit",
    "invocable": "DMN14__tInvocable",
    "businessKnowledgeModel": "DMN14__tBusinessKnowledgeModel",
    "inputData": "DMN14__tInputData",
    "knowledgeSource": "DMN14__tKnowledgeSource",
    "informationRequirement": "DMN14__tInformationRequirement",
    "knowledgeRequirement": "DMN14__tKnowledgeRequirement",
    "authorityRequirement": "DMN14__tAuthorityRequirement",
    "expression": "DMN14__tExpression",
    "itemDefinition": "DMN14__tItemDefinition",
    "functionItem": "DMN14__tFunctionItem",
    "literalExpression": "DMN14__tLiteralExpression",
    "invocation": "DMN14__tInvocation",
    "informationItem": "DMN14__tInformationItem",
    "decisionTable": "DMN14__tDecisionTable",
    "artifact": "DMN14__tArtifact",
    "group": "DMN14__tGroup",
    "textAnnotation": "DMN14__tTextAnnotation",
    "association": "DMN14__tAssociation",
    "context": "DMN14__tContext",
    "contextEntry": "DMN14__tContextEntry",
    "functionDefinition": "DMN14__tFunctionDefinition",
    "relation": "DMN14__tRelation",
    "list": "DMN14__tList",
    "decisionService": "DMN14__tDecisionService",
    "for": "DMN14__tFor",
    "every": "DMN14__tQuantified",
    "some": "DMN14__tQuantified",
    "conditional": "DMN14__tConditional",
    "filter": "DMN14__tFilter",
    "dmndi:DMNDI": "DMNDI13__DMNDI",
    "dmndi:DMNDiagram": "DMNDI13__DMNDiagram",
    "dmndi:DMNDiagramElement": "DMNDI13__DiagramElement",
    "dmndi:DMNShape": "DMNDI13__DMNShape",
    "dmndi:DMNEdge": "DMNDI13__DMNEdge",
    "dmndi:DMNStyle": "DMNDI13__DMNStyle",
    "dmndi:DMNLabel": "DMNDI13__DMNLabel",
    "dmndi:DMNDecisionServiceDividerLine": "DMNDI13__DMNDecisionServiceDividerLine",
    "dc:Color": "DC__Color",
    "dc:Point": "DC__Point",
    "dc:Bounds": "DC__Bounds",
    "dc:Dimension": "DC__Dimension",
    "di:Style": "DI__Style",
};
export const meta = {
    "DMN14__tDMNElement__extensionElements": {},
    "DMN14__tDMNElement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tDMNElement__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonymous type..." },
    },
    "DMN14__tNamedElement__extensionElements": {},
    "DMN14__tNamedElement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tNamedElement__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tNamedElement", xsdType: "xsd:string" },
    },
    "DMN14__tDMNElementReference": {
        "@_href": { type: "string", isArray: false, fromType: "DMN14__tDMNElementReference", xsdType: "xsd:anyURI" },
    },
    "DMN14__tDefinitions__extensionElements": {},
    "DMN14__tDefinitions": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tDefinitions__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tNamedElement", xsdType: "xsd:string" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "DMN14__tDefinitions", xsdType: "xsd:anyURI" },
        "@_typeLanguage": { type: "string", isArray: false, fromType: "DMN14__tDefinitions", xsdType: "xsd:anyURI" },
        "@_namespace": { type: "string", isArray: false, fromType: "DMN14__tDefinitions", xsdType: "xsd:anyURI" },
        "@_exporter": { type: "string", isArray: false, fromType: "DMN14__tDefinitions", xsdType: "xsd:string" },
        "@_exporterVersion": { type: "string", isArray: false, fromType: "DMN14__tDefinitions", xsdType: "xsd:string" },
        "import": { type: "DMN14__tImport", isArray: true, fromType: "DMN14__tDefinitions", xsdType: "// local type" },
        "itemDefinition": { type: "DMN14__tItemDefinition", isArray: true, fromType: "DMN14__tDefinitions", xsdType: "// local type" },
        "drgElement": { type: "DMN14__tDRGElement", isArray: true, fromType: "DMN14__tDefinitions", xsdType: "// local type" },
        "artifact": { type: "DMN14__tArtifact", isArray: true, fromType: "DMN14__tDefinitions", xsdType: "// local type" },
        "elementCollection": { type: "DMN14__tElementCollection", isArray: true, fromType: "DMN14__tDefinitions", xsdType: "// local type" },
        "businessContextElement": { type: "DMN14__tBusinessContextElement", isArray: true, fromType: "DMN14__tDefinitions", xsdType: "// local type" },
        "dmndi:DMNDI": { type: "DMNDI13__DMNDI", isArray: false, fromType: "DMN14__tDefinitions", xsdType: "type found from namespace with declaration name 'dmndi'." },
    },
    "DMN14__tImport__extensionElements": {},
    "DMN14__tImport": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tImport__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tNamedElement", xsdType: "xsd:string" },
        "@_namespace": { type: "string", isArray: false, fromType: "DMN14__tImport", xsdType: "xsd:anyURI" },
        "@_locationURI": { type: "string", isArray: false, fromType: "DMN14__tImport", xsdType: "xsd:anyURI" },
        "@_importType": { type: "string", isArray: false, fromType: "DMN14__tImport", xsdType: "xsd:anyURI" },
    },
    "DMN14__tElementCollection__extensionElements": {},
    "DMN14__tElementCollection": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tElementCollection__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tNamedElement", xsdType: "xsd:string" },
        "drgElement": { type: "DMN14__tDMNElementReference", isArray: true, fromType: "DMN14__tElementCollection", xsdType: "// local type" },
    },
    "DMN14__tDRGElement__extensionElements": {},
    "DMN14__tDRGElement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tDRGElement__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tNamedElement", xsdType: "xsd:string" },
    },
    "DMN14__tDecision__extensionElements": {},
    "DMN14__tDecision": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tDecision__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tNamedElement", xsdType: "xsd:string" },
        "question": { type: "string", isArray: false, fromType: "DMN14__tDecision", xsdType: "xsd:string" },
        "allowedAnswers": { type: "string", isArray: false, fromType: "DMN14__tDecision", xsdType: "xsd:string" },
        "variable": { type: "DMN14__tInformationItem", isArray: false, fromType: "DMN14__tDecision", xsdType: "// local type" },
        "informationRequirement": { type: "DMN14__tInformationRequirement", isArray: true, fromType: "DMN14__tDecision", xsdType: "// local type" },
        "knowledgeRequirement": { type: "DMN14__tKnowledgeRequirement", isArray: true, fromType: "DMN14__tDecision", xsdType: "// local type" },
        "authorityRequirement": { type: "DMN14__tAuthorityRequirement", isArray: true, fromType: "DMN14__tDecision", xsdType: "// local type" },
        "supportedObjective": { type: "DMN14__tDMNElementReference", isArray: true, fromType: "DMN14__tDecision", xsdType: "// local type" },
        "impactedPerformanceIndicator": { type: "DMN14__tDMNElementReference", isArray: true, fromType: "DMN14__tDecision", xsdType: "// local type" },
        "decisionMaker": { type: "DMN14__tDMNElementReference", isArray: true, fromType: "DMN14__tDecision", xsdType: "// local type" },
        "decisionOwner": { type: "DMN14__tDMNElementReference", isArray: true, fromType: "DMN14__tDecision", xsdType: "// local type" },
        "usingProcess": { type: "DMN14__tDMNElementReference", isArray: true, fromType: "DMN14__tDecision", xsdType: "// local type" },
        "usingTask": { type: "DMN14__tDMNElementReference", isArray: true, fromType: "DMN14__tDecision", xsdType: "// local type" },
        "expression": { type: "DMN14__tExpression", isArray: false, fromType: "DMN14__tDecision", xsdType: "// local type" },
    },
    "DMN14__tBusinessContextElement__extensionElements": {},
    "DMN14__tBusinessContextElement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tBusinessContextElement__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tNamedElement", xsdType: "xsd:string" },
        "@_URI": { type: "string", isArray: false, fromType: "DMN14__tBusinessContextElement", xsdType: "xsd:anyURI" },
    },
    "DMN14__tPerformanceIndicator__extensionElements": {},
    "DMN14__tPerformanceIndicator": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tPerformanceIndicator__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tNamedElement", xsdType: "xsd:string" },
        "@_URI": { type: "string", isArray: false, fromType: "DMN14__tBusinessContextElement", xsdType: "xsd:anyURI" },
        "impactingDecision": { type: "DMN14__tDMNElementReference", isArray: true, fromType: "DMN14__tPerformanceIndicator", xsdType: "// local type" },
    },
    "DMN14__tOrganizationUnit__extensionElements": {},
    "DMN14__tOrganizationUnit": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tOrganizationUnit__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tNamedElement", xsdType: "xsd:string" },
        "@_URI": { type: "string", isArray: false, fromType: "DMN14__tBusinessContextElement", xsdType: "xsd:anyURI" },
        "decisionMade": { type: "DMN14__tDMNElementReference", isArray: true, fromType: "DMN14__tOrganizationUnit", xsdType: "// local type" },
        "decisionOwned": { type: "DMN14__tDMNElementReference", isArray: true, fromType: "DMN14__tOrganizationUnit", xsdType: "// local type" },
    },
    "DMN14__tInvocable__extensionElements": {},
    "DMN14__tInvocable": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tInvocable__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tNamedElement", xsdType: "xsd:string" },
        "variable": { type: "DMN14__tInformationItem", isArray: false, fromType: "DMN14__tInvocable", xsdType: "// local type" },
    },
    "DMN14__tBusinessKnowledgeModel__extensionElements": {},
    "DMN14__tBusinessKnowledgeModel": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tBusinessKnowledgeModel__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tNamedElement", xsdType: "xsd:string" },
        "variable": { type: "DMN14__tInformationItem", isArray: false, fromType: "DMN14__tInvocable", xsdType: "// local type" },
        "encapsulatedLogic": { type: "DMN14__tFunctionDefinition", isArray: false, fromType: "DMN14__tBusinessKnowledgeModel", xsdType: "// local type" },
        "knowledgeRequirement": { type: "DMN14__tKnowledgeRequirement", isArray: true, fromType: "DMN14__tBusinessKnowledgeModel", xsdType: "// local type" },
        "authorityRequirement": { type: "DMN14__tAuthorityRequirement", isArray: true, fromType: "DMN14__tBusinessKnowledgeModel", xsdType: "// local type" },
    },
    "DMN14__tInputData__extensionElements": {},
    "DMN14__tInputData": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tInputData__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tNamedElement", xsdType: "xsd:string" },
        "variable": { type: "DMN14__tInformationItem", isArray: false, fromType: "DMN14__tInputData", xsdType: "// local type" },
    },
    "DMN14__tKnowledgeSource__extensionElements": {},
    "DMN14__tKnowledgeSource": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tKnowledgeSource__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tNamedElement", xsdType: "xsd:string" },
        "@_locationURI": { type: "string", isArray: false, fromType: "DMN14__tKnowledgeSource", xsdType: "xsd:anyURI" },
        "authorityRequirement": { type: "DMN14__tAuthorityRequirement", isArray: true, fromType: "DMN14__tKnowledgeSource", xsdType: "// local type" },
        "type": { type: "string", isArray: false, fromType: "DMN14__tKnowledgeSource", xsdType: "xsd:string" },
        "owner": { type: "DMN14__tDMNElementReference", isArray: false, fromType: "DMN14__tKnowledgeSource", xsdType: "// local type" },
    },
    "DMN14__tInformationRequirement__extensionElements": {},
    "DMN14__tInformationRequirement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tInformationRequirement__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "requiredDecision": { type: "DMN14__tDMNElementReference", isArray: false, fromType: "DMN14__tInformationRequirement", xsdType: "// local type" },
        "requiredInput": { type: "DMN14__tDMNElementReference", isArray: false, fromType: "DMN14__tInformationRequirement", xsdType: "// local type" },
    },
    "DMN14__tKnowledgeRequirement__extensionElements": {},
    "DMN14__tKnowledgeRequirement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tKnowledgeRequirement__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "requiredKnowledge": { type: "DMN14__tDMNElementReference", isArray: false, fromType: "DMN14__tKnowledgeRequirement", xsdType: "// local type" },
    },
    "DMN14__tAuthorityRequirement__extensionElements": {},
    "DMN14__tAuthorityRequirement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tAuthorityRequirement__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "requiredDecision": { type: "DMN14__tDMNElementReference", isArray: false, fromType: "DMN14__tAuthorityRequirement", xsdType: "// local type" },
        "requiredInput": { type: "DMN14__tDMNElementReference", isArray: false, fromType: "DMN14__tAuthorityRequirement", xsdType: "// local type" },
        "requiredAuthority": { type: "DMN14__tDMNElementReference", isArray: false, fromType: "DMN14__tAuthorityRequirement", xsdType: "// local type" },
    },
    "DMN14__tExpression__extensionElements": {},
    "DMN14__tExpression": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tExpression__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN14__tExpression", xsdType: "xsd:string" },
    },
    "DMN14__tItemDefinition__extensionElements": {},
    "DMN14__tItemDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tItemDefinition__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tNamedElement", xsdType: "xsd:string" },
        "@_typeLanguage": { type: "string", isArray: false, fromType: "DMN14__tItemDefinition", xsdType: "xsd:anyURI" },
        "@_isCollection": { type: "boolean", isArray: false, fromType: "DMN14__tItemDefinition", xsdType: "xsd:boolean" },
        "itemComponent": { type: "DMN14__tItemDefinition", isArray: true, fromType: "DMN14__tItemDefinition", xsdType: "// local type" },
        "functionItem": { type: "DMN14__tFunctionItem", isArray: false, fromType: "DMN14__tItemDefinition", xsdType: "// local type" },
        "typeRef": { type: "string", isArray: false, fromType: "DMN14__tItemDefinition", xsdType: "xsd:string" },
        "allowedValues": { type: "DMN14__tUnaryTests", isArray: false, fromType: "DMN14__tItemDefinition", xsdType: "// local type" },
    },
    "DMN14__tFunctionItem__extensionElements": {},
    "DMN14__tFunctionItem": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tFunctionItem__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_outputTypeRef": { type: "string", isArray: false, fromType: "DMN14__tFunctionItem", xsdType: "xsd:string" },
        "parameters": { type: "DMN14__tInformationItem", isArray: true, fromType: "DMN14__tFunctionItem", xsdType: "// local type" },
    },
    "DMN14__tLiteralExpression__extensionElements": {},
    "DMN14__tLiteralExpression": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tLiteralExpression__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN14__tExpression", xsdType: "xsd:string" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "DMN14__tLiteralExpression", xsdType: "xsd:anyURI" },
        "text": { type: "string", isArray: false, fromType: "DMN14__tLiteralExpression", xsdType: "xsd:string" },
        "importedValues": { type: "DMN14__tImportedValues", isArray: false, fromType: "DMN14__tLiteralExpression", xsdType: "// local type" },
    },
    "DMN14__tInvocation__extensionElements": {},
    "DMN14__tInvocation": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tInvocation__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN14__tExpression", xsdType: "xsd:string" },
        "expression": { type: "DMN14__tExpression", isArray: false, fromType: "DMN14__tInvocation", xsdType: "// local type" },
        "binding": { type: "DMN14__tBinding", isArray: true, fromType: "DMN14__tInvocation", xsdType: "// local type" },
    },
    "DMN14__tBinding": {
        "parameter": { type: "DMN14__tInformationItem", isArray: false, fromType: "DMN14__tBinding", xsdType: "// local type" },
        "expression": { type: "DMN14__tExpression", isArray: false, fromType: "DMN14__tBinding", xsdType: "// local type" },
    },
    "DMN14__tInformationItem__extensionElements": {},
    "DMN14__tInformationItem": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tInformationItem__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tNamedElement", xsdType: "xsd:string" },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN14__tInformationItem", xsdType: "xsd:string" },
    },
    "DMN14__tDecisionTable__extensionElements": {},
    "DMN14__tDecisionTable": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tDecisionTable__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN14__tExpression", xsdType: "xsd:string" },
        "@_hitPolicy": { type: "DMN14__tHitPolicy", isArray: false, fromType: "DMN14__tDecisionTable", xsdType: "// local type" },
        "@_aggregation": { type: "DMN14__tBuiltinAggregator", isArray: false, fromType: "DMN14__tDecisionTable", xsdType: "// local type" },
        "@_preferredOrientation": { type: "DMN14__tDecisionTableOrientation", isArray: false, fromType: "DMN14__tDecisionTable", xsdType: "// local type" },
        "@_outputLabel": { type: "string", isArray: false, fromType: "DMN14__tDecisionTable", xsdType: "xsd:string" },
        "input": { type: "DMN14__tInputClause", isArray: true, fromType: "DMN14__tDecisionTable", xsdType: "// local type" },
        "output": { type: "DMN14__tOutputClause", isArray: true, fromType: "DMN14__tDecisionTable", xsdType: "// local type" },
        "annotation": { type: "DMN14__tRuleAnnotationClause", isArray: true, fromType: "DMN14__tDecisionTable", xsdType: "// local type" },
        "rule": { type: "DMN14__tDecisionRule", isArray: true, fromType: "DMN14__tDecisionTable", xsdType: "// local type" },
    },
    "DMN14__tInputClause__extensionElements": {},
    "DMN14__tInputClause": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tInputClause__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "inputExpression": { type: "DMN14__tLiteralExpression", isArray: false, fromType: "DMN14__tInputClause", xsdType: "// local type" },
        "inputValues": { type: "DMN14__tUnaryTests", isArray: false, fromType: "DMN14__tInputClause", xsdType: "// local type" },
    },
    "DMN14__tOutputClause__extensionElements": {},
    "DMN14__tOutputClause": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tOutputClause__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tOutputClause", xsdType: "xsd:string" },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN14__tOutputClause", xsdType: "xsd:string" },
        "outputValues": { type: "DMN14__tUnaryTests", isArray: false, fromType: "DMN14__tOutputClause", xsdType: "// local type" },
        "defaultOutputEntry": { type: "DMN14__tLiteralExpression", isArray: false, fromType: "DMN14__tOutputClause", xsdType: "// local type" },
    },
    "DMN14__tRuleAnnotationClause": {
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tRuleAnnotationClause", xsdType: "xsd:string" },
    },
    "DMN14__tDecisionRule__extensionElements": {},
    "DMN14__tDecisionRule": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tDecisionRule__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "inputEntry": { type: "DMN14__tUnaryTests", isArray: true, fromType: "DMN14__tDecisionRule", xsdType: "// local type" },
        "outputEntry": { type: "DMN14__tLiteralExpression", isArray: true, fromType: "DMN14__tDecisionRule", xsdType: "// local type" },
        "annotationEntry": { type: "DMN14__tRuleAnnotation", isArray: true, fromType: "DMN14__tDecisionRule", xsdType: "// local type" },
    },
    "DMN14__tRuleAnnotation": {
        "text": { type: "string", isArray: false, fromType: "DMN14__tRuleAnnotation", xsdType: "xsd:string" },
    },
    "DMN14__tImportedValues__extensionElements": {},
    "DMN14__tImportedValues": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tImportedValues__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tNamedElement", xsdType: "xsd:string" },
        "@_namespace": { type: "string", isArray: false, fromType: "DMN14__tImport", xsdType: "xsd:anyURI" },
        "@_locationURI": { type: "string", isArray: false, fromType: "DMN14__tImport", xsdType: "xsd:anyURI" },
        "@_importType": { type: "string", isArray: false, fromType: "DMN14__tImport", xsdType: "xsd:anyURI" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "DMN14__tImportedValues", xsdType: "xsd:anyURI" },
        "importedElement": { type: "string", isArray: false, fromType: "DMN14__tImportedValues", xsdType: "xsd:string" },
    },
    "DMN14__tArtifact__extensionElements": {},
    "DMN14__tArtifact": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tArtifact__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
    },
    "DMN14__tGroup__extensionElements": {},
    "DMN14__tGroup": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tGroup__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tGroup", xsdType: "xsd:string" },
    },
    "DMN14__tTextAnnotation__extensionElements": {},
    "DMN14__tTextAnnotation": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tTextAnnotation__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_textFormat": { type: "string", isArray: false, fromType: "DMN14__tTextAnnotation", xsdType: "xsd:string" },
        "text": { type: "string", isArray: false, fromType: "DMN14__tTextAnnotation", xsdType: "xsd:string" },
    },
    "DMN14__tAssociation__extensionElements": {},
    "DMN14__tAssociation": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tAssociation__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_associationDirection": { type: "DMN14__tAssociationDirection", isArray: false, fromType: "DMN14__tAssociation", xsdType: "// local type" },
        "sourceRef": { type: "DMN14__tDMNElementReference", isArray: false, fromType: "DMN14__tAssociation", xsdType: "// local type" },
        "targetRef": { type: "DMN14__tDMNElementReference", isArray: false, fromType: "DMN14__tAssociation", xsdType: "// local type" },
    },
    "DMN14__tContext__extensionElements": {},
    "DMN14__tContext": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tContext__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN14__tExpression", xsdType: "xsd:string" },
        "contextEntry": { type: "DMN14__tContextEntry", isArray: true, fromType: "DMN14__tContext", xsdType: "// local type" },
    },
    "DMN14__tContextEntry__extensionElements": {},
    "DMN14__tContextEntry": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tContextEntry__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "variable": { type: "DMN14__tInformationItem", isArray: false, fromType: "DMN14__tContextEntry", xsdType: "// local type" },
        "expression": { type: "DMN14__tExpression", isArray: false, fromType: "DMN14__tContextEntry", xsdType: "// local type" },
    },
    "DMN14__tFunctionDefinition__extensionElements": {},
    "DMN14__tFunctionDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tFunctionDefinition__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN14__tExpression", xsdType: "xsd:string" },
        "@_kind": { type: "DMN14__tFunctionKind", isArray: false, fromType: "DMN14__tFunctionDefinition", xsdType: "// local type" },
        "formalParameter": { type: "DMN14__tInformationItem", isArray: true, fromType: "DMN14__tFunctionDefinition", xsdType: "// local type" },
        "expression": { type: "DMN14__tExpression", isArray: false, fromType: "DMN14__tFunctionDefinition", xsdType: "// local type" },
    },
    "DMN14__tRelation__extensionElements": {},
    "DMN14__tRelation": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tRelation__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN14__tExpression", xsdType: "xsd:string" },
        "column": { type: "DMN14__tInformationItem", isArray: true, fromType: "DMN14__tRelation", xsdType: "// local type" },
        "row": { type: "DMN14__tList", isArray: true, fromType: "DMN14__tRelation", xsdType: "// local type" },
    },
    "DMN14__tList__extensionElements": {},
    "DMN14__tList": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tList__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN14__tExpression", xsdType: "xsd:string" },
        "expression": { type: "DMN14__tExpression", isArray: true, fromType: "DMN14__tList", xsdType: "// local type" },
    },
    "DMN14__tUnaryTests__extensionElements": {},
    "DMN14__tUnaryTests": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tUnaryTests__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN14__tExpression", xsdType: "xsd:string" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "DMN14__tUnaryTests", xsdType: "xsd:anyURI" },
        "text": { type: "string", isArray: false, fromType: "DMN14__tUnaryTests", xsdType: "xsd:string" },
    },
    "DMN14__tDecisionService__extensionElements": {},
    "DMN14__tDecisionService": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tDecisionService__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN14__tNamedElement", xsdType: "xsd:string" },
        "variable": { type: "DMN14__tInformationItem", isArray: false, fromType: "DMN14__tInvocable", xsdType: "// local type" },
        "outputDecision": { type: "DMN14__tDMNElementReference", isArray: true, fromType: "DMN14__tDecisionService", xsdType: "// local type" },
        "encapsulatedDecision": { type: "DMN14__tDMNElementReference", isArray: true, fromType: "DMN14__tDecisionService", xsdType: "// local type" },
        "inputDecision": { type: "DMN14__tDMNElementReference", isArray: true, fromType: "DMN14__tDecisionService", xsdType: "// local type" },
        "inputData": { type: "DMN14__tDMNElementReference", isArray: true, fromType: "DMN14__tDecisionService", xsdType: "// local type" },
    },
    "DMN14__tChildExpression": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tChildExpression", xsdType: "xsd:ID" },
        "expression": { type: "DMN14__tExpression", isArray: false, fromType: "DMN14__tChildExpression", xsdType: "// local type" },
    },
    "DMN14__tTypedChildExpression": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tChildExpression", xsdType: "xsd:ID" },
        "expression": { type: "DMN14__tExpression", isArray: false, fromType: "DMN14__tChildExpression", xsdType: "// local type" },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN14__tTypedChildExpression", xsdType: "xsd:string" },
    },
    "DMN14__tIterator__extensionElements": {},
    "DMN14__tIterator": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tIterator__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN14__tExpression", xsdType: "xsd:string" },
        "@_iteratorVariable": { type: "string", isArray: false, fromType: "DMN14__tIterator", xsdType: "xsd:string" },
        "in": { type: "DMN14__tTypedChildExpression", isArray: false, fromType: "DMN14__tIterator", xsdType: "// local type" },
    },
    "DMN14__tFor__extensionElements": {},
    "DMN14__tFor": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tFor__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN14__tExpression", xsdType: "xsd:string" },
        "@_iteratorVariable": { type: "string", isArray: false, fromType: "DMN14__tIterator", xsdType: "xsd:string" },
        "in": { type: "DMN14__tTypedChildExpression", isArray: false, fromType: "DMN14__tIterator", xsdType: "// local type" },
        "return": { type: "DMN14__tChildExpression", isArray: false, fromType: "DMN14__tFor", xsdType: "// local type" },
    },
    "DMN14__tQuantified__extensionElements": {},
    "DMN14__tQuantified": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tQuantified__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN14__tExpression", xsdType: "xsd:string" },
        "@_iteratorVariable": { type: "string", isArray: false, fromType: "DMN14__tIterator", xsdType: "xsd:string" },
        "in": { type: "DMN14__tTypedChildExpression", isArray: false, fromType: "DMN14__tIterator", xsdType: "// local type" },
        "satisfies": { type: "DMN14__tChildExpression", isArray: false, fromType: "DMN14__tQuantified", xsdType: "// local type" },
    },
    "DMN14__tConditional__extensionElements": {},
    "DMN14__tConditional": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tConditional__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN14__tExpression", xsdType: "xsd:string" },
        "if": { type: "DMN14__tChildExpression", isArray: false, fromType: "DMN14__tConditional", xsdType: "// local type" },
        "then": { type: "DMN14__tChildExpression", isArray: false, fromType: "DMN14__tConditional", xsdType: "// local type" },
        "else": { type: "DMN14__tChildExpression", isArray: false, fromType: "DMN14__tConditional", xsdType: "// local type" },
    },
    "DMN14__tFilter__extensionElements": {},
    "DMN14__tFilter": {
        "@_id": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN14__tFilter__extensionElements", isArray: false, fromType: "DMN14__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN14__tExpression", xsdType: "xsd:string" },
        "in": { type: "DMN14__tChildExpression", isArray: false, fromType: "DMN14__tFilter", xsdType: "// local type" },
        "match": { type: "DMN14__tChildExpression", isArray: false, fromType: "DMN14__tFilter", xsdType: "// local type" },
    },
    "DMNDI13__DMNDI": {
        "dmndi:DMNDiagram": { type: "DMNDI13__DMNDiagram", isArray: true, fromType: "DMNDI13__DMNDI", xsdType: "type found from namespace with declaration name 'dmndi'." },
        "dmndi:DMNStyle": { type: "DMNDI13__DMNStyle", isArray: true, fromType: "DMNDI13__DMNDI", xsdType: "type found from namespace with declaration name 'dmndi'." },
    },
    "DMNDI13__DMNDiagram__extension": {},
    "DMNDI13__DMNDiagram": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI13__DMNDiagram__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "@_name": { type: "string", isArray: false, fromType: "DI__Diagram", xsdType: "xsd:string" },
        "@_documentation": { type: "string", isArray: false, fromType: "DI__Diagram", xsdType: "xsd:string" },
        "@_resolution": { type: "float", isArray: false, fromType: "DI__Diagram", xsdType: "xsd:double" },
        "dmndi:Size": { type: "DC__Dimension", isArray: false, fromType: "DMNDI13__DMNDiagram", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:DMNDiagramElement": { type: "DI__DiagramElement", isArray: true, fromType: "DMNDI13__DMNDiagram", xsdType: "type found from namespace with declaration name 'di'." },
    },
    "DMNDI13__DMNShape__extension": {},
    "DMNDI13__DMNShape": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI13__DMNShape__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "dc:Bounds": { type: "DC__Bounds", isArray: false, fromType: "DI__Shape", xsdType: "type found from namespace with declaration name 'dc'." },
        "@_dmnElementRef": { type: "string", isArray: false, fromType: "DMNDI13__DMNShape", xsdType: "xsd:QName" },
        "@_isListedInputData": { type: "boolean", isArray: false, fromType: "DMNDI13__DMNShape", xsdType: "xsd:boolean" },
        "@_isCollapsed": { type: "boolean", isArray: false, fromType: "DMNDI13__DMNShape", xsdType: "xsd:boolean" },
        "dmndi:DMNLabel": { type: "DMNDI13__DMNLabel", isArray: false, fromType: "DMNDI13__DMNShape", xsdType: "type found from namespace with declaration name 'dmndi'." },
        "dmndi:DMNDecisionServiceDividerLine": { type: "DMNDI13__DMNDecisionServiceDividerLine", isArray: false, fromType: "DMNDI13__DMNShape", xsdType: "type found from namespace with declaration name 'dmndi'." },
    },
    "DMNDI13__DMNDecisionServiceDividerLine__extension": {},
    "DMNDI13__DMNDecisionServiceDividerLine": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI13__DMNDecisionServiceDividerLine__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "di:waypoint": { type: "DC__Point", isArray: true, fromType: "DI__Edge", xsdType: "type found from namespace with declaration name 'dc'." },
    },
    "DMNDI13__DMNEdge__extension": {},
    "DMNDI13__DMNEdge": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI13__DMNEdge__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "di:waypoint": { type: "DC__Point", isArray: true, fromType: "DI__Edge", xsdType: "type found from namespace with declaration name 'dc'." },
        "@_dmnElementRef": { type: "string", isArray: false, fromType: "DMNDI13__DMNEdge", xsdType: "xsd:QName" },
        "@_sourceElement": { type: "string", isArray: false, fromType: "DMNDI13__DMNEdge", xsdType: "xsd:QName" },
        "@_targetElement": { type: "string", isArray: false, fromType: "DMNDI13__DMNEdge", xsdType: "xsd:QName" },
        "dmndi:DMNLabel": { type: "DMNDI13__DMNLabel", isArray: false, fromType: "DMNDI13__DMNEdge", xsdType: "type found from namespace with declaration name 'dmndi'." },
    },
    "DMNDI13__DMNLabel__extension": {},
    "DMNDI13__DMNLabel": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI13__DMNLabel__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "dc:Bounds": { type: "DC__Bounds", isArray: false, fromType: "DI__Shape", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:Text": { type: "string", isArray: false, fromType: "DMNDI13__DMNLabel", xsdType: "xsd:string" },
    },
    "DMNDI13__DMNStyle__extension": {},
    "DMNDI13__DMNStyle": {
        "@_id": { type: "string", isArray: false, fromType: "DI__Style", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI13__DMNStyle__extension", isArray: false, fromType: "DI__Style", xsdType: "Anonumous type..." },
        "@_fontFamily": { type: "string", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "xsd:string" },
        "@_fontSize": { type: "float", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "xsd:double" },
        "@_fontItalic": { type: "boolean", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "xsd:boolean" },
        "@_fontBold": { type: "boolean", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "xsd:boolean" },
        "@_fontUnderline": { type: "boolean", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "xsd:boolean" },
        "@_fontStrikeThrough": { type: "boolean", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "xsd:boolean" },
        "@_labelHorizontalAlignement": { type: "DC__AlignmentKind", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
        "@_labelVerticalAlignment": { type: "DC__AlignmentKind", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:FillColor": { type: "DC__Color", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:StrokeColor": { type: "DC__Color", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:FontColor": { type: "DC__Color", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
    },
    "DC__Color": {
        "@_red": { type: "integer", isArray: false, fromType: "DC__Color", xsdType: "xsd:int" },
        "@_green": { type: "integer", isArray: false, fromType: "DC__Color", xsdType: "xsd:int" },
        "@_blue": { type: "integer", isArray: false, fromType: "DC__Color", xsdType: "xsd:int" },
    },
    "DC__Point": {
        "@_x": { type: "float", isArray: false, fromType: "DC__Point", xsdType: "xsd:double" },
        "@_y": { type: "float", isArray: false, fromType: "DC__Point", xsdType: "xsd:double" },
    },
    "DC__Dimension": {
        "@_width": { type: "float", isArray: false, fromType: "DC__Dimension", xsdType: "xsd:double" },
        "@_height": { type: "float", isArray: false, fromType: "DC__Dimension", xsdType: "xsd:double" },
    },
    "DC__Bounds": {
        "@_x": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
        "@_y": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
        "@_width": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
        "@_height": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
    },
    "DI__DiagramElement__extension": {},
    "DI__Diagram__extension": {},
    "DI__Shape__extension": {},
    "DI__Edge__extension": {},
    "DI__Style__extension": {},
};
//# sourceMappingURL=meta.js.map