import { By } from "selenium-webdriver";
import Explorer from "./Explorer";
import PageFragment from "../PageFragment";
import Properties from "./Properties";
const MAX_ATTEMPTS_TO_OPEN_SIDEBAR = 10;
class SideBar extends PageFragment {
    async waitUntilLoaded() {
        return await this.tools.by(SideBar.EXPLORER_BUTTON_LOCATOR).wait(1000).untilPresent();
    }
    async openSideBar(byIcon, sideBarTitle) {
        const expandedBar = this.tools.by(SideBar.EXPANDED_BAR_LOCATOR);
        for (let i = 0; !(await this.isSideBarOpen(sideBarTitle)) && i < MAX_ATTEMPTS_TO_OPEN_SIDEBAR; i++) {
            await byIcon.click();
            await this.tools.sleep(1000);
        }
        await expandedBar.wait(2000).untilVisible();
        await byIcon.offsetMove(-200, 0);
        return await expandedBar.getElement();
    }
    async isSideBarOpen(title) {
        const sideBarLocator = this.tools.by(SideBar.EXPANDED_BAR_LOCATOR);
        const isSideBarOpen = await sideBarLocator.wait().isVisible();
        if (isSideBarOpen) {
            const sideBar = await sideBarLocator.getElement();
            const sideBarTitle = await sideBar.findElement(SideBar.TITLE_LOCATOR);
            const actualTitle = await sideBarTitle.getText();
            if (actualTitle === title) {
                return true;
            }
        }
        return false;
    }
    async openExplorer() {
        const explorerButtonLocator = this.tools.by(SideBar.EXPLORER_BUTTON_LOCATOR);
        await explorerButtonLocator.wait(2000).untilPresent();
        const diagramButton = await explorerButtonLocator.getElement();
        const sideBar = await this.openSideBar(diagramButton, "Explore Diagram");
        return await this.tools.createPageFragment(Explorer, sideBar);
    }
    async openProperties() {
        const propButton = await this.tools.by(SideBar.PROP_BUTTON_LOCATOR).getElement();
        const sideBar = await this.openSideBar(propButton, "Properties");
        return await this.tools.createPageFragment(Properties, sideBar);
    }
}
SideBar.PROP_BUTTON_LOCATOR = By.xpath("//div[./button[@data-title='Properties']]");
SideBar.EXPLORER_BUTTON_LOCATOR = By.xpath("//div[./button[@data-title='Explore Diagram' or @data-title='Explore diagram']]");
SideBar.EXPANDED_BAR_LOCATOR = By.className("expanded-docks-bar-E");
SideBar.TITLE_LOCATOR = By.xpath("./div/h3");
export default SideBar;
//# sourceMappingURL=SideBar.js.map