import { By } from "selenium-webdriver";
import PageFragment from "../../PageFragment";
class BpmnPalette extends PageFragment {
    async waitUntilLoaded() {
        return await this.tools.by(BpmnPalette.START_EVENTS_LOCATOR).wait(1000).untilPresent();
    }
    async dragAndDropStartEventToCanvas() {
        const startEvents = await this.tools.by(BpmnPalette.START_EVENTS_LOCATOR).getElement();
        await startEvents.click();
        const startItem = await this.tools.by(BpmnPalette.START_ITEM_LOCATOR).getElement();
        await startItem.dragAndDrop(200, 0);
        const closeButton = await this.tools.by(BpmnPalette.CLOSE_LOCATOR).getElement();
        return await closeButton.click();
    }
}
BpmnPalette.START_EVENTS_LOCATOR = By.xpath("//button[@title='Start Events']");
BpmnPalette.START_ITEM_LOCATOR = By.xpath("//a[@class='kie-palette-item-anchor-spacer']" + "[span[text()='Start']]");
BpmnPalette.CLOSE_LOCATOR = By.className("kie-palette-flyout__btn-link--close");
export default BpmnPalette;
//# sourceMappingURL=BpmnPalette.js.map