import { Editor, EditorFactory, EditorInitArgs, KogitoEditorEnvelopeContextType, KogitoEditorChannelApi, EditorTheme, ChannelType, KogitoEditorEnvelopeApi } from "@kie-tools-core/editor/dist/api";
import { Notification } from "@kie-tools-core/notifications/dist/api";
import { DmnEditorRoot } from "./DmnEditorRoot";
export declare class DmnEditorFactory implements EditorFactory<Editor, KogitoEditorEnvelopeApi, KogitoEditorChannelApi> {
    createEditor(envelopeContext: KogitoEditorEnvelopeContextType<KogitoEditorEnvelopeApi, KogitoEditorChannelApi>, initArgs: EditorInitArgs): Promise<Editor>;
}
export declare class DmnEditorInterface implements Editor {
    protected readonly envelopeContext: KogitoEditorEnvelopeContextType<KogitoEditorEnvelopeApi, KogitoEditorChannelApi>;
    protected readonly initArgs: EditorInitArgs;
    protected self: DmnEditorRoot;
    af_isReact: boolean;
    af_componentId: "dmn-editor";
    af_componentTitle: "DMN Editor";
    constructor(envelopeContext: KogitoEditorEnvelopeContextType<KogitoEditorEnvelopeApi, KogitoEditorChannelApi>, initArgs: EditorInitArgs);
    getPreview(): Promise<string | undefined>;
    validate(): Promise<Notification[]>;
    setTheme(theme: EditorTheme): Promise<void>;
    undo(): Promise<void>;
    redo(): Promise<void>;
    getContent(): Promise<string>;
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot: string, content: string): Promise<void>;
    af_componentRoot(): JSX.Element;
}
export declare function DmnEditorRootWrapper({ envelopeContext, exposing, workspaceRootAbsolutePosixPath, isEvaluationHighlightsSupported, isReadOnly, channelType, onOpenedBoxedExpressionEditorNodeChange, }: {
    envelopeContext?: KogitoEditorEnvelopeContextType<KogitoEditorEnvelopeApi, KogitoEditorChannelApi>;
    exposing: (s: DmnEditorRoot) => void;
    workspaceRootAbsolutePosixPath: string;
    isEvaluationHighlightsSupported?: boolean;
    isReadOnly: boolean;
    channelType?: ChannelType;
    onOpenedBoxedExpressionEditorNodeChange?: (newOpenedNodeId: string | undefined) => void;
}): JSX.Element;
//# sourceMappingURL=DmnEditorFactory.d.ts.map