import { jsx as _jsx } from "react/jsx-runtime";
import { useMemo } from "react";
import ProcessListContext from "./ProcessListContext";
import { ProcessListGatewayApiImpl } from "./ProcessListGatewayApi";
import { GraphQLProcessListQueries } from "./ProcessListQueries";
export const ProcessListContextProvider = ({ apolloClient, children, options, }) => {
    const gatewayApiImpl = useMemo(() => {
        return new ProcessListGatewayApiImpl(new GraphQLProcessListQueries(apolloClient, options));
    }, [apolloClient, options]);
    return _jsx(ProcessListContext.Provider, { value: gatewayApiImpl, children: children });
};
export default ProcessListContextProvider;
//# sourceMappingURL=ProcessListContextProvider.js.map