/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.plugin.es.EsService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.enums.LogStorageTypeEnum;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.manager.domain.EsCluster;
import org.apache.ozhera.log.manager.mapper.MilogEsClusterMapper;
import org.apache.ozhera.log.manager.model.pojo.MilogEsClusterDO;
import org.apache.ozhera.log.manager.service.EsIndexOperateService;
import org.apache.ozhera.log.utils.DateUtils;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetComposableIndexTemplateRequest;
import org.elasticsearch.client.indices.GetComposableIndexTemplatesResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexTemplatesRequest;
import org.elasticsearch.client.indices.IndexTemplateMetadata;
import org.elasticsearch.client.indices.PutComposableIndexTemplateRequest;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class EsIndexOperateServiceImpl
implements EsIndexOperateService {
    private static final Logger log = LoggerFactory.getLogger(EsIndexOperateServiceImpl.class);
    @Resource
    private MilogEsClusterMapper esClusterMapper;
    @Resource
    private EsCluster esCluster;
    private List<String> containKeys = Lists.newArrayList((Object[])new String[]{"mione", "zgq"});

    @Override
    public void createIndexPre() {
        List<MilogEsClusterDO> esClusterDOS = this.esClusterMapper.selectAll();
        for (MilogEsClusterDO esClusterDO : esClusterDOS) {
            try {
                EsService esService;
                LogStorageTypeEnum storageTypeEnum = LogStorageTypeEnum.queryByName((String)esClusterDO.getLogStorageType());
                if (LogStorageTypeEnum.ELASTICSEARCH != storageTypeEnum || (esService = this.esCluster.getEsService(esClusterDO.getId())) == null) continue;
                List<String> indexTemplates = this.getIndexTemplate(esService);
                String today = DateUtils.getTime();
                String tomorrow = DateUtils.getTime((int)1);
                for (String indexTemplateName : indexTemplates) {
                    log.info("index template name:{}", (Object)indexTemplateName);
                    if (indexTemplateName.startsWith(".")) continue;
                    if (!this.containKeys.stream().anyMatch(indexTemplateName::contains)) continue;
                    this.createOrCheckIndex(esService, indexTemplateName, today);
                    this.createOrCheckIndex(esService, indexTemplateName, tomorrow);
                }
            }
            catch (Exception e) {
                log.error("createIndexPre,error,param:{}", (Object)Constant.GSON.toJson((Object)esClusterDO), (Object)e);
            }
        }
    }

    private List<String> getIndexTemplate(EsService esService) throws IOException {
        ArrayList<String> templateNames = new ArrayList<String>();
        try {
            RestHighLevelClient client = esService.getEsClient().getEsOriginalClient();
            for (String containKey : this.containKeys) {
                GetComposableIndexTemplateRequest templateRequest = new GetComposableIndexTemplateRequest(String.format("*%s*", containKey));
                GetComposableIndexTemplatesResponse indexTemplatesResponse = client.indices().getIndexTemplate(templateRequest, RequestOptions.DEFAULT);
                Map indexTemplates = indexTemplatesResponse.getIndexTemplates();
                for (Map.Entry mapEntry : indexTemplates.entrySet()) {
                    String name = (String)mapEntry.getKey();
                    ComposableIndexTemplate value = (ComposableIndexTemplate)mapEntry.getValue();
                    Template template = value.template();
                    String today = DateUtils.getTime();
                    String newRolloverAlias = String.format("%s-%s", name, today);
                    if (templateNames.contains(name)) continue;
                    templateNames.add(name);
                    if (null != template) {
                        Settings settings = template.settings();
                        String rolloverAlias = settings.get("index.lifecycle.rollover_alias");
                        if (StringUtils.equals((CharSequence)rolloverAlias, (CharSequence)newRolloverAlias)) continue;
                        EsIndexOperateServiceImpl.updateTemplate(template, newRolloverAlias, name, client);
                        continue;
                    }
                    EsIndexOperateServiceImpl.updateTemplate(null, newRolloverAlias, name, client);
                }
            }
        }
        catch (Exception e) {
            log.info("getIndexTemplate (_index_template error,use _template command)", (Throwable)e);
            GetIndexTemplatesRequest indexTemplatesRequest = new GetIndexTemplatesRequest(new String[0]);
            List indexTemplates = esService.getIndexTemplates(indexTemplatesRequest);
            for (IndexTemplateMetadata template : indexTemplates) {
                if (!this.containKeys.stream().anyMatch(data -> template.name().contains((CharSequence)data)) || templateNames.contains(template.name())) continue;
                templateNames.add(template.name());
                Settings settings = template.settings();
                String rolloverAlias = settings.get("index.lifecycle.rollover_alias");
                if (rolloverAlias != null) {
                    String today;
                    String name = template.name();
                    String newRolloverAlias = String.format("%s-%s", name, today = DateUtils.getTime());
                    if (StringUtils.equals((CharSequence)rolloverAlias, (CharSequence)newRolloverAlias)) continue;
                    this.updateTemplate(esService, template);
                    continue;
                }
                this.updateTemplate(esService, template);
            }
        }
        return templateNames;
    }

    private static void updateTemplate(Template template, String newRolloverAlias, String name, RestHighLevelClient client) throws IOException {
        Settings.Builder updatedSettings = Settings.builder().put(template.settings());
        updatedSettings.put("index.lifecycle.rollover_alias", newRolloverAlias);
        IndexTemplateMetadata.Builder updatedTemplateBuilder = IndexTemplateMetadata.builder((String)name);
        updatedTemplateBuilder.settings(Settings.builder().put(template.settings()).put("index.lifecycle.rollover_alias", newRolloverAlias));
        Template newTemplate = new Template(updatedSettings.build(), template.mappings(), template.aliases());
        PutComposableIndexTemplateRequest request = new PutComposableIndexTemplateRequest().name(name);
        ComposableIndexTemplate composableIndexTemplate = new ComposableIndexTemplate(Arrays.asList(name + "-*"), newTemplate, null, null, null, null);
        request.indexTemplate(composableIndexTemplate);
        client.indices().putIndexTemplate(request, RequestOptions.DEFAULT);
        log.info("update ComposableIndexTemplate:{} success,", (Object)name);
    }

    private void updateTemplate(EsService esService, IndexTemplateMetadata template) throws IOException {
        String name = template.name();
        String today = DateUtils.getTime();
        String newRolloverAlias = String.format("%s-%s", name, today);
        Settings.Builder updatedSettings = Settings.builder().put(template.settings());
        updatedSettings.put("index.lifecycle.rollover_alias", newRolloverAlias);
        PutIndexTemplateRequest putRequest = new PutIndexTemplateRequest(template.name());
        putRequest.patterns(template.patterns());
        putRequest.order(template.order());
        putRequest.settings(updatedSettings.build());
        putRequest.mapping(template.mappings().getSourceAsMap());
        putRequest.version(template.version());
        for (ObjectObjectCursor aliasEntry : template.aliases()) {
            AliasMetadata aliasMetadata = (AliasMetadata)aliasEntry.value;
            Alias alias = new Alias((String)aliasEntry.key);
            alias.routing(aliasMetadata.getIndexRouting());
            alias.isHidden(aliasMetadata.isHidden());
            if (aliasMetadata.writeIndex() != null) {
                alias.writeIndex(aliasMetadata.writeIndex());
            }
            alias.searchRouting(aliasMetadata.searchRouting());
            putRequest.alias(alias);
        }
        esService.getEsClient().getEsOriginalClient().indices().putTemplate(putRequest, RequestOptions.DEFAULT);
    }

    private void createOrCheckIndex(EsService esService, String templateName, String dateSuffix) throws IOException {
        String indexCreateName = String.format("%s-%s-000001", templateName, dateSuffix);
        GetIndexRequest todayIndexRequest = new GetIndexRequest(new String[]{indexCreateName});
        try {
            boolean dateIndexExists = esService.getEsClient().getEsOriginalClient().indices().exists(todayIndexRequest, RequestOptions.DEFAULT);
            if (!dateIndexExists) {
                CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexCreateName);
                Alias alias = new Alias(String.format("%s-%s", templateName, dateSuffix));
                alias.writeIndex(Boolean.valueOf(true));
                createIndexRequest.alias(alias);
                createIndexRequest.source("{\n  \"settings\": {\n    \"index.lifecycle.rollover_alias\": \"" + String.format("%s-%s", templateName, dateSuffix) + "\"\n  }\n}", XContentType.JSON);
                esService.createIndex(createIndexRequest);
                log.error("index:{} create success", (Object)indexCreateName);
            }
        }
        catch (Exception e) {
            log.error("createOrCheckIndex error, index:{}", (Object)indexCreateName, (Object)e);
        }
    }
}

