/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.server.handler;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.CommandExecutor;
import org.apache.dubbo.qos.command.DefaultCommandExecutor;
import org.apache.dubbo.qos.command.NoSuchCommandException;
import org.apache.dubbo.qos.command.decoder.HttpCommandDecoder;

public class HttpProcessHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private static final Logger log = LoggerFactory.getLogger(HttpProcessHandler.class);
    private static CommandExecutor commandExecutor = new DefaultCommandExecutor();

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest msg) throws Exception {
        FullHttpResponse response;
        CommandContext commandContext = HttpCommandDecoder.decode(msg);
        if (commandContext == null) {
            log.warn("can not found commandContext url: " + msg.getUri());
            response = HttpProcessHandler.http404();
        } else {
            commandContext.setRemote(ctx.channel());
            try {
                String result = commandExecutor.execute(commandContext);
                response = HttpProcessHandler.http200(result);
            }
            catch (NoSuchCommandException ex) {
                log.error("can not find commandContext: " + commandContext, ex);
                response = HttpProcessHandler.http404();
            }
            catch (Exception qosEx) {
                log.error("execute commandContext: " + commandContext + " got exception", qosEx);
                response = HttpProcessHandler.http500(qosEx.getMessage());
            }
        }
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static final FullHttpResponse http200(String result) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])result.getBytes()));
        return HttpProcessHandler.fillFullHttpResponse((FullHttpResponse)response);
    }

    private static final FullHttpResponse http404() {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
        return HttpProcessHandler.fillFullHttpResponse((FullHttpResponse)response);
    }

    private static final FullHttpResponse http500(String errorMessage) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.wrappedBuffer((byte[])errorMessage.getBytes()));
        return HttpProcessHandler.fillFullHttpResponse((FullHttpResponse)response);
    }

    private static FullHttpResponse fillFullHttpResponse(FullHttpResponse response) {
        HttpHeaders httpHeaders = response.headers();
        httpHeaders.set("Content-Type", (Object)"text/plain");
        httpHeaders.set("Content-Length", (Object)response.content().readableBytes());
        return response;
    }
}

