/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.service.env;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.google.common.collect.Lists;
import com.xiaomi.data.push.nacos.NacosNaming;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.model.vo.HeraAppEnvVo;
import org.apache.ozhera.app.service.env.EnvIpFetch;
import org.springframework.stereotype.Service;

@Service
public class DefaultNacosEnvIpFetch
implements EnvIpFetch {
    @Resource
    private NacosNaming nacosNaming;
    @NacosValue(value="${app_log_agent_max:30}", autoRefreshed=true)
    private String appLoAgentMax;
    @NacosValue(value="${app_log_agent_id:10010}", autoRefreshed=true)
    private String appLogAgentId;
    @NacosValue(value="${app_log_agent_name:log-agent}", autoRefreshed=true)
    private String appLogAgentName;

    @Override
    public HeraAppEnvVo fetch(Long appBaseId, Long appId, String appName) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)appName)) {
            appName = appName.replaceAll("-", "_");
        }
        String serviceName = String.format("%s_%s_%s", "prometheus_server", appId, appName);
        List instances = this.nacosNaming.getAllInstances(serviceName);
        this.handleLogAgentEnv(serviceName, appName, appId, instances);
        List<HeraAppEnvVo.EnvVo> envVos = this.getEnvVos(instances);
        return this.buildHeraAppEnvVo(appBaseId, appId, appName, envVos);
    }

    private void handleLogAgentEnv(String serviceNamePrefix, String appName, Long appId, List<Instance> instances) throws NacosException {
        if (this.isLogAgent(appName, appId)) {
            this.fetchAndAddLogAgentInstances(serviceNamePrefix, instances);
        }
    }

    private boolean isLogAgent(String appName, Long appId) {
        return Objects.equals(appName, this.appLogAgentName) && Objects.equals(appId, Long.valueOf(this.appLogAgentId));
    }

    private void fetchAndAddLogAgentInstances(String serviceNamePrefix, List<Instance> instances) throws NacosException {
        for (int i = 0; i <= Integer.valueOf(this.appLoAgentMax); ++i) {
            String serviceName = String.format("%s_%s", serviceNamePrefix, i);
            List currentInstances = this.nacosNaming.getAllInstances(serviceName);
            if (!CollectionUtils.isNotEmpty((Collection)currentInstances)) continue;
            instances.addAll(currentInstances);
        }
    }

    private List<HeraAppEnvVo.EnvVo> getEnvVos(List<Instance> instances) {
        ArrayList envVos = Lists.newArrayList();
        ArrayList envIds = Lists.newArrayList();
        ArrayList envNames = Lists.newArrayList();
        this.buildEnvIdAndName(envIds, envNames, instances);
        for (int i = 0; i < envIds.size(); ++i) {
            String envId = (String)envIds.get(i);
            HeraAppEnvVo.EnvVo envVo = new HeraAppEnvVo.EnvVo();
            envVo.setEnvId(Long.valueOf(envId));
            envVo.setEnvName((String)envNames.get(i));
            if (this.isDefaultEnv(envId)) {
                envVo.setIpList(instances.parallelStream().filter(instance -> !instance.getMetadata().containsKey("env_id")).map(Instance::getIp).distinct().collect(Collectors.toList()));
            } else {
                envVo.setIpList(instances.parallelStream().filter(instance -> Objects.equals(envId, instance.getMetadata().get("env_id"))).map(Instance::getIp).distinct().collect(Collectors.toList()));
            }
            envVos.add(envVo);
        }
        return envVos;
    }

    private void buildEnvIdAndName(List<String> envIds, List<String> envNames, List<Instance> instances) {
        if (CollectionUtils.isNotEmpty(instances)) {
            instances.stream().forEach(instance -> {
                Map metadata = instance.getMetadata();
                if (metadata.containsKey("env_id")) {
                    String envName;
                    String envId = (String)metadata.get("env_id");
                    if (!envIds.contains(envId)) {
                        envIds.add(envId);
                    }
                    if (!envNames.contains(envName = (String)metadata.get("env_name"))) {
                        envNames.add(envName);
                    }
                } else {
                    if (!envIds.contains("0")) {
                        envIds.add("0");
                    }
                    if (!envNames.contains("default_env")) {
                        envNames.add("default_env");
                    }
                }
            });
        }
    }

    private boolean isDefaultEnv(String envId) {
        return Objects.equals(envId, "0");
    }
}

