/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.lang.util.Context;
import org.nutz.mvc.ActionHandler;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.SessionProvider;
import org.nutz.mvc.config.ServletNutConfig;

public class NutServlet
extends HttpServlet {
    protected ActionHandler handler;
    private String selfName;
    private SessionProvider sp;
    protected ServletContext sc;

    public void init(ServletConfig servletConfig) throws ServletException {
        this.sc = servletConfig.getServletContext();
        Mvcs.setServletContext(this.sc);
        this.selfName = servletConfig.getServletName();
        Mvcs.set(this.selfName, null, null);
        ServletNutConfig config = new ServletNutConfig(servletConfig);
        Mvcs.setNutConfig(config);
        this.handler = new ActionHandler(config);
        this.sp = config.getSessionProvider();
    }

    public void destroy() {
        Mvcs.resetALL();
        Mvcs.set(this.selfName, null, null);
        if (this.handler != null) {
            this.handler.depose();
        }
        Mvcs.close();
        Mvcs.setServletContext(null);
        Mvcs.ctx().removeReqCtx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String markKey;
        Integer mark;
        if (!Mvcs.DISABLE_X_POWERED_BY) {
            resp.setHeader("X-Powered-By", Mvcs.X_POWERED_BY);
        }
        if ((mark = (Integer)req.getAttribute(markKey = "nutz_ctx_mark")) != null) {
            req.setAttribute(markKey, (Object)(mark + 1));
        } else {
            req.setAttribute(markKey, (Object)0);
        }
        ServletContext prCtx = Mvcs.getServletContext();
        Mvcs.setServletContext(this.sc);
        String preName = Mvcs.getName();
        Context preContext = Mvcs.resetALL();
        try {
            if (this.sp != null) {
                req = this.sp.filter(req, resp, this.sc);
            }
            Mvcs.set(this.selfName, req, resp);
            if (!this.handler.handle(req, resp)) {
                resp.sendError(404);
            }
        }
        finally {
            Mvcs.resetALL();
            if (mark != null) {
                Mvcs.setServletContext(prCtx);
                Mvcs.set(preName, req, resp);
                Mvcs.ctx().reqCtx(preContext);
                if (mark == 0) {
                    req.removeAttribute(markKey);
                } else {
                    req.setAttribute(markKey, (Object)(mark - 1));
                }
            } else {
                Mvcs.setServletContext(null);
                Mvcs.ctx().removeReqCtx();
            }
        }
    }
}

