/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.operators.ali;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.aliyun.arms20190808.Client;
import com.aliyun.arms20190808.models.CreateEnvCustomJobRequest;
import com.aliyun.arms20190808.models.CreateEnvCustomJobResponse;
import com.aliyun.arms20190808.models.CreateEnvironmentRequest;
import com.aliyun.arms20190808.models.CreateEnvironmentResponse;
import com.aliyun.arms20190808.models.CreateOrUpdateAlertRuleRequest;
import com.aliyun.arms20190808.models.CreateOrUpdateAlertRuleResponse;
import com.aliyun.arms20190808.models.CreateOrUpdateNotificationPolicyRequest;
import com.aliyun.arms20190808.models.CreateOrUpdateNotificationPolicyResponse;
import com.aliyun.arms20190808.models.CreateOrUpdateWebhookContactRequest;
import com.aliyun.arms20190808.models.CreateOrUpdateWebhookContactResponse;
import com.aliyun.arms20190808.models.DeleteAlertRuleRequest;
import com.aliyun.arms20190808.models.DeleteAlertRuleResponse;
import com.aliyun.arms20190808.models.DeleteEnvCustomJobRequest;
import com.aliyun.arms20190808.models.DeleteEnvCustomJobResponse;
import com.aliyun.arms20190808.models.DescribeEnvironmentRequest;
import com.aliyun.arms20190808.models.DescribeEnvironmentResponse;
import com.aliyun.arms20190808.models.DescribeWebhookContactsRequest;
import com.aliyun.arms20190808.models.DescribeWebhookContactsResponse;
import com.aliyun.arms20190808.models.GetAlertRulesRequest;
import com.aliyun.arms20190808.models.GetAlertRulesResponse;
import com.aliyun.arms20190808.models.ListEnvCustomJobsRequest;
import com.aliyun.arms20190808.models.ListEnvCustomJobsResponse;
import com.aliyun.arms20190808.models.ListEnvironmentsRequest;
import com.aliyun.arms20190808.models.ListEnvironmentsResponse;
import com.aliyun.arms20190808.models.ListNotificationPoliciesRequest;
import com.aliyun.arms20190808.models.ListNotificationPoliciesResponse;
import com.aliyun.arms20190808.models.UpdateEnvCustomJobRequest;
import com.aliyun.arms20190808.models.UpdateEnvCustomJobResponse;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.prometheus.agent.operators.BasicOperator;
import org.apache.ozhera.prometheus.agent.param.alertManager.Rule;
import org.apache.ozhera.prometheus.agent.param.prometheus.ali.AliLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliPrometheusOperator
implements BasicOperator {
    private static final Logger log = LoggerFactory.getLogger(AliPrometheusOperator.class);
    @NacosValue(value="${prometheus.ali.accessKeyId:unknown}")
    private String accessKeyId;
    @NacosValue(value="${prometheus.ali.accessKeySecret:unknown}")
    private String accessKeySecret;
    @NacosValue(value="${prometheus.ali.cluster.id}")
    private String clusterId;
    @NacosValue(value="${prometheus.ali.webhook.url:unknown}")
    private String webhookUrl;
    @NacosValue(value="${prometheus.ali.webhook.method:Post}")
    private String webhookMethod;
    @NacosValue(value="${prometheus.ali.environment.name:unknown}")
    private String environmentName;
    public static final String DEFAULT_REGION_ID = "cn-beijing";
    public static final Integer SUCCESS_CODE = 200;
    public static final String ALI_ENVIRONMENT_TYPE = "CS";
    public static final String ALI_ENVIRONNMENT_SUB_TYPE = "ACK";
    public static final String ALI_JOB_RUN_STATUS = "run";
    public static final String ALI_JOB_STOP_STATUS = "stop";
    public static final String ALI_ALERT_WEBHOOK_NAME = "OZHera";
    public static final String ALI_ALERT_DEFAULT_DATA_PUSH = "{{ . }}";
    public static final String ALI_ALERT_DEFAULT_ALERT_TYPE = "PROMETHEUS_MONITORING_ALERT_RULE";
    public static final String ALI_ALERT_RUN_STATUS = "RUNNING";
    public static final String ALI_ALERT_STOP_STATUS = "STOPPED";
    public static final String ALI_ALERT_DEFAULT_NOTIFY_STRATEGY = "OZHera_default_notify_strategy";
    public static final List<String> ALI_ALERT_DEFAULT_NOTIFY_STRATEGY_LIST = new ArrayList<String>(){
        {
            this.add("OZHera_default_notify_strategy_300");
            this.add("OZHera_default_notify_strategy_900");
            this.add("OZHera_default_notify_strategy_1800");
            this.add("OZHera_default_notify_strategy_3600");
            this.add("OZHera_default_notify_strategy_7200");
        }
    };
    public static final String ALI_ALERT_DEFAULT_CHECK_TYPE = "CUSTOM";
    public static String ALI_ENVIRONMENT_NAME = "";
    public static final List<String> ALI_ALERT_LABELS_KEYS = List.of(new String[]{"detailRedirectUrl", "send_interval", "alert_key", "alert_op", "alert_value", "calert"});
    private Client aliPrometheusClient;
    private final Gson gson = new Gson();
    private String aliAlertMessage = "";

    @PostConstruct
    public void init() {
        log.info("AliPrometheusOperator begin init!");
        ALI_ENVIRONMENT_NAME = this.environmentName;
        this.aliAlertMessage = "{\n\t\"alerts\":[\n\t\t{{ for .alerts }}\n\t\t{\n\t\t\t\"annotations\": {\n\t\t\t\t\"title\": \"{{ .annotations.title }}\"\n\t\t\t},\n\t\t\t\"endsAt\": \"{{ .endsAt }}\",\n\t\t\t\"fingerprint\": \"{{ .fingerprint }}\",\n\t\t\t\"labels\": {\n\t\t\t\t\"alert_op\": \"{{ .labels.alert_op }}\",\n\t\t\t\t\"alert_value\": \"{{ .labels.alert_value }}\",\n\t\t\t\t\"alertname\": \"{{ .labels.alertname }}\",\n\t\t\t\t\"application\": \"{{ .labels.application }}\",\n\t\t\t\t\"methodName\": \"{{ .labels.methodName }}\",\n\t\t\t\t\"metrics\": \"{{ .labels.metrics }}\",\n\t\t\t\t\"metrics_flag\": \"{{ .labels.metrics_flag }}\",\n\t\t\t\t\"serverEnv\": \"{{ .labels.serverEnv }}\",\n\t\t\t\t\"serverIp\": \"{{ .labels.serverIp }}\",\n\t\t\t\t\"ip\": \"{{ .labels.ip }}\",\n\t\t\t\t\"job\": \"{{ .labels.job }}\",\n\t\t\t\t\"namespace\": \"{{ .labels.namespace }}\",\n\t\t\t\t\"pod\": \"{{ .labels.pod }}\",\n\t\t\t\t\"detailRedirectUrl\": \"{{ .labels.detailRedirectUrl }}\",\n\t\t\t\t\"serviceName\":\"{{ .labels.serviceName }}\",\n\t\t\t\t\"send_interval\":\"{{ .labels.send_interval }}\"\n\t\t\t},\n\t\t\t\"startsAt\": \"{{ .startsAt }}\",\n\t\t\t\"status\": \"{{ .status }}\"\n\t\t}\n\t\t{{ end }}\n\t],\n\"commonAnnotations\": {\n\t\"title\": \"{{ .commonAnnotations.title }}\"\n},\n\"groupKey\":null,\n\"receiver\":null,\n\"truncatedAlerts\":0,\n\"version\":4,\n  \"status\": \"{{ .status }}\",\n  \"startTime\":\"{{ .startTime }}\",\n  \"endTime\":\"{{ .endTime }}\",\n  \"level\":\"{{ .level }}\",\n  \"dispatchRuleName\":\"{{ .dispatchRuleName }}\",\n  \"alarmId\":\"{{ .alarmId }}\"\n}";
        this.aliPrometheusClient = this.createClient();
    }

    private Client createClient() {
        try {
            Config config = new Config().setAccessKeyId(this.accessKeyId).setAccessKeySecret(this.accessKeySecret);
            config.endpoint = "arms.cn-beijing.aliyuncs.com";
            return new Client(config);
        }
        catch (Exception e) {
            log.error("AliPrometheusOperator.createClient error :{}", (Throwable)e);
            return null;
        }
    }

    public CreateEnvironmentResponse CreateEnvironment() {
        CreateEnvironmentRequest createEnvironmentRequest = new CreateEnvironmentRequest().setRegionId(DEFAULT_REGION_ID).setEnvironmentName(ALI_ENVIRONMENT_NAME).setEnvironmentType(ALI_ENVIRONMENT_TYPE).setEnvironmentSubType(ALI_ENVIRONNMENT_SUB_TYPE).setBindResourceId(this.clusterId);
        log.info("AliPrometheusOperator.CreateEnvironment req :{}", (Object)createEnvironmentRequest.toMap());
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            CreateEnvironmentResponse environmentWithOptions = this.aliPrometheusClient.createEnvironmentWithOptions(createEnvironmentRequest, runtime);
            log.info("AliPrometheusOperator.CreateEnvironment res :{}", (Object)environmentWithOptions.toMap());
            return environmentWithOptions;
        }
        catch (TeaException error) {
            log.error("AliPrometheusOperator.CreateEnvironment error ,message :{},recommend url :{}", (Object)error.getMessage(), error.getData().get("Recommend"));
            return null;
        }
        catch (Exception _error) {
            log.error("AliPrometheusOperator.CreateEnvironment error ,message :{}", (Object)_error.getMessage());
            return null;
        }
    }

    public ListEnvironmentsResponse ListEnvironments() {
        ListEnvironmentsRequest listEnvironmentsRequest = new ListEnvironmentsRequest().setRegionId(DEFAULT_REGION_ID).setEnvironmentType(ALI_ENVIRONMENT_TYPE);
        log.info("AliPrometheusOperator.ListEnvironments req :{}", (Object)listEnvironmentsRequest.toMap());
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            ListEnvironmentsResponse listEnvironmentsResponse = this.aliPrometheusClient.listEnvironmentsWithOptions(listEnvironmentsRequest, runtime);
            log.info("AliPrometheusOperator.ListEnvironments res :{}", (Object)listEnvironmentsResponse.toMap());
            return listEnvironmentsResponse;
        }
        catch (TeaException error) {
            log.error("AliPrometheusOperator.CreateEnvironment error ,message :{},recommend url :{}", (Object)error.getMessage(), error.getData().get("Recommend"));
            return null;
        }
        catch (Exception _error) {
            log.error("AliPrometheusOperator.CreateEnvironment error ,message :{}", (Object)_error.getMessage());
            return null;
        }
    }

    public DescribeEnvironmentResponse describeEnvironment() {
        DescribeEnvironmentRequest describeEnvironmentRequest = new DescribeEnvironmentRequest().setRegionId(DEFAULT_REGION_ID).setEnvironmentId("xxx");
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            DescribeEnvironmentResponse describeEnvironmentResponse = this.aliPrometheusClient.describeEnvironmentWithOptions(describeEnvironmentRequest, runtime);
            log.info("AliPrometheusOperator.describeEnvironment res :{}", (Object)describeEnvironmentResponse.toMap());
            return describeEnvironmentResponse;
        }
        catch (TeaException error) {
            log.error("AliPrometheusOperator.describeEnvironment error ,message :{},recommend url :{}", (Object)error.getMessage(), error.getData().get("Recommend"));
            return null;
        }
        catch (Exception _error) {
            log.error("AliPrometheusOperator.describeEnvironment error ,message :{}", (Object)_error.getMessage());
            return null;
        }
    }

    public ListEnvCustomJobsResponse ListEnvCustomJobs(String environmentId) {
        ListEnvCustomJobsRequest listEnvCustomJobsRequest = new ListEnvCustomJobsRequest().setRegionId(DEFAULT_REGION_ID).setEnvironmentId(environmentId).setEncryptYaml(Boolean.valueOf(false));
        log.info("AliPrometheusOperator.ListEnvCustomJobs req :{}", (Object)listEnvCustomJobsRequest.toMap());
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            ListEnvCustomJobsResponse listEnvCustomJobsResponse = this.aliPrometheusClient.listEnvCustomJobsWithOptions(listEnvCustomJobsRequest, runtime);
            log.info("AliPrometheusOperator.ListEnvCustomJobs res :{}", (Object)listEnvCustomJobsResponse.toMap());
            return listEnvCustomJobsResponse;
        }
        catch (TeaException error) {
            log.error("AliPrometheusOperator.ListEnvCustomJobs error ,message :{},recommend url :{}", (Object)error.getMessage(), error.getData().get("Recommend"));
            return null;
        }
        catch (Exception _error) {
            log.error("AliPrometheusOperator.ListEnvCustomJobs error ,message :{}", (Object)_error.getMessage());
            return null;
        }
    }

    public CreateEnvCustomJobResponse CreateEnvCustomJob(String environmentId, String customJobName, String configYaml) {
        CreateEnvCustomJobRequest createEnvCustomJobRequest = new CreateEnvCustomJobRequest().setRegionId(DEFAULT_REGION_ID).setEnvironmentId(environmentId).setCustomJobName(customJobName).setConfigYaml(configYaml);
        log.info("AliPrometheusOperator.CreateEnvCustomJob req :{}", (Object)createEnvCustomJobRequest.toMap());
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            CreateEnvCustomJobResponse envCustomJobWithOptions = this.aliPrometheusClient.createEnvCustomJobWithOptions(createEnvCustomJobRequest, runtime);
            log.info("AliPrometheusOperator.CreateEnvCustomJob res :{}", (Object)envCustomJobWithOptions.toMap());
            return envCustomJobWithOptions;
        }
        catch (TeaException error) {
            log.error("AliPrometheusOperator.CreateEnvCustomJob error ,message :{},recommend url :{}", (Object)error.getMessage(), error.getData().get("Recommend"));
            return null;
        }
        catch (Exception _error) {
            log.error("AliPrometheusOperator.CreateEnvCustomJob error ,message :{}", (Object)_error.getMessage());
            return null;
        }
    }

    public UpdateEnvCustomJobResponse updateEnvCustomJob(String environmentId, String jobName, String configYamlyaml, String status) {
        UpdateEnvCustomJobRequest updateEnvCustomJobRequest = new UpdateEnvCustomJobRequest().setRegionId(DEFAULT_REGION_ID).setEnvironmentId(environmentId).setCustomJobName(jobName).setConfigYaml(configYamlyaml).setStatus(status);
        log.info("AliPrometheusOperator.UpdateEnvCustomJob req :{}", (Object)updateEnvCustomJobRequest.toMap());
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            UpdateEnvCustomJobResponse updateEnvCustomJobResponse = this.aliPrometheusClient.updateEnvCustomJobWithOptions(updateEnvCustomJobRequest, runtime);
            log.info("AliPrometheusOperator.UpdateEnvCustomJob res :{}", (Object)updateEnvCustomJobResponse.toMap());
            return updateEnvCustomJobResponse;
        }
        catch (TeaException error) {
            log.error("AliPrometheusOperator.UpdateEnvCustomJob error ,message :{},recommend url :{}", (Object)error.getMessage(), error.getData().get("Recommend"));
            return null;
        }
        catch (Exception _error) {
            log.error("AliPrometheusOperator.UpdateEnvCustomJob error ,message :{}", (Object)_error.getMessage());
            return null;
        }
    }

    public DeleteEnvCustomJobResponse deleteEnvCustomJob(String environmentId, String jobName) {
        DeleteEnvCustomJobRequest deleteEnvCustomJobRequest = new DeleteEnvCustomJobRequest().setRegionId(DEFAULT_REGION_ID).setEnvironmentId(environmentId).setCustomJobName(jobName);
        log.info("AliPrometheusOperator.deleteEnvCustomJob req :{}", (Object)deleteEnvCustomJobRequest.toMap());
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            DeleteEnvCustomJobResponse deleteEnvCustomJobResponse = this.aliPrometheusClient.deleteEnvCustomJobWithOptions(deleteEnvCustomJobRequest, runtime);
            log.info("AliPrometheusOperator.deleteEnvCustomJob res :{}", (Object)deleteEnvCustomJobResponse.toMap());
            return deleteEnvCustomJobResponse;
        }
        catch (TeaException error) {
            log.error("AliPrometheusOperator.deleteEnvCustomJob error ,message :{},recommend url :{}", (Object)error.getMessage(), error.getData().get("Recommend"));
            return null;
        }
        catch (Exception _error) {
            log.error("AliPrometheusOperator.deleteEnvCustomJob error ,message :{}", (Object)_error.getMessage());
            return null;
        }
    }

    public CreateOrUpdateAlertRuleResponse CreateOrUpdateAlertRule(String alertStatus, String notifyStrategy, Rule rule, Float alertId) {
        try {
            CreateOrUpdateAlertRuleRequest createOrUpdateAlertRuleRequest = new CreateOrUpdateAlertRuleRequest().setRegionId(DEFAULT_REGION_ID).setAlertType(ALI_ALERT_DEFAULT_ALERT_TYPE).setAlertStatus(alertStatus).setAlertName(rule.getAlert()).setNotifyStrategy(notifyStrategy).setAlertCheckType(ALI_ALERT_DEFAULT_CHECK_TYPE).setClusterId(this.clusterId).setPromQL(rule.getExpr()).setDuration(Long.valueOf(0L)).setMessage(ALI_ALERT_DEFAULT_DATA_PUSH).setLevel("P2").setLabels(this.transLabel2String(rule.getLabels())).setAnnotations(this.transAnnotation2String(rule.getAnnotations()));
            if (alertId != null) {
                createOrUpdateAlertRuleRequest.setAlertId(Long.valueOf((long)alertId.floatValue()));
            }
            RuntimeOptions runtime = new RuntimeOptions();
            log.info("AliPrometheusOperator.CreateOrUpdateAlertRule req :{}", (Object)createOrUpdateAlertRuleRequest.toMap());
            CreateOrUpdateAlertRuleResponse orUpdateAlertRuleWithOptions = this.aliPrometheusClient.createOrUpdateAlertRuleWithOptions(createOrUpdateAlertRuleRequest, runtime);
            log.info("AliPrometheusOperator.CreateOrUpdateAlertRule res :{}", (Object)orUpdateAlertRuleWithOptions.toMap());
            return orUpdateAlertRuleWithOptions;
        }
        catch (TeaException error) {
            log.error("AliPrometheusOperator.CreateOrUpdateAlertRule error ,message :{},recommend url :{}", (Object)error.getMessage(), error.getData().get("Recommend"));
            return null;
        }
        catch (Exception _error) {
            log.error("AliPrometheusOperator.CreateOrUpdateAlertRule error ,message :{}", (Object)_error.getMessage());
            return null;
        }
    }

    public DeleteAlertRuleResponse DeleteAlertRule(Long alertId) {
        DeleteAlertRuleRequest deleteAlertRuleRequest = new DeleteAlertRuleRequest().setAlertId(alertId);
        RuntimeOptions runtime = new RuntimeOptions();
        log.info("AliPrometheusOperator.DeleteAlertRule req :{}", (Object)deleteAlertRuleRequest.toMap());
        try {
            DeleteAlertRuleResponse deleteAlertRuleResponse = this.aliPrometheusClient.deleteAlertRuleWithOptions(deleteAlertRuleRequest, runtime);
            log.info("AliPrometheusOperator.DeleteAlertRule res :{}", (Object)deleteAlertRuleResponse.toMap());
            return deleteAlertRuleResponse;
        }
        catch (TeaException error) {
            log.error("AliPrometheusOperator.DeleteAlertRule error ,message :{},recommend url :{}", (Object)error.getMessage(), error.getData().get("Recommend"));
            return null;
        }
        catch (Exception _error) {
            log.error("AliPrometheusOperator.DeleteAlertRule error ,message :{}", (Object)_error.getMessage());
            return null;
        }
    }

    public CreateOrUpdateWebhookContactResponse CreateOrUpdateWebhookContact() {
        CreateOrUpdateWebhookContactRequest createOrUpdateWebhookContactRequest = new CreateOrUpdateWebhookContactRequest().setWebhookName(ALI_ALERT_WEBHOOK_NAME).setMethod(this.webhookMethod).setUrl(this.webhookUrl).setBody(this.aliAlertMessage).setRecoverBody(ALI_ALERT_DEFAULT_DATA_PUSH).setBizHeaders("[{\"Content-Type\":\"application/json;charset=utf-8\"}]");
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            log.info("AliPrometheusOperator.CreateOrUpdateWebhookContact req :{}", (Object)createOrUpdateWebhookContactRequest.toMap());
            CreateOrUpdateWebhookContactResponse orUpdateWebhookContactWithOptions = this.aliPrometheusClient.createOrUpdateWebhookContactWithOptions(createOrUpdateWebhookContactRequest, runtime);
            log.info("AliPrometheusOperator.CreateOrUpdateWebhookContact res :{}", (Object)orUpdateWebhookContactWithOptions.toMap());
            return orUpdateWebhookContactWithOptions;
        }
        catch (TeaException error) {
            log.error("AliPrometheusOperator.CreateOrUpdateWebhookContact error ,message :{},recommend url :{}", (Object)error.getMessage(), error.getData().get("Recommend"));
            return null;
        }
        catch (Exception _error) {
            log.error("AliPrometheusOperator.CreateOrUpdateWebhookContact error ,message :{}", (Object)_error.getMessage());
            return null;
        }
    }

    public DescribeWebhookContactsResponse DescribeWebhookContacts() {
        DescribeWebhookContactsRequest describeWebhookContactsRequest = new DescribeWebhookContactsRequest().setWebhookName(ALI_ALERT_WEBHOOK_NAME).setPage(Long.valueOf(1L)).setSize(Long.valueOf(100L));
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            log.info("AliPrometheusOperator.DescribeWebhookContacts req :{}", (Object)describeWebhookContactsRequest.toMap());
            DescribeWebhookContactsResponse describeWebhookContactsResponse = this.aliPrometheusClient.describeWebhookContactsWithOptions(describeWebhookContactsRequest, runtime);
            log.info("AliPrometheusOperator.DescribeWebhookContacts res :{}", (Object)describeWebhookContactsResponse.toMap());
            return describeWebhookContactsResponse;
        }
        catch (TeaException error) {
            log.error("AliPrometheusOperator.DescribeWebhookContacts error ,message :{},recommend url :{}", (Object)error.getMessage(), error.getData().get("Recommend"));
            return null;
        }
        catch (Exception _error) {
            log.error("AliPrometheusOperator.DescribeWebhookContacts error ,message :{}", (Object)_error.getMessage());
            return null;
        }
    }

    public CreateOrUpdateNotificationPolicyResponse CreateOrUpdateNotificationPolicy(String notifyRule) {
        CreateOrUpdateNotificationPolicyRequest createOrUpdateNotificationPolicyRequest = new CreateOrUpdateNotificationPolicyRequest().setRegionId(DEFAULT_REGION_ID).setNotifyRule(notifyRule).setName(ALI_ALERT_DEFAULT_NOTIFY_STRATEGY).setRepeat(Boolean.valueOf(false)).setRepeatInterval(Long.valueOf(300L));
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            log.info("AliPrometheusOperator.CreateOrUpdateNotificationPolicy req :{}", (Object)createOrUpdateNotificationPolicyRequest.toMap());
            CreateOrUpdateNotificationPolicyResponse orUpdateNotificationPolicyWithOptions = this.aliPrometheusClient.createOrUpdateNotificationPolicyWithOptions(createOrUpdateNotificationPolicyRequest, runtime);
            log.info("AliPrometheusOperator.CreateOrUpdateNotificationPolicy res :{}", (Object)orUpdateNotificationPolicyWithOptions.toMap());
            return orUpdateNotificationPolicyWithOptions;
        }
        catch (TeaException error) {
            log.error("AliPrometheusOperator.CreateOrUpdateNotificationPolicy error ,message :{},recommend url :{}", (Object)error.getMessage(), error.getData().get("Recommend"));
            return null;
        }
        catch (Exception _error) {
            log.error("AliPrometheusOperator.CreateOrUpdateNotificationPolicy error ,message :{}", (Object)_error.getMessage());
            return null;
        }
    }

    public ListNotificationPoliciesResponse ListNotificationPolicies() {
        ListNotificationPoliciesRequest listNotificationPoliciesRequest = new ListNotificationPoliciesRequest().setRegionId(DEFAULT_REGION_ID).setName(ALI_ALERT_DEFAULT_NOTIFY_STRATEGY).setPage(Long.valueOf(1L)).setSize(Long.valueOf(100L));
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            log.info("AliPrometheusOperator.ListNotificationPolicies req :{}", (Object)listNotificationPoliciesRequest.toMap());
            ListNotificationPoliciesResponse listNotificationPoliciesResponse = this.aliPrometheusClient.listNotificationPoliciesWithOptions(listNotificationPoliciesRequest, runtime);
            log.info("AliPrometheusOperator.ListNotificationPolicies res :{}", (Object)listNotificationPoliciesResponse.toMap());
            return listNotificationPoliciesResponse;
        }
        catch (TeaException error) {
            log.error("AliPrometheusOperator.ListNotificationPolicies error ,message :{},recommend url :{}", (Object)error.getMessage(), error.getData().get("Recommend"));
            return null;
        }
        catch (Exception _error) {
            log.error("AliPrometheusOperator.ListNotificationPolicies error ,message :{}", (Object)_error.getMessage());
            return null;
        }
    }

    public GetAlertRulesResponse GetAlertRules(String alertName) {
        GetAlertRulesRequest getAlertRulesRequest = new GetAlertRulesRequest().setRegionId(DEFAULT_REGION_ID).setAlertType(ALI_ALERT_DEFAULT_ALERT_TYPE).setClusterId(this.clusterId).setPage(Long.valueOf(1L)).setSize(Long.valueOf(1000000L)).setAlertStatus(ALI_ALERT_RUN_STATUS);
        if (StringUtils.isNotBlank((CharSequence)alertName)) {
            getAlertRulesRequest.setAlertNames("[\"" + alertName + "\"]");
        }
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            log.info("AliPrometheusOperator.GetAlertRules req :{}", (Object)getAlertRulesRequest.toMap());
            GetAlertRulesResponse alertRulesWithOptions = this.aliPrometheusClient.getAlertRulesWithOptions(getAlertRulesRequest, runtime);
            log.info("AliPrometheusOperator.GetAlertRules res :{}", (Object)alertRulesWithOptions.toMap());
            return alertRulesWithOptions;
        }
        catch (TeaException error) {
            log.error("AliPrometheusOperator.GetAlertRules error ,message :{},recommend url :{}", (Object)error.getMessage(), error.getData().get("Recommend"));
            return null;
        }
        catch (Exception _error) {
            log.error("AliPrometheusOperator.GetAlertRules error ,message :{}", (Object)_error.getMessage());
            return null;
        }
    }

    @Override
    public String printTriplicities() {
        return "Alibaba";
    }

    private String transLabel2String(Map<String, String> labels) {
        ArrayList<AliLabel> labelList = new ArrayList<AliLabel>();
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            AliLabel label = new AliLabel();
            if (!ALI_ALERT_LABELS_KEYS.contains(entry.getKey())) continue;
            label.setName(entry.getKey());
            label.setValue(entry.getValue());
            labelList.add(label);
        }
        return this.gson.toJson(labelList);
    }

    private String transAnnotation2String(Map<String, String> annotations) {
        ArrayList<AliLabel> labelList = new ArrayList<AliLabel>();
        for (Map.Entry<String, String> entry : annotations.entrySet()) {
            AliLabel label = new AliLabel();
            label.setName(entry.getKey());
            label.setValue(entry.getValue());
            labelList.add(label);
        }
        return this.gson.toJson(labelList);
    }
}

