/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kms.model.GrantConstraints;
import software.amazon.awssdk.services.kms.model.GrantOperation;
import software.amazon.awssdk.services.kms.model.GrantOperationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GrantListEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GrantListEntry> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(GrantListEntry.getter(GrantListEntry::keyId)).setter(GrantListEntry.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<String> GRANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantId").getter(GrantListEntry.getter(GrantListEntry::grantId)).setter(GrantListEntry.setter(Builder::grantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GrantListEntry.getter(GrantListEntry::name)).setter(GrantListEntry.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(GrantListEntry.getter(GrantListEntry::creationDate)).setter(GrantListEntry.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> GRANTEE_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GranteePrincipal").getter(GrantListEntry.getter(GrantListEntry::granteePrincipal)).setter(GrantListEntry.setter(Builder::granteePrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranteePrincipal").build()}).build();
    private static final SdkField<String> RETIRING_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RetiringPrincipal").getter(GrantListEntry.getter(GrantListEntry::retiringPrincipal)).setter(GrantListEntry.setter(Builder::retiringPrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetiringPrincipal").build()}).build();
    private static final SdkField<String> ISSUING_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IssuingAccount").getter(GrantListEntry.getter(GrantListEntry::issuingAccount)).setter(GrantListEntry.setter(Builder::issuingAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuingAccount").build()}).build();
    private static final SdkField<List<String>> OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Operations").getter(GrantListEntry.getter(GrantListEntry::operationsAsStrings)).setter(GrantListEntry.setter(Builder::operationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GrantConstraints> CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Constraints").getter(GrantListEntry.getter(GrantListEntry::constraints)).setter(GrantListEntry.setter(Builder::constraints)).constructor(GrantConstraints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constraints").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, GRANT_ID_FIELD, NAME_FIELD, CREATION_DATE_FIELD, GRANTEE_PRINCIPAL_FIELD, RETIRING_PRINCIPAL_FIELD, ISSUING_ACCOUNT_FIELD, OPERATIONS_FIELD, CONSTRAINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GrantListEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String keyId;
    private final String grantId;
    private final String name;
    private final Instant creationDate;
    private final String granteePrincipal;
    private final String retiringPrincipal;
    private final String issuingAccount;
    private final List<String> operations;
    private final GrantConstraints constraints;

    private GrantListEntry(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.grantId = builder.grantId;
        this.name = builder.name;
        this.creationDate = builder.creationDate;
        this.granteePrincipal = builder.granteePrincipal;
        this.retiringPrincipal = builder.retiringPrincipal;
        this.issuingAccount = builder.issuingAccount;
        this.operations = builder.operations;
        this.constraints = builder.constraints;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final String grantId() {
        return this.grantId;
    }

    public final String name() {
        return this.name;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String granteePrincipal() {
        return this.granteePrincipal;
    }

    public final String retiringPrincipal() {
        return this.retiringPrincipal;
    }

    public final String issuingAccount() {
        return this.issuingAccount;
    }

    public final List<GrantOperation> operations() {
        return GrantOperationListCopier.copyStringToEnum(this.operations);
    }

    public final boolean hasOperations() {
        return this.operations != null && !(this.operations instanceof SdkAutoConstructList);
    }

    public final List<String> operationsAsStrings() {
        return this.operations;
    }

    public final GrantConstraints constraints() {
        return this.constraints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.granteePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.retiringPrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuingAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperations() ? this.operationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.constraints());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantListEntry)) {
            return false;
        }
        GrantListEntry other = (GrantListEntry)obj;
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.grantId(), other.grantId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.granteePrincipal(), other.granteePrincipal()) && Objects.equals(this.retiringPrincipal(), other.retiringPrincipal()) && Objects.equals(this.issuingAccount(), other.issuingAccount()) && this.hasOperations() == other.hasOperations() && Objects.equals(this.operationsAsStrings(), other.operationsAsStrings()) && Objects.equals(this.constraints(), other.constraints());
    }

    public final String toString() {
        return ToString.builder((String)"GrantListEntry").add("KeyId", (Object)this.keyId()).add("GrantId", (Object)this.grantId()).add("Name", (Object)this.name()).add("CreationDate", (Object)this.creationDate()).add("GranteePrincipal", (Object)this.granteePrincipal()).add("RetiringPrincipal", (Object)this.retiringPrincipal()).add("IssuingAccount", (Object)this.issuingAccount()).add("Operations", this.hasOperations() ? this.operationsAsStrings() : null).add("Constraints", (Object)this.constraints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "GrantId": {
                return Optional.ofNullable(clazz.cast(this.grantId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "GranteePrincipal": {
                return Optional.ofNullable(clazz.cast(this.granteePrincipal()));
            }
            case "RetiringPrincipal": {
                return Optional.ofNullable(clazz.cast(this.retiringPrincipal()));
            }
            case "IssuingAccount": {
                return Optional.ofNullable(clazz.cast(this.issuingAccount()));
            }
            case "Operations": {
                return Optional.ofNullable(clazz.cast(this.operationsAsStrings()));
            }
            case "Constraints": {
                return Optional.ofNullable(clazz.cast(this.constraints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyId", KEY_ID_FIELD);
        map.put("GrantId", GRANT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("GranteePrincipal", GRANTEE_PRINCIPAL_FIELD);
        map.put("RetiringPrincipal", RETIRING_PRINCIPAL_FIELD);
        map.put("IssuingAccount", ISSUING_ACCOUNT_FIELD);
        map.put("Operations", OPERATIONS_FIELD);
        map.put("Constraints", CONSTRAINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GrantListEntry, T> g) {
        return obj -> g.apply((GrantListEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyId;
        private String grantId;
        private String name;
        private Instant creationDate;
        private String granteePrincipal;
        private String retiringPrincipal;
        private String issuingAccount;
        private List<String> operations = DefaultSdkAutoConstructList.getInstance();
        private GrantConstraints constraints;

        private BuilderImpl() {
        }

        private BuilderImpl(GrantListEntry model) {
            this.keyId(model.keyId);
            this.grantId(model.grantId);
            this.name(model.name);
            this.creationDate(model.creationDate);
            this.granteePrincipal(model.granteePrincipal);
            this.retiringPrincipal(model.retiringPrincipal);
            this.issuingAccount(model.issuingAccount);
            this.operationsWithStrings(model.operations);
            this.constraints(model.constraints);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getGrantId() {
            return this.grantId;
        }

        public final void setGrantId(String grantId) {
            this.grantId = grantId;
        }

        @Override
        public final Builder grantId(String grantId) {
            this.grantId = grantId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getGranteePrincipal() {
            return this.granteePrincipal;
        }

        public final void setGranteePrincipal(String granteePrincipal) {
            this.granteePrincipal = granteePrincipal;
        }

        @Override
        public final Builder granteePrincipal(String granteePrincipal) {
            this.granteePrincipal = granteePrincipal;
            return this;
        }

        public final String getRetiringPrincipal() {
            return this.retiringPrincipal;
        }

        public final void setRetiringPrincipal(String retiringPrincipal) {
            this.retiringPrincipal = retiringPrincipal;
        }

        @Override
        public final Builder retiringPrincipal(String retiringPrincipal) {
            this.retiringPrincipal = retiringPrincipal;
            return this;
        }

        public final String getIssuingAccount() {
            return this.issuingAccount;
        }

        public final void setIssuingAccount(String issuingAccount) {
            this.issuingAccount = issuingAccount;
        }

        @Override
        public final Builder issuingAccount(String issuingAccount) {
            this.issuingAccount = issuingAccount;
            return this;
        }

        public final Collection<String> getOperations() {
            if (this.operations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.operations;
        }

        public final void setOperations(Collection<String> operations) {
            this.operations = GrantOperationListCopier.copy(operations);
        }

        @Override
        public final Builder operationsWithStrings(Collection<String> operations) {
            this.operations = GrantOperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationsWithStrings(String ... operations) {
            this.operationsWithStrings(Arrays.asList(operations));
            return this;
        }

        @Override
        public final Builder operations(Collection<GrantOperation> operations) {
            this.operations = GrantOperationListCopier.copyEnumToString(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(GrantOperation ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        public final GrantConstraints.Builder getConstraints() {
            return this.constraints != null ? this.constraints.toBuilder() : null;
        }

        public final void setConstraints(GrantConstraints.BuilderImpl constraints) {
            this.constraints = constraints != null ? constraints.build() : null;
        }

        @Override
        public final Builder constraints(GrantConstraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public GrantListEntry build() {
            return new GrantListEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GrantListEntry> {
        public Builder keyId(String var1);

        public Builder grantId(String var1);

        public Builder name(String var1);

        public Builder creationDate(Instant var1);

        public Builder granteePrincipal(String var1);

        public Builder retiringPrincipal(String var1);

        public Builder issuingAccount(String var1);

        public Builder operationsWithStrings(Collection<String> var1);

        public Builder operationsWithStrings(String ... var1);

        public Builder operations(Collection<GrantOperation> var1);

        public Builder operations(GrantOperation ... var1);

        public Builder constraints(GrantConstraints var1);

        default public Builder constraints(Consumer<GrantConstraints.Builder> constraints) {
            return this.constraints((GrantConstraints)((GrantConstraints.Builder)GrantConstraints.builder().applyMutation(constraints)).build());
        }
    }
}

