/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.iceberg;

import jakarta.annotation.Priority;
import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.iceberg.rest.responses.ConfigResponse;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.catalog.api.IcebergRestConfigurationApiService;
import org.apache.polaris.service.catalog.iceberg.IcebergCatalogAdapter;
import org.apache.polaris.service.events.IcebergRestCatalogEvents;
import org.apache.polaris.service.events.listeners.PolarisEventListener;

@Decorator
@Priority(value=1000)
public class IcebergRestConfigurationEventServiceDelegator
implements IcebergRestConfigurationApiService {
    @Inject
    @Delegate
    IcebergCatalogAdapter delegate;
    @Inject
    PolarisEventListener polarisEventListener;

    public Response getConfig(String warehouse, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeGetConfig(new IcebergRestCatalogEvents.BeforeGetConfigEvent(warehouse));
        Response resp = this.delegate.getConfig(warehouse, realmContext, securityContext);
        this.polarisEventListener.onAfterGetConfig(new IcebergRestCatalogEvents.AfterGetConfigEvent((ConfigResponse)resp.readEntity(ConfigResponse.class)));
        return resp;
    }
}

