/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.seata.common.store.SessionMode;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.UUIDGenerator;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.server.cluster.raft.context.SeataClusterContext;
import org.apache.seata.server.coordinator.DefaultCoordinator;
import org.apache.seata.server.metrics.MetricsPublisher;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.BranchSessionHandler;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.GlobalSessionHandler;
import org.apache.seata.server.session.SessionHelper;
import org.apache.seata.server.session.SessionStatusValidator;
import org.apache.seata.server.store.StoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

/*
 * Exception performing whole class analysis ignored.
 */
public class SessionHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionHelper.class);
    private static final Configuration CONFIG = ConfigurationFactory.getInstance();
    private static final Boolean ENABLE_BRANCH_ASYNC_REMOVE = CONFIG.getBoolean("server.session.enableBranchAsyncRemove", false);
    private static final String GROUP = CONFIG.getConfig("server.raft.group", "default");
    private static final DefaultCoordinator COORDINATOR = DefaultCoordinator.getInstance();
    private static final boolean DELAY_HANDLE_SESSION = !Objects.equals(StoreConfig.getSessionMode(), SessionMode.FILE) && !Objects.equals(StoreConfig.getSessionMode(), SessionMode.RAFT);

    private SessionHelper() {
    }

    public static BranchSession newBranchByGlobal(GlobalSession globalSession, BranchType branchType, String resourceId, String lockKeys, String clientId) {
        return SessionHelper.newBranchByGlobal((GlobalSession)globalSession, (BranchType)branchType, (String)resourceId, null, (String)lockKeys, (String)clientId);
    }

    public static BranchSession newBranchByGlobal(GlobalSession globalSession, BranchType branchType, String resourceId, String applicationData, String lockKeys, String clientId) {
        BranchSession branchSession = new BranchSession(branchType);
        branchSession.setXid(globalSession.getXid());
        branchSession.setTransactionId(globalSession.getTransactionId());
        branchSession.setBranchId(UUIDGenerator.generateUUID());
        branchSession.setResourceId(resourceId);
        branchSession.setLockKey(lockKeys);
        branchSession.setClientId(clientId);
        branchSession.setApplicationData(applicationData);
        branchSession.setStatus(BranchStatus.Registered);
        return branchSession;
    }

    public static BranchSession newBranch(BranchType branchType, String xid, long branchId, String resourceId, String applicationData) {
        BranchSession branchSession = new BranchSession();
        branchSession.setXid(xid);
        branchSession.setBranchId(branchId);
        branchSession.setBranchType(branchType);
        branchSession.setResourceId(resourceId);
        branchSession.setApplicationData(applicationData);
        return branchSession;
    }

    public static void endCommitted(GlobalSession globalSession, boolean retryGlobal) throws TransactionException {
        if (retryGlobal || !DELAY_HANDLE_SESSION) {
            boolean retryBranch;
            long beginTime = System.currentTimeMillis();
            boolean bl = retryBranch = globalSession.getStatus() == GlobalStatus.CommitRetrying;
            if (!globalSession.getStatus().equals((Object)GlobalStatus.Committed)) {
                globalSession.changeGlobalStatus(GlobalStatus.Committed);
            }
            globalSession.end();
            if (!DELAY_HANDLE_SESSION) {
                MetricsPublisher.postSessionDoneEvent((GlobalSession)globalSession, (boolean)retryGlobal, (boolean)false);
            }
            MetricsPublisher.postSessionDoneEvent((GlobalSession)globalSession, (String)"AfterCommitted", (boolean)true, (long)beginTime, (boolean)retryBranch);
        } else {
            globalSession.setStatus(GlobalStatus.Committed);
            if (globalSession.isSaga()) {
                globalSession.end();
            }
            MetricsPublisher.postSessionDoneEvent((GlobalSession)globalSession, (boolean)false, (boolean)false);
        }
    }

    public static void endCommitFailed(GlobalSession globalSession, boolean retryGlobal) throws TransactionException {
        SessionHelper.endCommitFailed((GlobalSession)globalSession, (boolean)retryGlobal, (boolean)false);
    }

    public static void endCommitFailed(GlobalSession globalSession, boolean retryGlobal, boolean isRetryTimeout) throws TransactionException {
        if (isRetryTimeout) {
            globalSession.changeGlobalStatus(GlobalStatus.CommitRetryTimeout);
        } else {
            globalSession.changeGlobalStatus(GlobalStatus.CommitFailed);
        }
        LOGGER.error("The Global session {} has changed the status to {}, need to be handled it manually.", (Object)globalSession.getXid(), (Object)globalSession.getStatus());
        globalSession.end();
        MetricsPublisher.postSessionDoneEvent((GlobalSession)globalSession, (boolean)retryGlobal, (boolean)false);
    }

    public static void endRollbacked(GlobalSession globalSession, boolean retryGlobal) throws TransactionException {
        if (retryGlobal || !DELAY_HANDLE_SESSION) {
            boolean retryBranch;
            long beginTime = System.currentTimeMillis();
            boolean timeoutDone = false;
            GlobalStatus currentStatus = globalSession.getStatus();
            if (currentStatus == GlobalStatus.TimeoutRollbacking) {
                MetricsPublisher.postSessionDoneEvent((GlobalSession)globalSession, (GlobalStatus)GlobalStatus.TimeoutRollbacked, (boolean)false, (boolean)false);
                timeoutDone = true;
            }
            boolean bl = retryBranch = currentStatus == GlobalStatus.TimeoutRollbackRetrying || currentStatus == GlobalStatus.RollbackRetrying;
            if (!currentStatus.equals((Object)GlobalStatus.TimeoutRollbacked) && SessionStatusValidator.isTimeoutRollbacking((GlobalStatus)currentStatus)) {
                globalSession.changeGlobalStatus(GlobalStatus.TimeoutRollbacked);
            } else if (!globalSession.getStatus().equals((Object)GlobalStatus.Rollbacked)) {
                globalSession.changeGlobalStatus(GlobalStatus.Rollbacked);
            }
            globalSession.end();
            if (!DELAY_HANDLE_SESSION && !timeoutDone) {
                MetricsPublisher.postSessionDoneEvent((GlobalSession)globalSession, (boolean)retryGlobal, (boolean)false);
            }
            MetricsPublisher.postSessionDoneEvent((GlobalSession)globalSession, (String)"AfterRollbacked", (boolean)true, (long)beginTime, (boolean)retryBranch);
        } else {
            if (globalSession.isSaga()) {
                globalSession.setStatus(GlobalStatus.Rollbacked);
                globalSession.end();
            }
            MetricsPublisher.postSessionDoneEvent((GlobalSession)globalSession, (GlobalStatus)GlobalStatus.Rollbacked, (boolean)false, (boolean)false);
        }
    }

    public static void endRollbackFailed(GlobalSession globalSession, boolean retryGlobal) throws TransactionException {
        SessionHelper.endRollbackFailed((GlobalSession)globalSession, (boolean)retryGlobal, (boolean)false);
    }

    public static void endRollbackFailed(GlobalSession globalSession, boolean retryGlobal, boolean isRetryTimeout) throws TransactionException {
        GlobalStatus currentStatus = globalSession.getStatus();
        if (isRetryTimeout) {
            globalSession.changeGlobalStatus(GlobalStatus.RollbackRetryTimeout);
        } else if (SessionStatusValidator.isTimeoutRollbacking((GlobalStatus)currentStatus)) {
            globalSession.changeGlobalStatus(GlobalStatus.TimeoutRollbackFailed);
        } else {
            globalSession.changeGlobalStatus(GlobalStatus.RollbackFailed);
        }
        LOGGER.error("The Global session {} has changed the status to {}, need to be handled it manually.", (Object)globalSession.getXid(), (Object)globalSession.getStatus());
        globalSession.end();
        MetricsPublisher.postSessionDoneEvent((GlobalSession)globalSession, (boolean)retryGlobal, (boolean)false);
    }

    public static void parallelForEach(Collection<GlobalSession> sessions, GlobalSessionHandler handler) {
        SessionHelper.forEach(sessions, (GlobalSessionHandler)handler, (boolean)true);
    }

    public static void singleForEach(Collection<GlobalSession> sessions, GlobalSessionHandler handler) {
        SessionHelper.forEach(sessions, (GlobalSessionHandler)handler, (boolean)false);
    }

    public static void forEach(Collection<GlobalSession> sessions, GlobalSessionHandler handler, boolean parallel) {
        if (CollectionUtils.isEmpty(sessions)) {
            return;
        }
        Stream<GlobalSession> stream = StreamSupport.stream(sessions.spliterator(), parallel);
        stream.forEach(globalSession -> {
            SeataClusterContext.bindGroup((String)GROUP);
            try {
                MDC.put((String)"X-TX-XID", (String)globalSession.getXid());
                handler.handle(globalSession);
            }
            catch (Throwable th) {
                LOGGER.error("handle global session failed: {}", (Object)globalSession.getXid(), (Object)th);
            }
            finally {
                SeataClusterContext.unbindGroup();
                MDC.remove((String)"X-TX-XID");
            }
        });
    }

    public static void forEach(Collection<GlobalSession> sessions, GlobalSessionHandler handler) {
        SessionHelper.forEach(sessions, (GlobalSessionHandler)handler, (boolean)true);
    }

    public static Boolean forEach(Collection<BranchSession> sessions, BranchSessionHandler handler) throws TransactionException {
        return SessionHelper.forEach(sessions, (BranchSessionHandler)handler, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean forEach(Collection<BranchSession> sessions, BranchSessionHandler handler, boolean parallel) throws TransactionException {
        if (CollectionUtils.isNotEmpty(sessions)) {
            if (parallel) {
                HashMap<String, List> map = new HashMap<String, List>(4);
                for (BranchSession branchSession : sessions) {
                    map.computeIfAbsent(branchSession.getResourceId(), k -> new ArrayList()).add(branchSession);
                }
                ArrayList completableFutures = new ArrayList(map.size());
                map.forEach((k, v) -> completableFutures.add(CompletableFuture.supplyAsync(() -> {
                    try {
                        return SessionHelper.forEach((Collection)v, (BranchSessionHandler)handler, (boolean)false);
                    }
                    catch (TransactionException e) {
                        throw new RuntimeException(e);
                    }
                })));
                try {
                    for (CompletableFuture completableFuture : completableFutures) {
                        Boolean result = (Boolean)completableFuture.get();
                        if (result == null) continue;
                        return result;
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new TransactionException((Throwable)interruptedException);
                }
                catch (ExecutionException bl) {
                    Throwable cause;
                    Throwable throwable = bl.getCause();
                    if (throwable instanceof RuntimeException && (cause = throwable.getCause()) instanceof TransactionException) {
                        throw (TransactionException)cause;
                    }
                    throw new TransactionException((Throwable)bl);
                }
            } else {
                for (BranchSession branchSession : sessions) {
                    try {
                        MDC.put((String)"X-TX-BRANCH-ID", (String)String.valueOf(branchSession.getBranchId()));
                        Boolean result = handler.handle(branchSession);
                        if (result == null) continue;
                        Boolean bl = result;
                        return bl;
                    }
                    finally {
                        MDC.remove((String)"X-TX-BRANCH-ID");
                    }
                }
            }
        }
        return null;
    }

    public static Boolean singleForEach(Collection<BranchSession> sessions, BranchSessionHandler handler) throws TransactionException {
        return SessionHelper.forEach(sessions, (BranchSessionHandler)handler, (boolean)false);
    }

    public static Boolean parallelForEach(Collection<BranchSession> sessions, BranchSessionHandler handler) throws TransactionException {
        return SessionHelper.forEach(sessions, (BranchSessionHandler)handler, (boolean)true);
    }

    public static void removeBranch(GlobalSession globalSession, BranchSession branchSession, boolean isAsync) throws TransactionException {
        globalSession.unlockBranch(branchSession);
        if (SessionHelper.isEnableBranchRemoveAsync() && isAsync) {
            COORDINATOR.doBranchRemoveAsync(globalSession, branchSession);
        } else {
            globalSession.removeBranch(branchSession);
        }
    }

    public static void removeAllBranch(GlobalSession globalSession, boolean isAsync) throws TransactionException {
        List branchSessions = globalSession.getSortedBranches();
        if (branchSessions == null || branchSessions.isEmpty()) {
            return;
        }
        boolean isAsyncRemove = SessionHelper.isEnableBranchRemoveAsync() && isAsync;
        for (BranchSession branchSession : branchSessions) {
            if (isAsyncRemove) {
                globalSession.unlockBranch(branchSession);
                continue;
            }
            globalSession.removeAndUnlockBranch(branchSession);
        }
        if (isAsyncRemove) {
            COORDINATOR.doBranchRemoveAllAsync(globalSession);
        }
    }

    public static void processEndState(GlobalSession globalSession) throws TransactionException {
        GlobalStatus globalStatus = globalSession.getStatus();
        switch (1.$SwitchMap$org$apache$seata$core$model$GlobalStatus[globalStatus.ordinal()]) {
            case 1: 
            case 2: {
                SessionHelper.endCommitted((GlobalSession)globalSession, (boolean)true);
                return;
            }
            case 3: 
            case 4: {
                SessionHelper.endRollbacked((GlobalSession)globalSession, (boolean)true);
                return;
            }
        }
        throw new TransactionException("Unsupported GlobalStatus:" + globalStatus);
    }

    private static boolean isEnableBranchRemoveAsync() {
        return Objects.equals(Boolean.TRUE, DELAY_HANDLE_SESSION) && Objects.equals(Boolean.TRUE, ENABLE_BRANCH_ASYNC_REMOVE);
    }
}

