/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.mcp.core.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class TimestampToStringDeserializer
extends JsonDeserializer<String> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public String deserialize(JsonParser p, DeserializationContext cxt) throws IOException {
        long timestamp = p.getLongValue();
        LocalDateTime dateTime = Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault()).toLocalDateTime();
        return dateTime.format(FORMATTER);
    }
}

