/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.mcp.core.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class UrlUtils {
    private static final Logger logger = LoggerFactory.getLogger(UrlUtils.class);

    public static String buildUrl(String baseUrl, String path, Map<String, String> queryStringParams, Map<String, Object> queryObjectParams) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)baseUrl).path(path);
        if (queryStringParams != null && !queryStringParams.isEmpty()) {
            for (Map.Entry<String, Object> entry : queryStringParams.entrySet()) {
                builder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        if (queryObjectParams != null && !queryObjectParams.isEmpty()) {
            for (Map.Entry<String, Object> entry : queryObjectParams.entrySet()) {
                if (entry.getValue() instanceof Iterable) {
                    for (Object value : (Iterable)entry.getValue()) {
                        builder.queryParam(entry.getKey(), new Object[]{value});
                    }
                    continue;
                }
                if (entry.getValue() != null && entry.getValue().getClass().isArray()) {
                    Object[] array;
                    for (Object value : array = (Object[])entry.getValue()) {
                        builder.queryParam(entry.getKey(), new Object[]{value});
                    }
                    continue;
                }
                builder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        return builder.build().toUriString();
    }

    public static Map<String, Object> objectToQueryParamMap(Object obj, ObjectMapper objectMapper) {
        if (obj == null) {
            return Collections.emptyMap();
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            HashMap<String, Object> result = new HashMap<String, Object>(map.size());
            map.forEach((k, v) -> {
                if (k != null && v != null) {
                    result.put(k.toString(), v);
                }
            });
            return result;
        }
        try {
            return (Map)objectMapper.convertValue(obj, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IllegalArgumentException e) {
            logger.warn("Failed to convert object to map: {}", (Object)e.getMessage());
            return Collections.emptyMap();
        }
    }
}

