/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.util.ReflectUtil$ReflectException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;

public final class ReflectUtil {
    public static final Class[] EMPTY_PARAMETER_TYPES = new Class[0];
    public static final Object[] EMPTY_ARGUMENTS = new Object[0];
    private static HashMap descriptorsCache = new HashMap();

    public static boolean isInterface(Class clazz) {
        int n2 = clazz.getModifiers();
        return Modifier.isInterface(n2);
    }

    public static boolean isAbstract(Class clazz) {
        int n2 = clazz.getModifiers();
        return Modifier.isAbstract(n2);
    }

    public static boolean isAbstractOrInterface(Class clazz) {
        int n2 = clazz.getModifiers();
        return Modifier.isAbstract(n2) || Modifier.isInterface(n2);
    }

    public static Class[] getAllInterfaces(Class clazz) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Class clazz2 = clazz;
        do {
            Class<?>[] classArray = clazz2.getInterfaces();
            linkedHashSet.addAll(Arrays.asList(classArray));
        } while ((clazz2 = clazz2.getSuperclass()) != null);
        return linkedHashSet.toArray(new Class[linkedHashSet.size()]);
    }

    public static Object newInstance(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return ReflectUtil.newInstance(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectUtil$ReflectException(classNotFoundException);
        }
    }

    public static Object newInstance(String string, ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClass(string);
            return ReflectUtil.newInstance(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectUtil$ReflectException(classNotFoundException);
        }
    }

    public static Object newInstance(String string, ClassLoader[] classLoaderArray) {
        ClassNotFoundException classNotFoundException = null;
        Class<?> clazz = null;
        ClassLoader[] classLoaderArray2 = classLoaderArray;
        int n2 = classLoaderArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ClassLoader classLoader = classLoaderArray2[n3];
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                classNotFoundException = classNotFoundException2;
            }
            ++n3;
        }
        if (clazz == null) {
            throw new ReflectUtil$ReflectException(classNotFoundException != null ? classNotFoundException : new ClassNotFoundException(string));
        }
        return ReflectUtil.newInstance(clazz);
    }

    public static Object newInstance(String string, Class[] classArray, Object[] objectArray) {
        try {
            Class<?> clazz = Class.forName(string);
            return ReflectUtil.newInstance(clazz, classArray, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectUtil$ReflectException(classNotFoundException);
        }
    }

    public static Object newInstance(String string, Class[] classArray, Object[] objectArray, ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClass(string);
            return ReflectUtil.newInstance(clazz, classArray, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectUtil$ReflectException(classNotFoundException);
        }
    }

    public static Object newInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectUtil$ReflectException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectUtil$ReflectException(illegalAccessException);
        }
    }

    public static Object newInstance(Class clazz, Class[] classArray, Object[] objectArray) {
        try {
            Constructor constructor = clazz.getConstructor(classArray);
            constructor.setAccessible(true);
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new ReflectUtil$ReflectException(exception);
        }
    }

    public static Object getStaticFieldValue(String string, String string2) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectUtil$ReflectException(classNotFoundException);
        }
        return ReflectUtil.getStaticFieldValue(clazz, string2);
    }

    public static Object getStaticFieldValue(Class clazz, String string) {
        Field field = ReflectUtil.getField(clazz, string);
        if (field == null) {
            return null;
        }
        field.setAccessible(true);
        Object object = null;
        try {
            object = field.get(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectUtil$ReflectException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectUtil$ReflectException(illegalAccessException);
        }
        return object;
    }

    public static Object getFieldValue(Object object, String string) {
        Field field = ReflectUtil.getField(object.getClass(), string);
        if (field == null) {
            return null;
        }
        field.setAccessible(true);
        Object object2 = null;
        try {
            object2 = field.get(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectUtil$ReflectException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectUtil$ReflectException(illegalAccessException);
        }
        return object2;
    }

    public static void setFieldValue(Object object, String string, Object object2) {
        Field field = ReflectUtil.getField(object.getClass(), string);
        if (field == null) {
            return;
        }
        field.setAccessible(true);
        try {
            field.set(object, object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectUtil$ReflectException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectUtil$ReflectException(illegalAccessException);
        }
    }

    public static void setStaticFieldValue(Class clazz, String string, Object object) {
        Field field = ReflectUtil.getField(clazz, string);
        if (field == null) {
            return;
        }
        field.setAccessible(true);
        try {
            field.set(null, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectUtil$ReflectException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectUtil$ReflectException(illegalAccessException);
        }
    }

    public static Field getField(Class clazz, String string) {
        if (clazz == null) {
            return null;
        }
        Field field = null;
        try {
            field = clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            field = ReflectUtil.getField(clazz.getSuperclass(), string);
        }
        return field;
    }

    public static Field getField(String string, String string2) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectUtil$ReflectException(classNotFoundException);
        }
        return ReflectUtil.getField(clazz, string2);
    }

    public static Method getMethod(String string, String string2) {
        return ReflectUtil.getMethod(string, string2, EMPTY_PARAMETER_TYPES);
    }

    public static Method getMethod(String string, String string2, Class[] classArray) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectUtil$ReflectException(classNotFoundException);
        }
        return ReflectUtil.getMethod(clazz, string2, classArray);
    }

    public static Method getMethod(Class clazz, String string) {
        return ReflectUtil.getMethod(clazz, string, EMPTY_PARAMETER_TYPES);
    }

    public static Method getMethod(Class clazz, String string, Class[] classArray) {
        if (clazz == null) {
            return null;
        }
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = ReflectUtil.getMethod(clazz.getSuperclass(), string, classArray);
        }
        return method;
    }

    public static Object executeMethod(Object object, String string) {
        return ReflectUtil.executeMethod(object, string, EMPTY_PARAMETER_TYPES, EMPTY_ARGUMENTS);
    }

    public static Object executeMethod(Object object, String string, Class[] classArray, Object[] objectArray) {
        Method method = ReflectUtil.getMethod(object.getClass(), string, classArray);
        if (method == null) {
            return null;
        }
        return ReflectUtil.executeMethod(method, object, objectArray);
    }

    public static Object executeMethod(Method method) {
        return ReflectUtil.executeMethod(method, null, EMPTY_ARGUMENTS);
    }

    public static Object executeMethod(Method method, Object[] objectArray) {
        return ReflectUtil.executeMethod(method, null, objectArray);
    }

    public static Object executeMethod(Method method, Object object) {
        return ReflectUtil.executeMethod(method, object, EMPTY_ARGUMENTS);
    }

    public static Object executeMethod(Method method, Object object, Object[] objectArray) {
        if (method == null) {
            return null;
        }
        Object object2 = null;
        method.setAccessible(true);
        try {
            object2 = method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectUtil$ReflectException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectUtil$ReflectException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectUtil$ReflectException(invocationTargetException.getCause());
        }
        return object2;
    }

    public static Object getPropertyValue(Object object, String string) {
        if (object == null) {
            throw new ReflectUtil$ReflectException("No bean specified");
        }
        if (string == null) {
            throw new ReflectUtil$ReflectException("No name specified");
        }
        PropertyDescriptor propertyDescriptor = ReflectUtil.getPropertyDescriptor(object, string);
        if (propertyDescriptor == null) {
            throw new ReflectUtil$ReflectException("Unknown property '" + string + "'");
        }
        return ReflectUtil.executeMethod(propertyDescriptor.getReadMethod(), object, EMPTY_ARGUMENTS);
    }

    public static void setPropertyValue(Object object, String string, Object object2) {
        if (object == null) {
            throw new ReflectUtil$ReflectException("No bean specified");
        }
        if (string == null) {
            throw new ReflectUtil$ReflectException("No name specified");
        }
        PropertyDescriptor propertyDescriptor = ReflectUtil.getPropertyDescriptor(object, string);
        if (propertyDescriptor == null) {
            throw new ReflectUtil$ReflectException("Unknown property '" + string + "'");
        }
        Object[] objectArray = new Object[]{object2};
        ReflectUtil.executeMethod(propertyDescriptor.getWriteMethod(), object, objectArray);
    }

    public static PropertyDescriptor getPropertyDescriptor(Object object, String string) {
        if (object == null) {
            throw new ReflectUtil$ReflectException("No bean specified");
        }
        if (string == null) {
            throw new ReflectUtil$ReflectException("No name specified");
        }
        PropertyDescriptor[] propertyDescriptorArray = ReflectUtil.getPropertyDescriptors(object.getClass());
        if (propertyDescriptorArray != null) {
            PropertyDescriptor[] propertyDescriptorArray2 = propertyDescriptorArray;
            int n2 = propertyDescriptorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray2[n3];
                if (string.equals(propertyDescriptor.getName())) {
                    return propertyDescriptor;
                }
                ++n3;
            }
        }
        return null;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class clazz) {
        PropertyDescriptor[] propertyDescriptorArray = (PropertyDescriptor[])descriptorsCache.get(clazz);
        if (propertyDescriptorArray != null) {
            return propertyDescriptorArray;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            return new PropertyDescriptor[0];
        }
        propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = new PropertyDescriptor[]{};
        }
        descriptorsCache.put(clazz, propertyDescriptorArray);
        return propertyDescriptorArray;
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ReflectUtil.class.getClassLoader();
        }
        return classLoader;
    }

    public static Class[] getTypes(Object[] objectArray) {
        if (objectArray == null) {
            return new Class[0];
        }
        Class[] classArray = new Class[objectArray.length];
        int n2 = 0;
        while (n2 < objectArray.length) {
            classArray[n2] = objectArray[n2] == null ? null : objectArray[n2].getClass();
            ++n2;
        }
        return classArray;
    }

    public static boolean isEqualsMethod(Method method) {
        return method != null && method.getName().equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && method.getName().equals("toString") && method.getParameterTypes().length == 0;
    }
}

