/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.file;

import java.nio.ByteBuffer;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.storage.file.TransactionWriteStore;
import org.apache.seata.server.store.SessionStorable;
import org.apache.seata.server.store.TransactionStoreManager;

public class TransactionWriteStore
implements SessionStorable {
    private SessionStorable sessionRequest;
    private TransactionStoreManager.LogOperation operate;

    public TransactionWriteStore(SessionStorable sessionRequest, TransactionStoreManager.LogOperation operate) {
        this.sessionRequest = sessionRequest;
        this.operate = operate;
    }

    public TransactionWriteStore() {
    }

    public SessionStorable getSessionRequest() {
        return this.sessionRequest;
    }

    public void setSessionRequest(SessionStorable sessionRequest) {
        this.sessionRequest = sessionRequest;
    }

    public TransactionStoreManager.LogOperation getOperate() {
        return this.operate;
    }

    public void setOperate(TransactionStoreManager.LogOperation operate) {
        this.operate = operate;
    }

    public byte[] encode() {
        byte[] bySessionRequest = this.sessionRequest.encode();
        byte byOpCode = this.getOperate().getCode();
        int len = bySessionRequest.length + 1;
        byte[] byResult = new byte[len];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byResult);
        byteBuffer.put(bySessionRequest);
        byteBuffer.put(byOpCode);
        return byResult;
    }

    public void decode(byte[] src) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(src);
        byte[] bySessionRequest = new byte[src.length - 1];
        byteBuffer.get(bySessionRequest);
        byte byOpCode = byteBuffer.get();
        this.operate = TransactionStoreManager.LogOperation.getLogOperationByCode((byte)byOpCode);
        SessionStorable tmpSessionStorable = this.getSessionInstanceByOperation(this.operate);
        tmpSessionStorable.decode(bySessionRequest);
        this.sessionRequest = tmpSessionStorable;
    }

    private SessionStorable getSessionInstanceByOperation(TransactionStoreManager.LogOperation logOperation) {
        GlobalSession sessionStorable = null;
        switch (1.$SwitchMap$org$apache$seata$server$store$TransactionStoreManager$LogOperation[logOperation.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                sessionStorable = new GlobalSession();
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                sessionStorable = new BranchSession();
                break;
            }
            default: {
                throw new ShouldNeverHappenException("incorrect logOperation");
            }
        }
        return sessionStorable;
    }
}

