/*
 * Decompiled with CFR 0.152.
 */
package org.apache.toree.boot.layer;

import com.typesafe.config.Config;
import org.apache.toree.boot.KernelBootstrap;
import org.apache.toree.boot.layer.StandardHookInitialization;
import org.apache.toree.interpreter.Interpreter;
import scala.collection.mutable.StringBuilder;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public abstract class StandardHookInitialization$class {
    public static void initializeHooks(KernelBootstrap $this, Config config, Interpreter interpreter) {
        StandardHookInitialization$class.registerInterruptHook((KernelBootstrap)((Object)((StandardHookInitialization)((Object)$this))), config, interpreter);
    }

    public static void initializeShutdownHook(KernelBootstrap $this) {
        StandardHookInitialization$class.registerShutdownHook((KernelBootstrap)((Object)((StandardHookInitialization)((Object)$this))));
    }

    private static void registerInterruptHook(KernelBootstrap $this, Config config, Interpreter interpreter) {
        KernelBootstrap self = $this;
        Signal.handle(new Signal("INT"), new SignalHandler($this, interpreter, self){
            private final long MaxSignalTime;
            private long lastSignalReceived;
            private final /* synthetic */ KernelBootstrap $outer;
            private final Interpreter interpreter$1;
            private final KernelBootstrap self$1;

            private long MaxSignalTime() {
                return this.MaxSignalTime;
            }

            private long lastSignalReceived() {
                return this.lastSignalReceived;
            }

            private void lastSignalReceived_$eq(long x$1) {
                this.lastSignalReceived = x$1;
            }

            public void handle(Signal sig) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastSignalReceived() > this.MaxSignalTime()) {
                    this.$outer.logger().info("Resetting code execution!");
                    this.interpreter$1.interrupt();
                    this.$outer.logger().info("Enter Ctrl-C twice to shutdown!");
                    this.lastSignalReceived_$eq(currentTime);
                } else {
                    this.$outer.logger().info("Shutting down kernel");
                    this.self$1.shutdown();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.interpreter$1 = interpreter$1;
                this.self$1 = self$1;
                this.MaxSignalTime = 3000L;
                this.lastSignalReceived = 0L;
            }
        });
        String altSigintOption = "alternate_sigint";
        if (config.hasPath(altSigintOption)) {
            String altSigint = config.getString(altSigintOption);
            try {
                Signal.handle(new Signal(altSigint), new SignalHandler($this, interpreter){
                    private final /* synthetic */ KernelBootstrap $outer;
                    private final Interpreter interpreter$1;

                    public void handle(Signal sig) {
                        this.$outer.logger().info("Resetting code execution due to interrupt!");
                        this.interpreter$1.interrupt();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.interpreter$1 = interpreter$1;
                    }
                });
            }
            catch (Exception exception) {
                $this.logger().warn(new StringBuilder().append((Object)"Error occurred establishing alternate signal handler (--alternate-sigint = ").append((Object)altSigint).append((Object)").  Error: ").append((Object)exception.getMessage()).toString());
            }
        }
    }

    private static void registerShutdownHook(KernelBootstrap $this) {
        $this.logger().debug("Registering shutdown hook");
        KernelBootstrap self = $this;
        Runtime.getRuntime().addShutdownHook(new Thread($this, self){
            private final /* synthetic */ KernelBootstrap $outer;
            private final KernelBootstrap self$2;

            public void run() {
                this.$outer.logger().info("Shutting down kernel");
                this.self$2.shutdown();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.self$2 = self$2;
            }
        });
    }

    public static void $init$(KernelBootstrap $this) {
    }
}

