/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.statistics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.mpp.FragmentInstanceFetchException;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceManager;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.mpp.rpc.thrift.TFetchFragmentInstanceStatisticsReq;
import org.apache.iotdb.mpp.rpc.thrift.TFetchFragmentInstanceStatisticsResp;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;

public class QueryStatisticsFetcher {
    private static final String LOCAL_HOST_IP = IoTDBDescriptor.getInstance().getConfig().getInternalAddress();
    private static final int LOCAL_HOST_PORT = IoTDBDescriptor.getInstance().getConfig().getInternalPort();

    private QueryStatisticsFetcher() {
    }

    public static Map<FragmentInstanceId, TFetchFragmentInstanceStatisticsResp> fetchAllStatistics(List<FragmentInstance> instances, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> clientManager) throws FragmentInstanceFetchException {
        HashMap<FragmentInstanceId, TFetchFragmentInstanceStatisticsResp> fragmentInstanceStatistics = new HashMap<FragmentInstanceId, TFetchFragmentInstanceStatisticsResp>();
        for (FragmentInstance instance : instances) {
            fragmentInstanceStatistics.put(instance.getId(), QueryStatisticsFetcher.fetchStatistics(instance, clientManager));
        }
        return fragmentInstanceStatistics;
    }

    private static TFetchFragmentInstanceStatisticsResp fetchStatistics(FragmentInstance instance, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> clientManager) throws FragmentInstanceFetchException {
        TFetchFragmentInstanceStatisticsResp fragmentInstanceStatistics;
        TEndPoint endPoint = instance.getHostDataNode().internalEndPoint;
        if (LOCAL_HOST_IP.equals(endPoint.getIp()) && LOCAL_HOST_PORT == endPoint.getPort()) {
            fragmentInstanceStatistics = FragmentInstanceManager.getInstance().getFragmentInstanceStatistics(instance.getId());
        } else {
            try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)clientManager.borrowClient((Object)endPoint);){
                fragmentInstanceStatistics = client.fetchFragmentInstanceStatistics(new TFetchFragmentInstanceStatisticsReq(instance.getId().toThrift()));
                if (fragmentInstanceStatistics.status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    throw new FragmentInstanceFetchException(fragmentInstanceStatistics.status);
                }
            }
            catch (ClientManagerException | TException e) {
                TSStatus status = new TSStatus();
                status.setCode(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
                status.setMessage(e.getMessage());
                throw new FragmentInstanceFetchException(status);
            }
        }
        return fragmentInstanceStatistics;
    }
}

