/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.splitter;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.load.splitter.TsFileData;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class DeletionData
implements TsFileData {
    private final Deletion deletion;

    public DeletionData(Deletion deletion) {
        this.deletion = deletion;
    }

    @Override
    public long getDataSize() {
        return this.deletion.getSerializedSize();
    }

    public void writeToModificationFile(ModificationFile modificationFile, long fileOffset) throws IOException {
        this.deletion.setFileOffset(fileOffset);
        modificationFile.writeWithoutSync(this.deletion);
    }

    @Override
    public boolean isModification() {
        return true;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((Boolean)this.isModification(), (OutputStream)stream);
        this.deletion.serializeWithoutFileOffset(stream);
    }

    public static DeletionData deserialize(InputStream stream) throws IllegalPathException, IOException {
        return new DeletionData(Deletion.deserializeWithoutFileOffset(new DataInputStream(stream)));
    }
}

