/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.frame;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.Partition;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.frame.Frame;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.frame.FrameInfo;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.utils.ColumnList;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.utils.Range;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.utils.RowComparator;

public class GroupsFrame
implements Frame {
    private final Partition partition;
    private final FrameInfo frameInfo;
    private final int partitionSize;
    private final List<ColumnList> columns;
    private final RowComparator peerGroupComparator;
    private Range recentRange;
    private int recentStartPeerGroup;
    private int recentEndPeerGroup;
    private boolean frameStartFollowingReachEnd = false;

    public GroupsFrame(Partition partition, FrameInfo frameInfo, List<ColumnList> sortedColumns, RowComparator peerGroupComparator, int initialEnd) {
        this.partition = partition;
        this.frameInfo = frameInfo;
        this.partitionSize = partition.getPositionCount();
        this.columns = sortedColumns;
        this.peerGroupComparator = peerGroupComparator;
        this.recentRange = new Range(0, initialEnd);
        this.recentStartPeerGroup = 0;
        this.recentEndPeerGroup = 0;
    }

    @Override
    public Range getRange(int currentPosition, int currentGroup, int peerGroupStart, int peerGroupEnd) {
        int frameEnd;
        int frameStart;
        switch (this.frameInfo.getStartType()) {
            case UNBOUNDED_PRECEDING: {
                frameStart = 0;
                break;
            }
            case PRECEDING: {
                frameStart = this.getStartPrecedingOffset(currentPosition, currentGroup);
                break;
            }
            case CURRENT_ROW: {
                frameStart = peerGroupStart;
                break;
            }
            case FOLLOWING: {
                frameStart = this.getStartFollowingOffset(currentPosition, currentGroup);
                break;
            }
            default: {
                throw new SemanticException("UNBOUND FOLLOWING is not allowed in frame start!");
            }
        }
        switch (this.frameInfo.getEndType()) {
            case PRECEDING: {
                frameEnd = this.getEndPrecedingOffset(currentPosition, currentGroup);
                break;
            }
            case CURRENT_ROW: {
                frameEnd = peerGroupEnd - 1;
                break;
            }
            case FOLLOWING: {
                frameEnd = this.getEndFollowingOffset(currentPosition, currentGroup);
                break;
            }
            case UNBOUNDED_FOLLOWING: {
                frameEnd = this.partitionSize - 1;
                break;
            }
            default: {
                throw new SemanticException("UNBOUND PRECEDING is not allowed in frame end!");
            }
        }
        if (frameEnd < frameStart || frameEnd < 0 || frameStart >= this.partitionSize) {
            return new Range(-1, -1);
        }
        frameStart = Math.max(frameStart, 0);
        frameEnd = Math.min(frameEnd, this.partitionSize - 1);
        this.recentRange = new Range(frameStart, frameEnd);
        return this.recentRange;
    }

    private int getStartPrecedingOffset(int currentPosition, int currentGroup) {
        int start = this.recentRange.getStart();
        int offset = (int)this.getOffset(this.frameInfo.getStartOffsetChannel(), currentPosition);
        if (currentGroup - offset < 0) {
            return -1;
        }
        if (currentGroup - offset > this.recentStartPeerGroup) {
            int count = currentGroup - offset - this.recentStartPeerGroup;
            for (int i = 0; i < count; ++i) {
                start = this.scanPeerGroup(start);
                ++start;
            }
            this.recentStartPeerGroup = currentGroup - offset;
        }
        return start;
    }

    private int getEndPrecedingOffset(int currentPosition, int currentGroup) {
        int end = this.recentRange.getEnd();
        int offset = (int)this.getOffset(this.frameInfo.getEndOffsetChannel(), currentPosition);
        if (currentGroup - offset < 0) {
            return -1;
        }
        if (currentGroup - offset > this.recentEndPeerGroup) {
            int count = currentGroup - offset - this.recentEndPeerGroup;
            for (int i = 0; i < count; ++i) {
                ++end;
                end = this.scanPeerGroup(end);
            }
            this.recentEndPeerGroup = currentGroup - offset;
        }
        return end;
    }

    private int getStartFollowingOffset(int currentPosition, int currentGroup) {
        if (this.frameStartFollowingReachEnd) {
            return this.partitionSize;
        }
        int start = this.recentRange.getStart();
        int offset = (int)this.getOffset(this.frameInfo.getStartOffsetChannel(), currentPosition);
        if (currentGroup + offset > this.recentStartPeerGroup) {
            int count = currentGroup + offset - this.recentStartPeerGroup;
            for (int i = 0; i < count; ++i) {
                if ((start = this.scanPeerGroup(start)) == this.partitionSize - 1) {
                    this.recentStartPeerGroup = currentGroup + i;
                    this.frameStartFollowingReachEnd = true;
                    return this.partitionSize;
                }
                ++start;
            }
            this.recentStartPeerGroup = currentGroup + offset;
        }
        return start;
    }

    private int getEndFollowingOffset(int currentPosition, int currentGroup) {
        int end = this.recentRange.getEnd();
        if (end == this.partitionSize - 1) {
            return end;
        }
        int offset = (int)this.getOffset(this.frameInfo.getEndOffsetChannel(), currentPosition);
        if (currentGroup + offset > this.recentEndPeerGroup) {
            int count = currentGroup + offset - this.recentEndPeerGroup;
            for (int i = 0; i < count; ++i) {
                if (end == this.partitionSize - 1) {
                    if (i != count - 1) {
                        return this.partitionSize;
                    }
                    this.recentEndPeerGroup = currentGroup + i;
                    return end;
                }
                ++end;
                end = this.scanPeerGroup(end);
            }
            this.recentEndPeerGroup = currentGroup + offset;
        }
        return end;
    }

    private int scanPeerGroup(int currentPosition) {
        while (currentPosition < this.partitionSize - 1 && this.peerGroupComparator.equalColumnLists(this.columns, currentPosition, currentPosition + 1)) {
            ++currentPosition;
        }
        return currentPosition;
    }

    public long getOffset(int channel, int index) {
        Preconditions.checkArgument((!this.partition.isNull(channel, index) ? 1 : 0) != 0);
        long offset = this.partition.getLong(channel, index);
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0);
        return offset;
    }
}

