/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.mailbox;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.jmap.draft.model.mailbox.Rights;
import org.apache.james.jmap.draft.model.mailbox.SortOrder;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxId;

@JsonDeserialize(builder=Builder.class)
public class MailboxUpdateRequest {
    private final Optional<String> name;
    private final Optional<MailboxId> parentId;
    private final Optional<Role> role;
    private final Optional<SortOrder> sortOrder;
    private final Optional<Rights> sharedWith;

    public static Builder builder() throws MailboxException {
        return new Builder();
    }

    @VisibleForTesting
    MailboxUpdateRequest(Optional<String> name, Optional<MailboxId> parentId, Optional<Role> role, Optional<SortOrder> sortOrder, Optional<Rights> sharedWith) {
        this.name = name;
        this.parentId = parentId;
        this.role = role;
        this.sortOrder = sortOrder;
        this.sharedWith = sharedWith;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<MailboxId> getParentId() {
        return this.parentId;
    }

    public Optional<Role> getRole() {
        return this.role;
    }

    public Optional<SortOrder> getSortOrder() {
        return this.sortOrder;
    }

    public Optional<Rights> getSharedWith() {
        return this.sharedWith;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof MailboxUpdateRequest) {
            MailboxUpdateRequest other = (MailboxUpdateRequest)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.parentId, other.parentId) && Objects.equals(this.role, other.role) && Objects.equals(this.sortOrder, other.sortOrder) && Objects.equals(this.sharedWith, other.sharedWith);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.name, this.parentId, this.role, this.sortOrder, this.sharedWith);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name", this.name).add("parentId", this.parentId).add("role", this.role).add("sortOrder", this.sortOrder).add("sharedWith", this.sharedWith).toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<MailboxId> parentId;
        private Optional<Role> role = Optional.empty();
        private Optional<SortOrder> sortOrder = Optional.empty();
        private Optional<Rights> sharedWith;

        private Builder() {
            this.parentId = Optional.empty();
            this.sharedWith = Optional.empty();
        }

        public Builder name(String name) throws MailboxException {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
            this.name = Optional.of(name);
            return this;
        }

        public Builder parentId(MailboxId parentId) {
            this.parentId = parentId == null ? null : Optional.of(parentId);
            return this;
        }

        public Builder role(Role role) {
            Preconditions.checkNotNull((Object)role);
            throw new NotImplementedException("not implemented");
        }

        public Builder sortOrder(SortOrder sortOrder) {
            Preconditions.checkNotNull((Object)sortOrder);
            throw new NotImplementedException("not implemented");
        }

        public Builder sharedWith(Rights rights) {
            Preconditions.checkNotNull((Object)rights);
            this.sharedWith = Optional.of(rights);
            return this;
        }

        public MailboxUpdateRequest build() {
            return new MailboxUpdateRequest(this.name, this.parentId, this.role, this.sortOrder, this.sharedWith);
        }
    }
}

