/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MailboxUtil;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;

public class Mailbox {
    private MailboxId id = null;
    private String namespace;
    private String user;
    private String name;
    private final long uidValidity;
    private MailboxACL acl = MailboxACL.EMPTY;

    public Mailbox(MailboxPath path, long uidValidity, MailboxId mailboxId) {
        this.id = mailboxId;
        this.namespace = path.getNamespace();
        this.user = path.getUser();
        this.name = path.getName();
        this.uidValidity = uidValidity;
    }

    public Mailbox(MailboxPath path, long uidValidity) {
        this(path, uidValidity, null);
    }

    public Mailbox(Mailbox mailbox) {
        this.id = mailbox.getMailboxId();
        this.namespace = mailbox.getNamespace();
        this.user = mailbox.getUser();
        this.name = mailbox.getName();
        this.uidValidity = mailbox.getUidValidity();
        this.acl = new MailboxACL(mailbox.getACL().getEntries());
    }

    public MailboxId getMailboxId() {
        return this.id;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getUidValidity() {
        return this.uidValidity;
    }

    public MailboxPath generateAssociatedPath() {
        return new MailboxPath(this.getNamespace(), this.getUser(), this.getName());
    }

    public void setMailboxId(MailboxId id) {
        this.id = id;
    }

    public MailboxACL getACL() {
        return this.acl;
    }

    public void setACL(MailboxACL acl) {
        this.acl = acl;
    }

    public boolean isChildOf(Mailbox potentialParent, MailboxSession mailboxSession) {
        return MailboxUtil.isMailboxChildOf(this, potentialParent, mailboxSession);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Mailbox) {
            Mailbox o = (Mailbox)obj;
            return Objects.equal(this.id, o.getMailboxId());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.namespace, this.user, this.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("namespace", this.namespace).add("user", this.user).add("name", this.name).toString();
    }
}

