/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base;

import java.io.IOException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlowedMessageUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowedMessageUtils.class);
    public static final char RFC2646_SPACE = ' ';
    public static final char RFC2646_QUOTE = '>';
    public static final String RFC2646_SIGNATURE = "-- ";
    public static final String RFC2646_CRLF = "\r\n";
    public static final String RFC2646_FROM = "From ";
    public static final int RFC2646_WIDTH = 78;
    private static final char CR = '\r';
    private static final char LF = '\n';

    private FlowedMessageUtils() {
    }

    public static String deflow(String text, boolean delSp) {
        String[] lines = text.split("\r\n|\n", -1);
        StringBuffer result = null;
        StringBuffer resultLine = new StringBuffer();
        int resultLineQuoteDepth = 0;
        boolean resultLineFlowed = false;
        for (int i = 0; i <= lines.length; ++i) {
            String line = i < lines.length ? lines[i] : null;
            int actualQuoteDepth = 0;
            if (line != null) {
                if (line.equals(RFC2646_SIGNATURE)) {
                    resultLineFlowed = false;
                } else if (line.length() > 0 && line.charAt(0) == '>') {
                    for (actualQuoteDepth = 1; actualQuoteDepth < line.length() && line.charAt(actualQuoteDepth) == '>'; ++actualQuoteDepth) {
                    }
                    if (resultLineQuoteDepth != actualQuoteDepth) {
                        resultLineFlowed = false;
                    }
                    line = line.substring(actualQuoteDepth);
                } else if (resultLineQuoteDepth > 0) {
                    resultLineFlowed = false;
                }
                if (line.length() > 0 && line.charAt(0) == ' ') {
                    line = line.substring(1);
                }
            } else {
                resultLineFlowed = false;
            }
            if (!resultLineFlowed && i > 0) {
                if (resultLineQuoteDepth > 0) {
                    resultLine.insert(0, ' ');
                }
                for (int j = 0; j < resultLineQuoteDepth; ++j) {
                    resultLine.insert(0, '>');
                }
                if (result == null) {
                    result = new StringBuffer();
                } else {
                    result.append(RFC2646_CRLF);
                }
                result.append(resultLine.toString());
                resultLine = new StringBuffer();
                resultLineFlowed = false;
            }
            resultLineQuoteDepth = actualQuoteDepth;
            if (line == null) continue;
            if (!line.equals(RFC2646_SIGNATURE) && line.endsWith(" ") && i < lines.length - 1) {
                if (delSp) {
                    line = line.substring(0, line.length() - 1);
                }
                resultLineFlowed = true;
            } else {
                resultLineFlowed = false;
            }
            resultLine.append(line);
        }
        return result.toString();
    }

    public static String deflow(Message m) throws IOException, MessagingException {
        ContentType ct = new ContentType(m.getContentType());
        String format = ct.getParameter("format");
        if (ct.getBaseType().equals("text/plain") && format != null && format.equalsIgnoreCase("flowed")) {
            String delSp = ct.getParameter("delsp");
            return FlowedMessageUtils.deflow((String)m.getContent(), delSp != null && delSp.equalsIgnoreCase("yes"));
        }
        if (ct.getPrimaryType().equals("text")) {
            return (String)m.getContent();
        }
        return null;
    }

    public static void deflowMessage(Message m) throws MessagingException, IOException {
        ContentType ct = new ContentType(m.getContentType());
        String format = ct.getParameter("format");
        if (ct.getBaseType().equals("text/plain") && format != null && format.equalsIgnoreCase("flowed")) {
            String delSp = ct.getParameter("delsp");
            String deflowed = FlowedMessageUtils.deflow((String)m.getContent(), delSp != null && delSp.equalsIgnoreCase("yes"));
            ct.getParameterList().remove("format");
            ct.getParameterList().remove("delsp");
            if (ct.toString().contains("flowed")) {
                LOGGER.error("FlowedMessageUtils dind't remove the flowed correctly");
            }
            m.setContent((Object)deflowed, ct.toString());
            m.saveChanges();
        }
    }

    public static String flow(String text, boolean delSp) {
        return FlowedMessageUtils.flow(text, delSp, 78);
    }

    public static String flow(String text, boolean delSp, int width) {
        int lastIndex = text.length() - 1;
        StringBuilder result = new StringBuilder();
        int lineStartIndex = 0;
        while (lineStartIndex <= lastIndex) {
            int i;
            int nextLineStartIndex;
            int lineFeedIndex;
            int quoteDepth = 0;
            while (lineStartIndex <= lastIndex && text.charAt(lineStartIndex) == '>') {
                ++quoteDepth;
                ++lineStartIndex;
            }
            if (quoteDepth > 0 && lineStartIndex + 1 <= lastIndex && text.charAt(lineStartIndex) == ' ') {
                ++lineStartIndex;
            }
            boolean lineBreakFound = (lineFeedIndex = text.indexOf(10, lineStartIndex)) != -1;
            int lineEndIndex = lineBreakFound ? lineFeedIndex : text.length();
            int n = nextLineStartIndex = lineBreakFound ? lineFeedIndex + 1 : text.length();
            if (lineBreakFound && lineEndIndex > 0 && text.charAt(lineEndIndex - 1) == '\r') {
                --lineEndIndex;
            }
            if (lineEndIndex - lineStartIndex == RFC2646_SIGNATURE.length() && text.regionMatches(lineStartIndex, RFC2646_SIGNATURE, 0, RFC2646_SIGNATURE.length())) {
                if (quoteDepth > 0) {
                    for (i = 0; i < quoteDepth; ++i) {
                        result.append('>');
                    }
                    result.append(' ');
                }
                result.append(RFC2646_SIGNATURE);
                result.append(RFC2646_CRLF);
                lineStartIndex = nextLineStartIndex;
                continue;
            }
            while (lineEndIndex > lineStartIndex && text.charAt(lineEndIndex - 1) == ' ') {
                --lineEndIndex;
            }
            if (lineStartIndex == lineEndIndex && quoteDepth > 0) {
                for (i = 0; i < quoteDepth; ++i) {
                    result.append('>');
                }
            }
            while (lineStartIndex < lineEndIndex) {
                int breakIndex;
                int prefixLength = 0;
                if (quoteDepth == 0) {
                    if (text.charAt(lineStartIndex) == ' ' || text.charAt(lineStartIndex) == '>' || lineEndIndex - lineStartIndex >= RFC2646_FROM.length() && text.regionMatches(lineStartIndex, RFC2646_FROM, 0, RFC2646_FROM.length())) {
                        result.append(' ');
                        prefixLength = 1;
                    }
                } else {
                    for (int i2 = 0; i2 < quoteDepth; ++i2) {
                        result.append('>');
                    }
                    result.append(' ');
                    prefixLength = quoteDepth + 1;
                }
                int remainingWidth = width - prefixLength - 1;
                if (delSp) {
                    --remainingWidth;
                }
                if (remainingWidth < 0) {
                    remainingWidth = 0;
                }
                if ((breakIndex = lineStartIndex + remainingWidth) >= lineEndIndex) {
                    breakIndex = lineEndIndex;
                } else {
                    while (breakIndex >= lineStartIndex && (delSp && FlowedMessageUtils.isAlphaChar(text, breakIndex) || !delSp && text.charAt(breakIndex) != ' ')) {
                        --breakIndex;
                    }
                    if (breakIndex < lineStartIndex) {
                        for (breakIndex = lineStartIndex + remainingWidth; breakIndex < lineEndIndex && (delSp && FlowedMessageUtils.isAlphaChar(text, breakIndex) || !delSp && text.charAt(breakIndex) != ' '); ++breakIndex) {
                        }
                    }
                    if (++breakIndex >= lineEndIndex) {
                        breakIndex = lineEndIndex;
                    } else if (Character.isHighSurrogate(text.charAt(breakIndex - 1))) {
                        ++breakIndex;
                    }
                }
                result.append(text, lineStartIndex, breakIndex);
                if (breakIndex < lineEndIndex) {
                    if (delSp) {
                        result.append(' ');
                    }
                    result.append(RFC2646_CRLF);
                }
                lineStartIndex = breakIndex;
            }
            if (lineBreakFound) {
                result.append(RFC2646_CRLF);
            }
            lineStartIndex = nextLineStartIndex;
        }
        return result.toString();
    }

    public static void setFlowedContent(Message m, String text, boolean delSp) throws MessagingException {
        FlowedMessageUtils.setFlowedContent(m, text, delSp, 78, true, null);
    }

    public static void setFlowedContent(Message m, String text, boolean delSp, int width, boolean preserveCharset, String charset) throws MessagingException {
        ContentType ct;
        String coded = FlowedMessageUtils.flow(text, delSp, width);
        if (preserveCharset) {
            ct = new ContentType(m.getContentType());
            charset = ct.getParameter("charset");
        }
        ct = new ContentType();
        ct.setPrimaryType("text");
        ct.setSubType("plain");
        if (charset != null) {
            ct.setParameter("charset", charset);
        }
        ct.setParameter("format", "flowed");
        if (delSp) {
            ct.setParameter("delsp", "yes");
        }
        m.setContent((Object)coded, ct.toString());
        m.saveChanges();
    }

    public static void flowMessage(Message m, boolean delSp) throws MessagingException, IOException {
        FlowedMessageUtils.flowMessage(m, delSp, 78);
    }

    public static void flowMessage(Message m, boolean delSp, int width) throws MessagingException, IOException {
        ContentType ct = new ContentType(m.getContentType());
        if (!ct.getBaseType().equals("text/plain")) {
            return;
        }
        String format = ct.getParameter("format");
        String text = format != null && format.equals("flowed") ? FlowedMessageUtils.deflow(m) : (String)m.getContent();
        String coded = FlowedMessageUtils.flow(text, delSp, width);
        ct.setParameter("format", "flowed");
        if (delSp) {
            ct.setParameter("delsp", "yes");
        }
        m.setContent((Object)coded, ct.toString());
        m.saveChanges();
    }

    public static boolean isAlphaChar(String text, int index) {
        char c = text.charAt(index);
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
    }

    public static boolean isFlowedTextMessage(Message m) throws MessagingException {
        ContentType ct = new ContentType(m.getContentType());
        String format = ct.getParameter("format");
        return ct.getBaseType().equals("text/plain") && format != null && format.equalsIgnoreCase("flowed");
    }
}

