/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.listener.InMemoryDirectoryServerSnapshot;
import com.unboundid.ldap.listener.InMemoryExtendedOperationHandler;
import com.unboundid.ldap.listener.InMemoryRequestHandler;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.protocol.AddResponseProtocolOp;
import com.unboundid.ldap.protocol.DeleteResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ModifyDNResponseProtocolOp;
import com.unboundid.ldap.protocol.ModifyResponseProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.AbortedTransactionExtendedResult;
import com.unboundid.ldap.sdk.extensions.EndTransactionExtendedRequest;
import com.unboundid.ldap.sdk.extensions.EndTransactionExtendedResult;
import com.unboundid.ldap.sdk.extensions.StartTransactionExtendedRequest;
import com.unboundid.ldap.sdk.extensions.StartTransactionExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TransactionExtendedOperationHandler
extends InMemoryExtendedOperationHandler {
    @NotNull
    private static final AtomicLong TXN_ID_COUNTER = new AtomicLong(1L);
    @NotNull
    static final String STATE_VARIABLE_TXN_INFO = "TXN-INFO";

    @Override
    @NotNull
    public String getExtendedOperationHandlerName() {
        return "LDAP Transactions";
    }

    @Override
    @NotNull
    public List<String> getSupportedExtendedRequestOIDs() {
        return Arrays.asList("1.3.6.1.1.21.1", "1.3.6.1.1.21.3");
    }

    @Override
    @NotNull
    public ExtendedResult processExtendedOperation(@NotNull InMemoryRequestHandler handler, int messageID, @NotNull ExtendedRequest request) {
        for (Control c : request.getControls()) {
            if (!c.isCritical()) continue;
            ObjectPair existingTxnInfo = (ObjectPair)handler.getConnectionState().remove(STATE_VARIABLE_TXN_INFO);
            if (existingTxnInfo != null) {
                ASN1OctetString txnID = (ASN1OctetString)existingTxnInfo.getFirst();
                try {
                    handler.getClientConnection().sendUnsolicitedNotification(new AbortedTransactionExtendedResult(txnID, ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_TXN_EXTOP_ABORTED_BY_UNSUPPORTED_CONTROL.get(txnID.stringValue(), c.getOID()), null, null, null));
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    return new ExtendedResult(le);
                }
            }
            return new ExtendedResult(messageID, ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_TXN_EXTOP_UNSUPPORTED_CONTROL.get(c.getOID()), null, null, null, null, null);
        }
        String oid = request.getOID();
        if (oid.equals("1.3.6.1.1.21.1")) {
            return TransactionExtendedOperationHandler.handleStartTransaction(handler, messageID, request);
        }
        return TransactionExtendedOperationHandler.handleEndTransaction(handler, messageID, request);
    }

    @NotNull
    private static StartTransactionExtendedResult handleStartTransaction(@NotNull InMemoryRequestHandler handler, int messageID, @NotNull ExtendedRequest request) {
        ASN1OctetString txnID;
        Map<String, Object> connectionState = handler.getConnectionState();
        ObjectPair existingTxnInfo = (ObjectPair)connectionState.remove(STATE_VARIABLE_TXN_INFO);
        if (existingTxnInfo != null) {
            txnID = (ASN1OctetString)existingTxnInfo.getFirst();
            try {
                handler.getClientConnection().sendUnsolicitedNotification(new AbortedTransactionExtendedResult(txnID, ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_TXN_EXTOP_TXN_ABORTED_BY_NEW_START_TXN.get(txnID.stringValue()), null, null, null));
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new StartTransactionExtendedResult(new ExtendedResult(le));
            }
        }
        try {
            new StartTransactionExtendedRequest(request);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return new StartTransactionExtendedResult(messageID, ResultCode.PROTOCOL_ERROR, le.getMessage(), null, null, null, null);
        }
        txnID = new ASN1OctetString(String.valueOf(TXN_ID_COUNTER.getAndIncrement()));
        ArrayList requestList = new ArrayList(10);
        ObjectPair txnInfo = new ObjectPair(txnID, requestList);
        connectionState.put(STATE_VARIABLE_TXN_INFO, txnInfo);
        return new StartTransactionExtendedResult(messageID, ResultCode.SUCCESS, ListenerMessages.INFO_TXN_EXTOP_CREATED_TXN.get(txnID.stringValue()), null, null, txnID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static EndTransactionExtendedResult handleEndTransaction(@NotNull InMemoryRequestHandler handler, int messageID, @NotNull ExtendedRequest request) {
        EndTransactionExtendedRequest endTxnRequest;
        Map<String, Object> connectionState = handler.getConnectionState();
        ObjectPair txnInfo = (ObjectPair)connectionState.remove(STATE_VARIABLE_TXN_INFO);
        if (txnInfo == null) {
            return new EndTransactionExtendedResult(messageID, ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_TXN_EXTOP_END_NO_ACTIVE_TXN.get(), null, null, null, null, null);
        }
        ASN1OctetString existingTxnID = (ASN1OctetString)txnInfo.getFirst();
        try {
            endTxnRequest = new EndTransactionExtendedRequest(request);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            try {
                handler.getClientConnection().sendUnsolicitedNotification(new AbortedTransactionExtendedResult(existingTxnID, ResultCode.PROTOCOL_ERROR, ListenerMessages.ERR_TXN_EXTOP_ABORTED_BY_MALFORMED_END_TXN.get(existingTxnID.stringValue()), null, null, null));
                return new EndTransactionExtendedResult(messageID, ResultCode.PROTOCOL_ERROR, le.getMessage(), null, null, null, null, null);
            }
            catch (LDAPException le2) {
                Debug.debugException(le2);
            }
            return new EndTransactionExtendedResult(messageID, ResultCode.PROTOCOL_ERROR, le.getMessage(), null, null, null, null, null);
        }
        ASN1OctetString targetTxnID = endTxnRequest.getTransactionID();
        if (!existingTxnID.stringValue().equals(targetTxnID.stringValue())) {
            try {
                handler.getClientConnection().sendUnsolicitedNotification(new AbortedTransactionExtendedResult(existingTxnID, ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_TXN_EXTOP_ABORTED_BY_WRONG_END_TXN.get(existingTxnID.stringValue(), targetTxnID.stringValue()), null, null, null));
                return new EndTransactionExtendedResult(messageID, ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_TXN_EXTOP_END_WRONG_TXN.get(targetTxnID.stringValue(), existingTxnID.stringValue()), null, null, null, null, null);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new EndTransactionExtendedResult(messageID, le.getResultCode(), le.getMessage(), le.getMatchedDN(), le.getReferralURLs(), null, null, le.getResponseControls());
            }
        }
        if (!endTxnRequest.commit()) {
            return new EndTransactionExtendedResult(messageID, ResultCode.SUCCESS, ListenerMessages.INFO_TXN_EXTOP_END_TXN_ABORTED.get(existingTxnID.stringValue()), null, null, null, null, null);
        }
        InMemoryDirectoryServerSnapshot snapshot = handler.createSnapshot();
        boolean rollBack = true;
        try {
            List requestMessages = (List)txnInfo.getSecond();
            LinkedHashMap<Integer, Control[]> opResponseControls = new LinkedHashMap<Integer, Control[]>(StaticUtils.computeMapCapacity(requestMessages.size()));
            ResultCode resultCode = ResultCode.SUCCESS;
            String diagnosticMessage = null;
            String failedOpType = null;
            Integer failedOpMessageID = null;
            block15: for (Object o : requestMessages) {
                LDAPMessage m = (LDAPMessage)o;
                switch (m.getProtocolOpType()) {
                    case 104: {
                        LDAPMessage addResponseMessage = handler.processAddRequest(m.getMessageID(), m.getAddRequestProtocolOp(), m.getControls());
                        AddResponseProtocolOp addResponseOp = addResponseMessage.getAddResponseProtocolOp();
                        List<Control> addControls = addResponseMessage.getControls();
                        if (addControls != null && !addControls.isEmpty()) {
                            Control[] controls = new Control[addControls.size()];
                            addControls.toArray(controls);
                            opResponseControls.put(m.getMessageID(), controls);
                        }
                        if (addResponseOp.getResultCode() == 0) break;
                        resultCode = ResultCode.valueOf(addResponseOp.getResultCode());
                        diagnosticMessage = addResponseOp.getDiagnosticMessage();
                        failedOpType = ListenerMessages.INFO_TXN_EXTOP_OP_TYPE_ADD.get();
                        failedOpMessageID = m.getMessageID();
                        break block15;
                    }
                    case 74: {
                        LDAPMessage deleteResponseMessage = handler.processDeleteRequest(m.getMessageID(), m.getDeleteRequestProtocolOp(), m.getControls());
                        DeleteResponseProtocolOp deleteResponseOp = deleteResponseMessage.getDeleteResponseProtocolOp();
                        List<Control> deleteControls = deleteResponseMessage.getControls();
                        if (deleteControls != null && !deleteControls.isEmpty()) {
                            Control[] controls = new Control[deleteControls.size()];
                            deleteControls.toArray(controls);
                            opResponseControls.put(m.getMessageID(), controls);
                        }
                        if (deleteResponseOp.getResultCode() == 0) break;
                        resultCode = ResultCode.valueOf(deleteResponseOp.getResultCode());
                        diagnosticMessage = deleteResponseOp.getDiagnosticMessage();
                        failedOpType = ListenerMessages.INFO_TXN_EXTOP_OP_TYPE_DELETE.get();
                        failedOpMessageID = m.getMessageID();
                        break block15;
                    }
                    case 102: {
                        LDAPMessage modifyResponseMessage = handler.processModifyRequest(m.getMessageID(), m.getModifyRequestProtocolOp(), m.getControls());
                        ModifyResponseProtocolOp modifyResponseOp = modifyResponseMessage.getModifyResponseProtocolOp();
                        List<Control> modifyControls = modifyResponseMessage.getControls();
                        if (modifyControls != null && !modifyControls.isEmpty()) {
                            Control[] controls = new Control[modifyControls.size()];
                            modifyControls.toArray(controls);
                            opResponseControls.put(m.getMessageID(), controls);
                        }
                        if (modifyResponseOp.getResultCode() == 0) break;
                        resultCode = ResultCode.valueOf(modifyResponseOp.getResultCode());
                        diagnosticMessage = modifyResponseOp.getDiagnosticMessage();
                        failedOpType = ListenerMessages.INFO_TXN_EXTOP_OP_TYPE_MODIFY.get();
                        failedOpMessageID = m.getMessageID();
                        break block15;
                    }
                    case 108: {
                        LDAPMessage modifyDNResponseMessage = handler.processModifyDNRequest(m.getMessageID(), m.getModifyDNRequestProtocolOp(), m.getControls());
                        ModifyDNResponseProtocolOp modifyDNResponseOp = modifyDNResponseMessage.getModifyDNResponseProtocolOp();
                        List<Control> modifyDNControls = modifyDNResponseMessage.getControls();
                        if (modifyDNControls != null && !modifyDNControls.isEmpty()) {
                            Control[] controls = new Control[modifyDNControls.size()];
                            modifyDNControls.toArray(controls);
                            opResponseControls.put(m.getMessageID(), controls);
                        }
                        if (modifyDNResponseOp.getResultCode() == 0) break;
                        resultCode = ResultCode.valueOf(modifyDNResponseOp.getResultCode());
                        diagnosticMessage = modifyDNResponseOp.getDiagnosticMessage();
                        failedOpType = ListenerMessages.INFO_TXN_EXTOP_OP_TYPE_MODIFY_DN.get();
                        failedOpMessageID = m.getMessageID();
                        break block15;
                    }
                }
            }
            if (resultCode == ResultCode.SUCCESS) {
                diagnosticMessage = ListenerMessages.INFO_TXN_EXTOP_COMMITTED.get(existingTxnID.stringValue());
                rollBack = false;
            } else {
                diagnosticMessage = ListenerMessages.ERR_TXN_EXTOP_COMMIT_FAILED.get(existingTxnID.stringValue(), failedOpType, failedOpMessageID, diagnosticMessage);
            }
            EndTransactionExtendedResult endTransactionExtendedResult = new EndTransactionExtendedResult(messageID, resultCode, diagnosticMessage, null, null, failedOpMessageID, opResponseControls, null);
            return endTransactionExtendedResult;
        }
        finally {
            if (rollBack) {
                handler.restoreSnapshot(snapshot);
            }
        }
    }
}

