/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.JSONFormattedControlDecodeBehavior;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONFormattedResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String JSON_FORMATTED_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.65";
    @NotNull
    private static final String JSON_FIELD_CONTROLS = "controls";
    private static final long serialVersionUID = -5437134160392183276L;
    @NotNull
    private final JSONObject encodedValue;
    @NotNull
    private final List<JSONObject> controlObjects;

    JSONFormattedResponseControl() {
        this.encodedValue = null;
        this.controlObjects = Collections.emptyList();
    }

    private JSONFormattedResponseControl(@NotNull JSONObject encodedValue, @NotNull List<JSONObject> controlObjects) {
        super(JSON_FORMATTED_RESPONSE_OID, false, new ASN1OctetString(encodedValue.toSingleLineString()));
        this.encodedValue = encodedValue;
        this.controlObjects = controlObjects;
    }

    @NotNull
    public static JSONFormattedResponseControl createWithControls(Control ... controls) {
        return JSONFormattedResponseControl.createWithControls(StaticUtils.toList(controls));
    }

    @NotNull
    public static JSONFormattedResponseControl createWithControls(@NotNull Collection<Control> controls) {
        ArrayList<JSONObject> controlObjects = new ArrayList<JSONObject>(controls.size());
        for (Control c : controls) {
            controlObjects.add(c.toJSONControl());
        }
        JSONObject encodedValue = new JSONObject(new JSONField(JSON_FIELD_CONTROLS, new JSONArray(controlObjects)));
        return new JSONFormattedResponseControl(encodedValue, Collections.unmodifiableList(controlObjects));
    }

    @NotNull
    public static JSONFormattedResponseControl createWithControlObjects(JSONObject ... controlObjects) {
        return JSONFormattedResponseControl.createWithControlObjects(StaticUtils.toList(controlObjects));
    }

    @NotNull
    public static JSONFormattedResponseControl createWithControlObjects(@NotNull Collection<JSONObject> controlObjects) {
        ArrayList<JSONObject> controlObjectList = new ArrayList<JSONObject>(controlObjects);
        JSONObject encodedValue = new JSONObject(new JSONField(JSON_FIELD_CONTROLS, new JSONArray(controlObjectList)));
        return new JSONFormattedResponseControl(encodedValue, Collections.unmodifiableList(controlObjectList));
    }

    public JSONFormattedResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_RESPONSE_NO_VALUE.get());
        }
        try {
            this.encodedValue = new JSONObject(value.stringValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_RESPONSE_VALUE_NOT_JSON.get(), e);
        }
        List<String> unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(this.encodedValue, JSON_FIELD_CONTROLS);
        if (!unrecognizedFields.isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_RESPONSE_UNRECOGNIZED_FIELD.get(unrecognizedFields.get(0)));
        }
        List<JSONValue> controlValues = this.encodedValue.getFieldAsArray(JSON_FIELD_CONTROLS);
        if (controlValues == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_RESPONSE_VALUE_MISSING_CONTROLS.get(JSON_FIELD_CONTROLS));
        }
        if (controlValues.isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_RESPONSE_VALUE_EMPTY_CONTROLS.get(JSON_FIELD_CONTROLS));
        }
        ArrayList<JSONObject> controlObjectsList = new ArrayList<JSONObject>(controlValues.size());
        for (JSONValue controlValue : controlValues) {
            if (controlValue instanceof JSONObject) {
                JSONObject embeddedControlObject = (JSONObject)controlValue;
                try {
                    new JSONControlDecodeHelper(embeddedControlObject, true, true, false);
                    controlObjectsList.add(embeddedControlObject);
                    continue;
                }
                catch (LDAPException e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_RESPONSE_VALUE_NOT_CONTROL.get(JSON_FIELD_CONTROLS, embeddedControlObject.toSingleLineString(), e.getMessage()), e);
                }
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_RESPONSE_VALUE_CONTROL_NOT_OBJECT.get(JSON_FIELD_CONTROLS));
        }
        this.controlObjects = Collections.unmodifiableList(controlObjectsList);
    }

    @Override
    @NotNull
    public JSONFormattedResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new JSONFormattedResponseControl(oid, isCritical, value);
    }

    @NotNull
    public List<JSONObject> getControlObjects() {
        return this.controlObjects;
    }

    @NotNull
    public synchronized List<Control> decodeEmbeddedControls(@NotNull JSONFormattedControlDecodeBehavior behavior, @Nullable List<String> nonFatalDecodeMessages) throws LDAPException {
        boolean errorEncountered = false;
        ArrayList<Control> controlList = new ArrayList<Control>(this.controlObjects.size());
        ArrayList<String> fatalMessages = new ArrayList<String>(this.controlObjects.size());
        for (JSONObject controlObject : this.controlObjects) {
            JSONControlDecodeHelper jsonControl;
            try {
                jsonControl = new JSONControlDecodeHelper(controlObject, behavior.strict(), true, false);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                errorEncountered = true;
                if (behavior.throwOnUnparsableObject()) {
                    fatalMessages.add(e.getMessage());
                    continue;
                }
                if (nonFatalDecodeMessages == null) continue;
                nonFatalDecodeMessages.add(e.getMessage());
                continue;
            }
            if (jsonControl.getOID().equals(JSON_FORMATTED_RESPONSE_OID) && !behavior.allowEmbeddedJSONFormattedControl()) {
                String message = ControlMessages.ERR_JSON_FORMATTED_RESPONSE_DISALLOWED_EMBEDDED_CONTROL.get();
                if (jsonControl.getCriticality()) {
                    fatalMessages.add(message);
                    continue;
                }
                if (nonFatalDecodeMessages == null) continue;
                nonFatalDecodeMessages.add(message);
                continue;
            }
            try {
                controlList.add(Control.decodeJSONControl(controlObject, behavior.strict(), false));
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                errorEncountered = true;
                if (jsonControl.getCriticality()) {
                    if (behavior.throwOnInvalidCriticalControl()) {
                        fatalMessages.add(e.getMessage());
                        continue;
                    }
                    if (nonFatalDecodeMessages == null) continue;
                    nonFatalDecodeMessages.add(e.getMessage());
                    continue;
                }
                if (behavior.throwOnInvalidNonCriticalControl()) {
                    fatalMessages.add(e.getMessage());
                    continue;
                }
                if (nonFatalDecodeMessages == null) continue;
                nonFatalDecodeMessages.add(e.getMessage());
            }
        }
        if (!fatalMessages.isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, StaticUtils.concatenateStrings(fatalMessages));
        }
        return Collections.unmodifiableList(controlList);
    }

    @Nullable
    public static JSONFormattedResponseControl get(@NotNull LDAPResult result) throws LDAPException {
        return JSONFormattedResponseControl.get(result.getResponseControl(JSON_FORMATTED_RESPONSE_OID));
    }

    @Nullable
    public static JSONFormattedResponseControl get(@NotNull SearchResultEntry entry) throws LDAPException {
        return JSONFormattedResponseControl.get(entry.getControl(JSON_FORMATTED_RESPONSE_OID));
    }

    @Nullable
    public static JSONFormattedResponseControl get(@NotNull SearchResultReference reference) throws LDAPException {
        return JSONFormattedResponseControl.get(reference.getControl(JSON_FORMATTED_RESPONSE_OID));
    }

    @Nullable
    public static JSONFormattedResponseControl get(@NotNull IntermediateResponse response) throws LDAPException {
        return JSONFormattedResponseControl.get(response.getControl(JSON_FORMATTED_RESPONSE_OID));
    }

    @Nullable
    private static JSONFormattedResponseControl get(@Nullable Control c) throws LDAPException {
        if (c == null) {
            return null;
        }
        if (c instanceof JSONFormattedResponseControl) {
            return (JSONFormattedResponseControl)c;
        }
        return new JSONFormattedResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_JSON_FORMATTED_RESPONSE.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", JSON_FORMATTED_RESPONSE_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_JSON_FORMATTED_RESPONSE.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", this.encodedValue));
    }

    @NotNull
    public static JSONFormattedResponseControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new JSONFormattedResponseControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        JSONObject valueObject = jsonControl.getValueObject();
        List<JSONValue> controlValues = valueObject.getFieldAsArray(JSON_FIELD_CONTROLS);
        if (controlValues == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_RESPONSE_DECODE_VALUE_MISSING_CONTROLS.get(controlObject.toSingleLineString(), JSON_FIELD_CONTROLS));
        }
        if (controlValues.isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_RESPONSE_DECODE_VALUE_EMPTY_CONTROLS.get(controlObject.toSingleLineString(), JSON_FIELD_CONTROLS));
        }
        ArrayList<JSONObject> controlObjectsList = new ArrayList<JSONObject>(controlValues.size());
        for (JSONValue controlValue : controlValues) {
            if (controlValue instanceof JSONObject) {
                JSONObject embeddedControlObject = (JSONObject)controlValue;
                try {
                    new JSONControlDecodeHelper(embeddedControlObject, strict, true, false);
                    controlObjectsList.add(embeddedControlObject);
                    continue;
                }
                catch (LDAPException e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_RESPONSE_DECODE_VALUE_NOT_CONTROL.get(controlObject.toSingleLineString(), JSON_FIELD_CONTROLS, embeddedControlObject.toSingleLineString(), e.getMessage()), e);
                }
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_RESPONSE_DECODE_VALUE_CONTROL_NOT_OBJECT.get(controlObject.toSingleLineString(), JSON_FIELD_CONTROLS));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_CONTROLS)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_RESPONSE_DECODE_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new JSONFormattedResponseControl(valueObject, Collections.unmodifiableList(controlObjectsList));
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("JSONFormattedResponseControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", valueObject=");
        this.encodedValue.toSingleLineString(buffer);
        buffer.append(')');
    }
}

