/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.DisconnectHandler;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.concurrent.atomic.AtomicBoolean;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class DisconnectInfo {
    @NotNull
    private final AtomicBoolean handlerNotified;
    @NotNull
    private final DisconnectType type;
    private final int port;
    @NotNull
    private final LDAPConnection connection;
    @NotNull
    private final String host;
    @Nullable
    private final String message;
    @Nullable
    private final Throwable cause;

    DisconnectInfo(@NotNull LDAPConnection connection, @NotNull DisconnectType type, @Nullable String message, @Nullable Throwable cause) {
        Validator.ensureNotNull(connection);
        Validator.ensureNotNull((Object)type);
        this.connection = connection;
        this.type = type;
        this.message = message;
        this.cause = cause;
        this.handlerNotified = new AtomicBoolean(false);
        this.host = connection.getConnectedAddress();
        this.port = connection.getConnectedPort();
    }

    @NotNull
    DisconnectType getType() {
        return this.type;
    }

    @Nullable
    String getMessage() {
        return this.message;
    }

    @Nullable
    Throwable getCause() {
        return this.cause;
    }

    void notifyDisconnectHandler() {
        DisconnectHandler handler;
        boolean alreadyNotified = this.handlerNotified.getAndSet(true);
        if (alreadyNotified) {
            return;
        }
        ServerSet serverSet = this.connection.getServerSet();
        if (serverSet != null) {
            serverSet.handleConnectionClosed(this.connection, this.host, this.port, this.type, this.message, this.cause);
        }
        if ((handler = this.connection.getConnectionOptions().getDisconnectHandler()) != null) {
            handler.handleDisconnect(this.connection, this.host, this.port, this.type, this.message, this.cause);
        }
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    void toString(@NotNull StringBuilder buffer) {
        buffer.append("DisconnectInfo(type=");
        buffer.append(this.type.name());
        if (this.message != null) {
            buffer.append(", message='");
            buffer.append(this.message);
            buffer.append('\'');
        }
        if (this.cause != null) {
            buffer.append(", cause=");
            buffer.append(StaticUtils.getExceptionMessage(this.cause));
        }
        buffer.append(')');
    }
}

